/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.faces.dt.converter;

import com.sun.rave.designtime.DesignProperty;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.visualweb.faces.dt.AbstractPropertyJPanel;
import org.netbeans.modules.visualweb.faces.dt.converter.DateTimePatternPropertyEditor;

public class DateTimePatternPanel
extends AbstractPropertyJPanel {
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected JTextField nowOutputField;
    protected JTextField patternInputField;
    protected JTextField sampleInputField;
    protected JTextField sampleOutputField;
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.netbeans.modules.visualweb.faces.dt.converter.Bundle");
    String previousPattern;

    public DateTimePatternPanel(DateTimePatternPropertyEditor dateTimePatternPropertyEditor, DesignProperty designProperty) {
        super(dateTimePatternPropertyEditor, designProperty);
        this.updateNowOutputField();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void documentEvent(DocumentEvent documentEvent) {
        if (this.initializing) {
            return;
        }
        if (documentEvent.getDocument() == this.patternInputField.getDocument()) {
            this.handlePatternInputDocumentEvent(documentEvent);
        }
        if (documentEvent.getDocument() == this.sampleInputField.getDocument()) {
            this.handleSampleInputDocumentEvent(documentEvent);
        }
    }

    public DateTimePatternPropertyEditor getDateTimePatternPropertyEditor() {
        return (DateTimePatternPropertyEditor)this.getPropertyEditor();
    }

    protected String getPattern() {
        String string = this.patternInputField.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    protected String getSample() {
        String string = this.sampleInputField.getText();
        if (string == null) {
            string = "";
        }
        return string;
    }

    public void handlePatternInputDocumentEvent(DocumentEvent documentEvent) {
        this.updateNowOutputField();
        String string = this.getDateTimePatternPropertyEditor().getDesignProperty().getPropertyDescriptor().getName();
        this.propertyChangeSupport.firePropertyChange(string, this.previousPattern, this.getPattern());
        this.previousPattern = this.getPattern();
    }

    public void handleSampleInputDocumentEvent(DocumentEvent documentEvent) {
        this.updateSampleOutputField();
    }

    public void initializeComponents() {
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        jLabel.setHorizontalAlignment(2);
        jLabel.setText(bundle.getString("dateTime_pattern"));
        jLabel.setLabelFor(this.patternInputField);
        jLabel.setDisplayedMnemonic(bundle.getString("Pattern_mnemonic").charAt(0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel, gridBagConstraints);
        this.patternInputField = new JTextField();
        this.patternInputField.getDocument().addDocumentListener(this);
        this.patternInputField.setText(this.getPropertyEditor().getAsText());
        this.patternInputField.getAccessibleContext().setAccessibleName(bundle.getString("input_pattern"));
        this.patternInputField.getAccessibleContext().setAccessibleDescription(bundle.getString("input_pattern"));
        jLabel.setLabelFor(this.patternInputField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 280;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.patternInputField, gridBagConstraints);
        this.nowOutputField = new JTextField();
        this.nowOutputField.setText("");
        this.nowOutputField.setEditable(false);
        this.nowOutputField.getAccessibleContext().setAccessibleName(bundle.getString("output_pattern"));
        this.nowOutputField.getAccessibleContext().setAccessibleDescription(bundle.getString("output_pattern"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.nowOutputField, gridBagConstraints);
        jLabel = new JLabel();
        jLabel.setHorizontalAlignment(4);
        jLabel.setText(bundle.getString("test"));
        jLabel.setLabelFor(this.sampleInputField);
        jLabel.setDisplayedMnemonic(bundle.getString("Test_mnemonic").charAt(0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)jLabel, gridBagConstraints);
        this.sampleInputField = new JTextField();
        this.sampleInputField.getDocument().addDocumentListener(this);
        this.sampleInputField.setText("");
        this.sampleInputField.getAccessibleContext().setAccessibleName(bundle.getString("test"));
        this.sampleInputField.getAccessibleContext().setAccessibleDescription(bundle.getString("input_test"));
        jLabel.setLabelFor(this.sampleInputField);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 200;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.sampleInputField, gridBagConstraints);
        this.sampleOutputField = new JTextField();
        this.sampleOutputField.setText("");
        this.sampleOutputField.setEditable(false);
        this.sampleOutputField.getAccessibleContext().setAccessibleName(bundle.getString("test"));
        this.sampleOutputField.getAccessibleContext().setAccessibleDescription(bundle.getString("output_test"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        this.add((Component)this.sampleOutputField, gridBagConstraints);
    }

    protected void updateNowOutputField() {
        String string;
        try {
            Date date = new Date();
            String string2 = this.getPattern();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            string = simpleDateFormat.format(date);
        }
        catch (Throwable throwable) {
            string = "** ERROR: " + throwable.getMessage();
        }
        this.nowOutputField.setText(string);
    }

    protected void updateSampleOutputField() {
        String string;
        try {
            String string2 = this.getPattern();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2);
            String string3 = this.getSample();
            Date date = simpleDateFormat.parse(string3);
            DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
            string = dateFormat.format(date);
        }
        catch (Throwable throwable) {
            string = "** ERROR: " + throwable.getMessage();
        }
        this.sampleOutputField.setText(string);
    }
}

