/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.undo.UndoManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.wseditor.spi.WSEditor;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.ui.ErrorTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientTopComponent;
import org.netbeans.modules.websvc.wsitconf.ui.service.ServiceTopComponent;
import org.netbeans.modules.websvc.wsitconf.util.UndoManagerHolder;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class WSITEditor
implements WSEditor,
UndoManagerHolder {
    private static final Logger logger = Logger.getLogger(WSITEditor.class.getName());
    private UndoManager undoManager;
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();

    public String getTitle() {
        return NbBundle.getMessage(WSITEditor.class, (String)"EDITOR_TITLE");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JComponent createWSEditorComponent(Node node, JaxWsModel jaxWsModel) {
        JAXWSSupport jAXWSSupport;
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        final Project project = jaxWsModel != null ? FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile()) : null;
        boolean bl = false;
        if (client != null) {
            JAXWSClientSupport jAXWSClientSupport;
            if (project == null || (jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)project.getProjectDirectory())) == null) return new ErrorTopComponent(NbBundle.getMessage(WSITEditor.class, (String)"TXT_WSIT_NotSupported"));
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent != null) {
                        Object object = propertyChangeEvent.getNewValue();
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 != null && object == null && object2 instanceof Client) {
                            Client client = (Client)object2;
                        }
                    }
                }
            };
            jaxWsModel.addPropertyChangeListener(propertyChangeListener);
            bl = Util.isWsitSupported(project);
            if (!bl) return new ErrorTopComponent(NbBundle.getMessage(WSITEditor.class, (String)"TXT_WSIT_NotDetected", (Object)Util.getServerName(project)));
            try {
                WSDLModel wSDLModel = WSITModelSupport.getModel(node, jaxWsModel, this, true, this.createdFiles);
                WSDLModel wSDLModel2 = WSITModelSupport.getServiceModelForClient(jAXWSClientSupport, client);
                return new ClientTopComponent(client, jaxWsModel, wSDLModel, wSDLModel2, node);
            }
            catch (Exception exception) {
                logger.log(Level.SEVERE, null, exception);
                return new ErrorTopComponent(NbBundle.getMessage(WSITEditor.class, (String)"TXT_WSIT_NotSupported"));
            }
        }
        if (project == null || (jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)project.getProjectDirectory())) == null) return new ErrorTopComponent(NbBundle.getMessage(WSITEditor.class, (String)"TXT_WSIT_NotSupported"));
        JaxWsModel.ServiceListener serviceListener = new JaxWsModel.ServiceListener(){

            public void serviceAdded(String string, String string2) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serviceRemoved(String string) {
                block8: {
                    if (!jAXWSSupport.isFromWSDL(string)) {
                        JaxWsModel jaxWsModel = (JaxWsModel)project.getLookup().lookup(JaxWsModel.class);
                        Service service = jaxWsModel.findServiceByName(string);
                        String string2 = service.getImplementationClass();
                        String string3 = "wsit-" + string2;
                        if (string2 != null && string2.length() > 0) {
                            try {
                                FileObject fileObject;
                                if (jAXWSSupport.getWsdlFolder(true) == null || (fileObject = jAXWSSupport.getWsdlFolder(true).getParent().getFileObject(string3, "xml")) == null || !fileObject.isValid()) break block8;
                                FileLock fileLock = null;
                                try {
                                    fileLock = fileObject.lock();
                                    fileObject.delete(fileLock);
                                }
                                finally {
                                    if (fileLock != null) {
                                        fileLock.releaseLock();
                                    }
                                }
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        };
        jaxWsModel.addServiceListener(serviceListener);
        bl = Util.isWsitSupported(project);
        if (!bl) return new ErrorTopComponent(NbBundle.getMessage(WSITEditor.class, (String)"TXT_WSIT_NotDetected", (Object)Util.getServerName(project)));
        try {
            WSDLModel wSDLModel = WSITModelSupport.getModel(node, jaxWsModel, this, true, this.createdFiles);
            return new ServiceTopComponent(service, jaxWsModel, wSDLModel, node, this.getUndoManager());
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, null, exception);
            return new ErrorTopComponent(NbBundle.getMessage(WSITEditor.class, (String)"TXT_WSIT_NotSupported"));
        }
    }

    public void save(Node node, JaxWsModel jaxWsModel) {
        if (node == null) {
            return;
        }
        try {
            WSDLModel wSDLModel = WSITModelSupport.getModel(node, jaxWsModel, this, false, this.createdFiles);
            if (wSDLModel != null) {
                WSITModelSupport.save(wSDLModel);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, null, exception);
        }
    }

    public void cancel(Node node, JaxWsModel jaxWsModel) {
        FileObject fileObject5;
        WSDLModel wSDLModel;
        Object object;
        if (node == null) {
            return;
        }
        WSDLModel wSDLModel2 = null;
        FileObject fileObject2 = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject2 != null && (object = FileOwnerQuery.getOwner((FileObject)fileObject2)) != null && (wSDLModel = WSITModelSupport.getMainClientModel(fileObject5 = WSITEditor.getClientConfigFolder((Project)object))) != null) {
            Collection collection = wSDLModel.getDefinitions().getImports();
            for (Import import_ : collection) {
                try {
                    WSDLModel wSDLModel3 = import_.getImportedWSDLModel();
                    ModelSource modelSource = wSDLModel3.getModelSource();
                    FileObject fileObject3 = Utilities.getFileObject((ModelSource)modelSource);
                    wSDLModel.startTransaction();
                    if (this.createdFiles.contains(fileObject3)) {
                        wSDLModel.getDefinitions().removeImport(import_);
                    }
                    wSDLModel.endTransaction();
                    FileObject fileObject4 = Utilities.getFileObject((ModelSource)wSDLModel.getModelSource());
                    if (fileObject4 == null) {
                        logger.log(Level.INFO, "Cannot find fileobject in lookup for: " + wSDLModel.getModelSource());
                    }
                    try {
                        DataObject dataObject = DataObject.find((FileObject)fileObject4);
                        if (dataObject == null || !dataObject.isModified()) continue;
                        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
                        if (saveCookie != null) {
                            saveCookie.save();
                        }
                        dataObject.setModified(false);
                    }
                    catch (IOException iOException) {
                    }
                }
                catch (CatalogModelException catalogModelException) {
                    logger.log(Level.SEVERE, null, catalogModelException);
                }
            }
        }
        try {
            wSDLModel2 = WSITModelSupport.getModel(node, jaxWsModel, this, false, this.createdFiles);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (wSDLModel2 != null) {
            try {
                if (this.getUndoManager() != null) {
                    while (this.getUndoManager().canUndo()) {
                        this.getUndoManager().undo();
                    }
                }
            }
            catch (Exception exception) {
                logger.log(Level.INFO, null, exception);
            }
            object = Utilities.getFileObject((ModelSource)wSDLModel2.getModelSource());
            fileObject5 = null;
            try {
                fileObject5 = DataObject.find((FileObject)object);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                logger.log(Level.SEVERE, null, dataObjectNotFoundException);
            }
            if (fileObject5 != null) {
                try {
                    wSDLModel2.sync();
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, null, iOException);
                }
                fileObject5.setModified(false);
                fileObject5.setModified(true);
                fileObject5.setModified(false);
            }
        }
        if (this.createdFiles != null && this.createdFiles.size() > 0) {
            for (FileObject fileObject5 : this.createdFiles) {
                if (fileObject5 == null) continue;
                try {
                    wSDLModel = DataObject.find((FileObject)fileObject5);
                    if (wSDLModel == null) continue;
                    wSDLModel.delete();
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, null, iOException);
                }
            }
        }
    }

    public static FileObject getClientConfigFolder(Project project) {
        FileObject fileObject = null;
        Sources sources = ProjectUtils.getSources((Project)project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        Util.ProjectType projectType = Util.getProjectType(project);
        switch (projectType) {
            case UNKNOWN: 
            case CLIENT: 
            case WEB: {
                if (sourceGroupArray == null || sourceGroupArray.length <= 0) break;
                fileObject = sourceGroupArray[0].getRootFolder();
                if (fileObject != null) {
                    fileObject = fileObject.getFileObject("META-INF");
                }
                if (fileObject != null && fileObject.isValid()) break;
                try {
                    fileObject = sourceGroupArray[0].getRootFolder().createFolder("META-INF");
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, null, iOException);
                }
                break;
            }
            case EJB: {
                if (sourceGroupArray == null || sourceGroupArray.length <= 0) break;
                fileObject = sourceGroupArray[0].getRootFolder().getParent();
                if (fileObject != null) {
                    fileObject = fileObject.getFileObject("conf");
                }
                if (fileObject != null && fileObject.isValid()) break;
                try {
                    fileObject = sourceGroupArray[0].getRootFolder().createFolder("conf");
                    break;
                }
                catch (IOException iOException) {
                    logger.log(Level.SEVERE, null, iOException);
                }
            }
        }
        return fileObject;
    }

    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    public void setUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public String getDescription() {
        return NbBundle.getMessage(WSITEditor.class, (String)"WSIT_CONFIG_DESC");
    }
}

