/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.design;

import java.awt.Component;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.design.configuration.WSConfiguration;
import org.netbeans.modules.websvc.wsitconf.api.DesignerListenerProvider;
import org.netbeans.modules.websvc.wsitconf.design.ConfigRunnable;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TransportModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.xam.ComponentEvent;
import org.netbeans.modules.xml.xam.ComponentListener;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class MtomConfiguration
implements WSConfiguration {
    private Service service;
    private DataObject implementationFile;
    private Project project;
    private ArrayList<PropertyChangeListener> listeners = new ArrayList();
    private Collection<FileObject> createdFiles = new LinkedList<FileObject>();
    private Binding binding;
    private ComponentListener cl;
    private boolean clAdded = false;
    private PropertyChangeListener configCreationListener = null;

    public MtomConfiguration(final Service service, final FileObject fileObject) {
        try {
            this.service = service;
            this.implementationFile = DataObject.find((FileObject)fileObject);
            this.project = FileOwnerQuery.getOwner((FileObject)fileObject);
            this.binding = WSITModelSupport.getBinding(service, fileObject, this.project, false, this.createdFiles);
            this.cl = new ComponentListener(){

                private void update() {
                    boolean bl = TransportModelHelper.isMtomEnabled(MtomConfiguration.this.binding);
                    for (PropertyChangeListener propertyChangeListener : MtomConfiguration.this.listeners) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(MtomConfiguration.this, "value", null, bl);
                        propertyChangeListener.propertyChange(propertyChangeEvent);
                    }
                }

                public void valueChanged(ComponentEvent componentEvent) {
                    this.update();
                }

                public void childrenAdded(ComponentEvent componentEvent) {
                    this.update();
                }

                public void childrenDeleted(ComponentEvent componentEvent) {
                    this.update();
                }
            };
            if (this.binding != null) {
                this.addCListener(this.binding);
            } else {
                this.configCreationListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        MtomConfiguration.this.binding = WSITModelSupport.getBinding(service, fileObject, MtomConfiguration.this.project, false, MtomConfiguration.this.createdFiles);
                        MtomConfiguration.this.addCListener(MtomConfiguration.this.binding);
                        MtomConfiguration.this.cl.valueChanged(null);
                    }
                };
                DesignerListenerProvider.registerListener(this.configCreationListener);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
    }

    private synchronized void addCListener(Binding binding) {
        if (!this.clAdded && binding != null) {
            binding.getModel().addComponentListener(this.cl);
            this.clAdded = true;
        }
    }

    public Component getComponent() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(MtomConfiguration.class, (String)"DesignConfigPanel.mtomCB.text");
    }

    public Image getIcon() {
        return Utilities.loadImage((String)"org/netbeans/modules/websvc/wsitconf/resources/designer-mtom.gif");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(MtomConfiguration.class, (String)"DesignConfigPanel.mtomCB.text");
    }

    public boolean isSet() {
        if (this.binding != null) {
            return TransportModelHelper.isMtomEnabled(this.binding);
        }
        return false;
    }

    public void set() {
        this.switchIt(true);
    }

    public void unset() {
        this.switchIt(false);
    }

    private void switchIt(final boolean bl) {
        final ConfigRunnable configRunnable = new ConfigRunnable();
        SwingUtilities.invokeLater(configRunnable);
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    MtomConfiguration.this.binding = WSITModelSupport.getBinding(MtomConfiguration.this.service, MtomConfiguration.this.implementationFile.getPrimaryFile(), MtomConfiguration.this.project, true, MtomConfiguration.this.createdFiles);
                    if (MtomConfiguration.this.binding == null) {
                        return;
                    }
                    if (TransportModelHelper.isMtomEnabled(MtomConfiguration.this.binding) != bl) {
                        TransportModelHelper.enableMtom(MtomConfiguration.this.binding, bl);
                        WSITModelSupport.save((WSDLComponent)MtomConfiguration.this.binding);
                    }
                }
                finally {
                    configRunnable.stop();
                }
            }
        });
    }

    public void registerListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.add(propertyChangeListener);
    }

    public void unregisterListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.remove(propertyChangeListener);
    }

    protected void finalize() {
        if (this.binding != null) {
            this.binding.getModel().removeComponentListener(this.cl);
        }
    }

    public boolean isEnabled() {
        return true;
    }
}

