/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client.subpanels;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionVisualTheme;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class KerberosConfigPanel
extends JPanel {
    private WSDLComponent comp;
    private Project project = null;
    private boolean inSync = false;
    String servicePrincipal = null;
    String loginModule = null;
    boolean credentialDelegation = false;
    private JCheckBox credDelegationChBox;
    private JComboBox loginModuleCombo;
    private JLabel loginModuleLabel;
    private JTextField servicePrincipalField;
    private JLabel servicePrincipalLabel;

    public KerberosConfigPanel(WSDLComponent wSDLComponent, Project project) {
        this.comp = wSDLComponent;
        this.project = project;
        this.initComponents();
        this.loginModuleCombo.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.loginModuleLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.servicePrincipalLabel.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.servicePrincipalField.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.credDelegationChBox.setBackground(SectionVisualTheme.getDocumentBackgroundColor());
        this.sync();
    }

    private String getLoginModule() {
        return (String)this.loginModuleCombo.getSelectedItem();
    }

    private void setLoginModule(String string) {
        this.loginModuleCombo.setSelectedItem(string);
    }

    private String getServicePrincipal() {
        return String.valueOf(this.servicePrincipalField.getText());
    }

    private void setServicePrincipal(String string) {
        this.servicePrincipalField.setText(string);
    }

    public void sync() {
        this.inSync = true;
        this.servicePrincipal = ProprietarySecurityPolicyModelHelper.getServicePrincipal(this.comp);
        if (this.servicePrincipal != null) {
            this.setServicePrincipal(this.servicePrincipal);
        }
        this.loginModule = ProprietarySecurityPolicyModelHelper.getLoginModule(this.comp);
        if (this.loginModule != null) {
            this.setLoginModule(this.loginModule);
        }
        this.credentialDelegation = ProprietarySecurityPolicyModelHelper.isCredentialDelegation(this.comp);
        this.setChBox(this.credDelegationChBox, this.credentialDelegation);
        this.inSync = false;
    }

    public void storeState() {
        this.loginModule = this.getLoginModule();
        if (this.loginModule == null || this.loginModule.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setLoginModule(this.comp, null, true);
        } else {
            ProprietarySecurityPolicyModelHelper.setLoginModule(this.comp, this.loginModule, true);
        }
        this.servicePrincipal = this.getServicePrincipal();
        if (this.servicePrincipal == null || this.servicePrincipal.length() == 0) {
            ProprietarySecurityPolicyModelHelper.setServicePrincipal(this.comp, null, true);
        } else {
            ProprietarySecurityPolicyModelHelper.setServicePrincipal(this.comp, this.servicePrincipal, true);
        }
        this.credentialDelegation = this.getChBox(this.credDelegationChBox);
        ProprietarySecurityPolicyModelHelper.setCredentialDelegation(this.comp, this.credentialDelegation, true);
    }

    public Boolean getChBox(JCheckBox jCheckBox) {
        if (jCheckBox.isSelected()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private void setChBox(JCheckBox jCheckBox, Boolean bl) {
        if (bl == null) {
            jCheckBox.setSelected(false);
        } else {
            jCheckBox.setSelected(bl);
        }
    }

    private void initComponents() {
        this.servicePrincipalLabel = new JLabel();
        this.loginModuleLabel = new JLabel();
        this.loginModuleCombo = new JComboBox();
        this.credDelegationChBox = new JCheckBox();
        this.servicePrincipalField = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.servicePrincipalLabel, (String)NbBundle.getMessage(KerberosConfigPanel.class, (String)"LBL_KerberosConfigPanel_ServicePrincipal"));
        Mnemonics.setLocalizedText((JLabel)this.loginModuleLabel, (String)NbBundle.getMessage(KerberosConfigPanel.class, (String)"LBL_KerberosConfigPanel_LoginModule"));
        this.loginModuleCombo.setEditable(true);
        Mnemonics.setLocalizedText((AbstractButton)this.credDelegationChBox, (String)NbBundle.getMessage(KerberosConfigPanel.class, (String)"LBL_KerberosPanel_CredentialDelegation"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.loginModuleLabel).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.servicePrincipalLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.servicePrincipalField, -2, -1, -2).add((Component)this.loginModuleCombo, 0, 171, Short.MAX_VALUE))).add((Component)this.credDelegationChBox)).addContainerGap()));
        groupLayout.linkSize(new Component[]{this.loginModuleCombo, this.servicePrincipalField}, 1);
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.loginModuleLabel).add((Component)this.loginModuleCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.servicePrincipalLabel).add((Component)this.servicePrincipalField, -2, -1, -2)).addPreferredGap(0).add((Component)this.credDelegationChBox).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.linkSize(new Component[]{this.loginModuleCombo, this.servicePrincipalField}, 2);
    }
}

