/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.util.List;
import java.util.Set;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.glassfish.eecommon.api.JDBCDriverDeployHelper;
import org.netbeans.modules.glassfish.javaee.Hk2DeploymentManager;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.plugins.spi.JDBCDriverDeployer;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDriverDeployerImpl
implements JDBCDriverDeployer {
    private final File driverLoc;
    private final GlassfishModule commonSupport;
    private final boolean isLocal;

    public JDBCDriverDeployerImpl(Hk2DeploymentManager hk2DeploymentManager, OptionalDeploymentManagerFactory optionalDeploymentManagerFactory) {
        this.commonSupport = hk2DeploymentManager.getCommonServerSupport();
        String string = (String)this.commonSupport.getInstanceProperties().get("domainsfolder");
        this.isLocal = null != string && string.trim().length() >= 1;
        String string2 = (String)this.commonSupport.getInstanceProperties().get("domainname");
        this.driverLoc = new File(string + File.separator + string2 + File.separator + "lib");
    }

    public boolean supportsDeployJDBCDrivers(Target target) {
        boolean bl = this.isLocal;
        if (bl) {
            bl = Boolean.parseBoolean((String)this.commonSupport.getInstanceProperties().get("driverDeployOn"));
        }
        return bl;
    }

    public ProgressObject deployJDBCDrivers(Target target, Set<Datasource> set) {
        List list = JDBCDriverDeployHelper.getMissingDrivers((File)this.driverLoc, set);
        ProgressObject progressObject = JDBCDriverDeployHelper.getProgressObject((File)this.driverLoc, (List)list);
        if (list.size() > 0) {
            progressObject.addProgressListener(new ProgressListener(){

                public void handleProgressEvent(ProgressEvent progressEvent) {
                    if (progressEvent.getDeploymentStatus().isCompleted()) {
                        JDBCDriverDeployerImpl.this.commonSupport.restartServer(null);
                    }
                }
            });
        }
        RequestProcessor.getDefault().post((Runnable)progressObject);
        return progressObject;
    }
}

