/*
 * Decompiled with CFR 0.152.
 */
package com.nwoods.jgo;

import com.nwoods.jgo.DomDoc;
import com.nwoods.jgo.DomElement;
import com.nwoods.jgo.DomNode;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectCollection;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoStroke;
import com.nwoods.jgo.JGoText;
import java.awt.Point;

public class JGoLabeledLink
extends JGoLink {
    public static final int ChangedFromLabel = 251;
    public static final int ChangedMidLabel = 252;
    public static final int ChangedToLabel = 253;
    public static final int ChangedGrabChildSelection = 254;
    private JGoObject myFromLabel = null;
    private JGoObject myMidLabel = null;
    private JGoObject myToLabel = null;

    public JGoLabeledLink() {
        this.init();
    }

    public JGoLabeledLink(JGoPort from, JGoPort to) {
        super(from, to);
        this.init();
    }

    private final void init() {
        this.setInternalFlags(this.getInternalFlags() | 0x200);
    }

    public JGoObject copyObject(JGoCopyEnvironment env) {
        JGoLabeledLink newobj = (JGoLabeledLink)super.copyObject(env);
        if (newobj != null) {
            newobj.setFromLabel(env.copy(this.myFromLabel));
            newobj.setMidLabel(env.copy(this.myMidLabel));
            newobj.setToLabel(env.copy(this.myToLabel));
        }
        return newobj;
    }

    public void setGrabChildSelection(boolean bFlag) {
        boolean oldDraggable;
        boolean bl = oldDraggable = (this.getInternalFlags() & 0x200) != 0;
        if (oldDraggable != bFlag) {
            if (bFlag) {
                this.setInternalFlags(this.getInternalFlags() | 0x200);
            } else {
                this.setInternalFlags(this.getInternalFlags() & 0xFFFFFDFF);
            }
            this.update(254, oldDraggable ? 1 : 0, null);
        }
    }

    public boolean isGrabChildSelection() {
        return (this.getInternalFlags() & 0x200) != 0;
    }

    protected void ownerChange(JGoObjectCollection oldOwner, JGoObjectCollection newOwner, JGoObject mainObject) {
        super.ownerChange(oldOwner, newOwner, mainObject);
        if (oldOwner == null && newOwner != null) {
            JGoListPosition pos;
            JGoObjectCollection coll = newOwner;
            if (this.getParent() != null) {
                coll = this.getParent();
            }
            if ((pos = coll.findObject(this)) != null) {
                if (this.getFromLabel() != null) {
                    JGoObject from = this.getFromLabel();
                    if (from.getParent() != null) {
                        from.getParent().removeObject(from);
                    }
                    pos = coll.insertObjectAfter(pos, from);
                }
                if (this.getMidLabel() != null) {
                    JGoObject mid = this.getMidLabel();
                    if (mid.getParent() != null) {
                        mid.getParent().removeObject(mid);
                    }
                    pos = coll.insertObjectAfter(pos, mid);
                }
                if (this.getToLabel() != null) {
                    JGoObject to = this.getToLabel();
                    if (to.getParent() != null) {
                        to.getParent().removeObject(to);
                    }
                    pos = coll.insertObjectAfter(pos, to);
                }
            }
        } else if (oldOwner != null && newOwner == null && !this.isNoClearPorts() && !this.isChildOf(mainObject)) {
            oldOwner.removeObject(this.getFromLabel());
            oldOwner.removeObject(this.getMidLabel());
            oldOwner.removeObject(this.getToLabel());
        }
    }

    public void calculateStroke() {
        super.calculateStroke();
        this.positionLabels();
    }

    public void positionLabels() {
        int nPoints = this.getNumPoints();
        if (nPoints >= 2) {
            int by;
            int bx;
            int ay;
            int ax;
            JGoObject lab = this.getFromLabel();
            if (lab != null) {
                ax = this.getPointX(0);
                ay = this.getPointY(0);
                bx = this.getPointX(1);
                by = this.getPointY(1);
                if (nPoints == 2) {
                    this.positionEndLabel(lab, ax, ay, ax, ay, bx, by);
                } else {
                    this.positionEndLabel(lab, ax, ay, bx, by, this.getPointX(2), this.getPointY(2));
                }
            }
            this.layoutMidLabel();
            lab = this.getToLabel();
            if (lab != null) {
                ax = this.getPointX(nPoints - 1);
                ay = this.getPointY(nPoints - 1);
                bx = this.getPointX(nPoints - 2);
                by = this.getPointY(nPoints - 2);
                if (nPoints == 2) {
                    this.positionEndLabel(lab, ax, ay, ax, ay, bx, by);
                } else {
                    this.positionEndLabel(lab, ax, ay, bx, by, this.getPointX(nPoints - 3), this.getPointY(nPoints - 3));
                }
            }
        }
    }

    protected void positionEndLabel(JGoObject lab, int ax, int ay, int bx, int by, int cx, int cy) {
        int spot = 0;
        spot = ax < bx ? (by <= cy ? 7 : 1) : (ax > bx ? (by <= cy ? 5 : 3) : (ay < by ? (bx <= cx ? 3 : 1) : (ay > by ? (bx <= cx ? 5 : 7) : (bx <= cx ? (by <= cy ? 3 : 5) : (by <= cy ? 1 : 7)))));
        lab.setSpotLocation(spot, ax, ay);
    }

    public void layoutMidLabel() {
        if (this.isInitializing()) {
            return;
        }
        JGoObject lab = this.getMidLabel();
        if (lab != null) {
            int nPoints = this.getNumPoints();
            if (nPoints < 2) {
                return;
            }
            if (this.isCubic() && nPoints >= 4 && nPoints < 7) {
                Point a = this.getPoint(0);
                Point b = this.getPoint(1);
                Point c = this.getPoint(nPoints - 2);
                Point d = this.getPoint(nPoints - 1);
                Point v = new Point(0, 0);
                Point w = new Point(0, 0);
                JGoStroke.BezierMidPoint(a.x, a.y, b.x, b.y, c.x, c.y, d.x, d.y, v, w);
                this.positionMidLabel(lab, v.x, v.y, w.x, w.y);
                return;
            }
            int midEnd = nPoints / 2;
            if (nPoints % 2 == 0) {
                int ax = this.getPointX(midEnd - 1);
                int ay = this.getPointY(midEnd - 1);
                int bx = this.getPointX(midEnd);
                int by = this.getPointY(midEnd);
                this.positionMidLabel(lab, ax, ay, bx, by);
            } else {
                int cy;
                float d2y;
                int cx;
                float d2x;
                int by;
                float d1y;
                int ax = this.getPointX(midEnd - 1);
                int ay = this.getPointY(midEnd - 1);
                int bx = this.getPointX(midEnd);
                float d1x = bx - ax;
                if (d1x * d1x + (d1y = (float)((by = this.getPointY(midEnd)) - ay)) * d1y >= (d2x = (float)((cx = this.getPointX(midEnd + 1)) - bx)) * d2x + (d2y = (float)((cy = this.getPointY(midEnd + 1)) - by)) * d2y) {
                    this.positionMidLabel(lab, ax, ay, bx, by);
                } else {
                    this.positionMidLabel(lab, bx, by, cx, cy);
                }
            }
        }
    }

    protected void positionMidLabel(JGoObject lab, int ax, int ay, int bx, int by) {
        if (lab instanceof JGoText && Math.abs(ay - by) < 2 && !this.isCubic()) {
            lab.setSpotLocation(6, (ax + bx) / 2, (ay + by) / 2);
        } else {
            lab.setSpotLocation(0, (ax + bx) / 2, (ay + by) / 2);
        }
    }

    public void SVGWriteObject(DomDoc svgDoc, DomElement jGoElementGroup) {
        if (svgDoc.JGoXMLOutputEnabled()) {
            DomElement jGoLabeledLink = svgDoc.createJGoClassElement("com.nwoods.jgo.JGoLabeledLink", jGoElementGroup);
            svgDoc.registerReferencingNode(jGoLabeledLink, "fromlabel", this.getFromLabel());
            svgDoc.registerReferencingNode(jGoLabeledLink, "midlabel", this.getMidLabel());
            svgDoc.registerReferencingNode(jGoLabeledLink, "tolabel", this.getToLabel());
        }
        super.SVGWriteObject(svgDoc, jGoElementGroup);
    }

    public DomNode SVGReadObject(DomDoc svgDoc, JGoDocument jGoDoc, DomElement svgElement, DomElement jGoChildElement) {
        if (jGoChildElement != null) {
            String fromLabelId = jGoChildElement.getAttribute("fromlabel");
            String midLabelId = jGoChildElement.getAttribute("midlabel");
            String toLabelId = jGoChildElement.getAttribute("tolabel");
            svgDoc.registerReferencingObject(this, "fromlabel", fromLabelId);
            svgDoc.registerReferencingObject(this, "midlabel", midLabelId);
            svgDoc.registerReferencingObject(this, "tolabel", toLabelId);
            super.SVGReadObject(svgDoc, jGoDoc, svgElement, jGoChildElement.getNextSiblingJGoClassElement());
            return svgElement.getNextSibling();
        }
        return svgElement.getNextSibling();
    }

    public void SVGUpdateReference(String attr, Object referencedObject) {
        super.SVGUpdateReference(attr, referencedObject);
        if (attr.equals("fromlabel")) {
            this.setFromLabel((JGoObject)referencedObject);
        } else if (attr.equals("midlabel")) {
            this.setMidLabel((JGoObject)referencedObject);
        } else if (attr.equals("tolabel")) {
            this.setToLabel((JGoObject)referencedObject);
        }
    }

    public JGoObject getFromLabel() {
        return this.myFromLabel;
    }

    public void setFromLabel(JGoObject lab) {
        JGoObject oldlabel = this.myFromLabel;
        if (oldlabel != lab) {
            JGoObjectCollection thiscoll = this.getParent();
            if (thiscoll == null) {
                thiscoll = this.getLayer();
            }
            if (thiscoll == null) {
                thiscoll = this.getView();
            }
            if (oldlabel != null) {
                if (thiscoll != null) {
                    thiscoll.removeObject(oldlabel);
                }
                oldlabel.setPartner(null);
            }
            this.myFromLabel = lab;
            this.update(251, 0, oldlabel);
            if (lab != null) {
                if (lab == this.getMidLabel()) {
                    this.myMidLabel = null;
                    this.update(252, 0, lab);
                } else if (lab == this.getToLabel()) {
                    this.myToLabel = null;
                    this.update(253, 0, lab);
                } else {
                    lab.setPartner(this);
                    if (thiscoll != null) {
                        thiscoll.insertObjectAfter(thiscoll.findObject(this), lab);
                    }
                }
            }
            this.positionLabels();
        }
    }

    public JGoObject getMidLabel() {
        return this.myMidLabel;
    }

    public void setMidLabel(JGoObject lab) {
        JGoObject oldlabel = this.myMidLabel;
        if (oldlabel != lab) {
            JGoObjectCollection thiscoll = this.getParent();
            if (thiscoll == null) {
                thiscoll = this.getLayer();
            }
            if (thiscoll == null) {
                thiscoll = this.getView();
            }
            if (oldlabel != null) {
                if (thiscoll != null) {
                    thiscoll.removeObject(oldlabel);
                }
                oldlabel.setPartner(null);
            }
            this.myMidLabel = lab;
            this.update(252, 0, oldlabel);
            if (lab != null) {
                if (lab == this.getFromLabel()) {
                    this.myFromLabel = null;
                    this.update(251, 0, lab);
                } else if (lab == this.getToLabel()) {
                    this.myToLabel = null;
                    this.update(253, 0, lab);
                } else {
                    lab.setPartner(this);
                    if (thiscoll != null) {
                        thiscoll.insertObjectAfter(thiscoll.findObject(this), lab);
                    }
                }
            }
            this.positionLabels();
        }
    }

    public JGoObject getToLabel() {
        return this.myToLabel;
    }

    public void setToLabel(JGoObject lab) {
        JGoObject oldlabel = this.myToLabel;
        if (oldlabel != lab) {
            JGoObjectCollection thiscoll = this.getParent();
            if (thiscoll == null) {
                thiscoll = this.getLayer();
            }
            if (thiscoll == null) {
                thiscoll = this.getView();
            }
            if (oldlabel != null) {
                if (thiscoll != null) {
                    thiscoll.removeObject(oldlabel);
                }
                oldlabel.setPartner(null);
            }
            this.myToLabel = lab;
            this.update(253, 0, oldlabel);
            if (lab != null) {
                if (lab == this.getMidLabel()) {
                    this.myMidLabel = null;
                    this.update(252, 0, lab);
                } else if (lab == this.getFromLabel()) {
                    this.myFromLabel = null;
                    this.update(251, 0, lab);
                } else {
                    lab.setPartner(this);
                    if (thiscoll != null) {
                        thiscoll.insertObjectAfter(thiscoll.findObject(this), lab);
                    }
                }
            }
            this.positionLabels();
        }
    }

    public void update(int hint, int prevInt, Object prevVal) {
        if (this.isSuspendUpdates()) {
            return;
        }
        if (hint == 10) {
            JGoObjectCollection coll = this.getParent();
            if (coll == null) {
                coll = this.getLayer();
            }
            if (coll == null) {
                coll = this.getView();
            }
            if (coll == null) {
                return;
            }
            JGoListPosition pos = coll.findObject(this);
            if (pos == null) {
                return;
            }
            JGoObject lab = this.getFromLabel();
            if (lab != null) {
                pos = coll.insertObjectAfter(pos, lab);
            }
            if ((lab = this.getMidLabel()) != null) {
                pos = coll.insertObjectAfter(pos, lab);
            }
            if ((lab = this.getToLabel()) != null) {
                pos = coll.insertObjectAfter(pos, lab);
            }
        } else if (hint == 110 || hint == 103 || hint == 101 || hint == 102 || hint == 109 || hint == 203 || hint == 206) {
            this.positionLabels();
        }
        super.update(hint, prevInt, prevVal);
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getFlags()) {
            case 251: {
                e.setNewValue(this.getFromLabel());
                return;
            }
            case 252: {
                e.setNewValue(this.getMidLabel());
                return;
            }
            case 253: {
                e.setNewValue(this.getToLabel());
                return;
            }
            case 254: {
                e.setNewValueBoolean(this.isGrabChildSelection());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        switch (e.getFlags()) {
            case 251: {
                this.setFromLabel((JGoObject)e.getValue(undo));
                return;
            }
            case 252: {
                this.setMidLabel((JGoObject)e.getValue(undo));
                return;
            }
            case 253: {
                this.setToLabel((JGoObject)e.getValue(undo));
                return;
            }
            case 254: {
                this.setGrabChildSelection(e.getValueBoolean(undo));
                return;
            }
        }
        super.changeValue(e, undo);
    }
}

