/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.checkout;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.netbeans.lib.cvsclient.ClientServices;
import org.netbeans.lib.cvsclient.command.BasicCommand;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.lib.cvsclient.command.PipedFilesBuilder;
import org.netbeans.lib.cvsclient.command.TemporaryFileCreator;
import org.netbeans.lib.cvsclient.command.checkout.ModuleListBuilder;
import org.netbeans.lib.cvsclient.command.update.UpdateBuilder;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.EventManager;
import org.netbeans.lib.cvsclient.event.MessageEvent;
import org.netbeans.lib.cvsclient.event.ModuleExpansionEvent;
import org.netbeans.lib.cvsclient.request.ArgumentRequest;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.DirectoryRequest;
import org.netbeans.lib.cvsclient.request.ExpandModulesRequest;
import org.netbeans.lib.cvsclient.request.RootRequest;

public class CheckoutCommand
extends BasicCommand
implements TemporaryFileCreator {
    private static final String UPDATING = ": Updating ";
    private final Set emptyDirectories = new HashSet();
    private final List modules = new LinkedList();
    private final List expandedModules = new LinkedList();
    private boolean showModules;
    private boolean showModulesWithStatus;
    private boolean pipeToOutput;
    private boolean pruneDirectories;
    private boolean resetStickyOnes;
    private boolean useHeadIfNotFound;
    private boolean notShortenPaths;
    private boolean isNotShortenSet;
    private String checkoutByDate;
    private String checkoutByRevision;
    private String checkoutDirectory;
    private KeywordSubstitutionOptions keywordSubst;
    private boolean notRunModuleProgram;
    private ClientServices client;

    public CheckoutCommand(boolean bl, String[] stringArray) {
        this.resetCVSCommand();
        this.setRecursive(bl);
        this.setModules(stringArray);
    }

    public CheckoutCommand(boolean bl, String string) {
        this.resetCVSCommand();
        this.setRecursive(bl);
        this.setModule(string);
    }

    public CheckoutCommand() {
        this.resetCVSCommand();
        this.setRecursive(true);
    }

    public void setModule(String string) {
        this.modules.add(string);
    }

    public void clearModules() {
        this.modules.clear();
    }

    public void setModules(String[] stringArray) {
        this.clearModules();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            this.modules.add(string);
        }
    }

    public String[] getModules() {
        String[] stringArray = new String[this.modules.size()];
        stringArray = this.modules.toArray(stringArray);
        return stringArray;
    }

    private void processExistingModules(String string) {
        if (this.expandedModules.size() == 0) {
            return;
        }
        ArrayList<File> arrayList = new ArrayList<File>(this.expandedModules.size());
        File[] fileArray = this.expandedModules.iterator();
        while (fileArray.hasNext()) {
            String string2 = (String)fileArray.next();
            if (string2.equals(".")) {
                arrayList.add(new File(string));
                break;
            }
            File file = null;
            File file2 = new File(string, string2);
            file = file2.isFile() ? file2.getParentFile() : file2;
            File file3 = new File(file, "CVS/Repository");
            if (!file3.exists()) continue;
            arrayList.add(file2);
        }
        fileArray = new File[arrayList.size()];
        fileArray = arrayList.toArray(fileArray);
        this.setFiles(fileArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        clientServices.ensureConnection();
        this.client = clientServices;
        try {
            this.requests = new LinkedList();
            if (clientServices.isFirstCommand()) {
                this.requests.add(new RootRequest(clientServices.getRepository()));
            }
            if (this.showModules || this.showModulesWithStatus) {
                if (this.builder == null && !this.isBuilderSet()) {
                    this.builder = this.createBuilder(eventManager);
                }
                if (this.showModules) {
                    this.requests.add(new ArgumentRequest("-c"));
                }
                if (this.showModulesWithStatus) {
                    this.requests.add(new ArgumentRequest("-s"));
                }
                this.requests.add(CommandRequest.CHECKOUT);
                try {
                    clientServices.processRequests(this.requests);
                    this.requests.clear();
                }
                catch (CommandException commandException) {
                    throw commandException;
                }
                catch (EOFException eOFException) {
                    throw new CommandException(eOFException, CommandException.getLocalMessage("CommandException.EndOfFile", null));
                }
                catch (Exception exception) {
                    throw new CommandException(exception, exception.getLocalizedMessage());
                }
                return;
            }
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.requests.add(new ArgumentRequest(string));
            }
            this.expandedModules.clear();
            this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
            this.requests.add(new RootRequest(clientServices.getRepository()));
            this.requests.add(new ExpandModulesRequest());
            try {
                clientServices.processRequests(this.requests);
            }
            catch (CommandException commandException) {
                throw commandException;
            }
            catch (Exception exception) {
                throw new CommandException(exception, exception.getLocalizedMessage());
            }
            this.requests.clear();
            this.postExpansionExecute(clientServices, eventManager);
        }
        finally {
            this.client = null;
        }
    }

    protected boolean assumeLocalPathWhenUnspecified() {
        return false;
    }

    public void moduleExpanded(ModuleExpansionEvent moduleExpansionEvent) {
        this.expandedModules.add(moduleExpansionEvent.getModule());
    }

    private void postExpansionExecute(ClientServices clientServices, EventManager eventManager) throws CommandException, AuthenticationException {
        this.processExistingModules(clientServices.getLocalPath());
        super.execute(clientServices, eventManager);
        int n = this.requests.size();
        if (!this.isRecursive()) {
            this.requests.add(0, new ArgumentRequest("-l"));
        }
        if (this.pipeToOutput) {
            this.requests.add(0, new ArgumentRequest("-p"));
        }
        if (this.resetStickyOnes) {
            this.requests.add(0, new ArgumentRequest("-A"));
        }
        if (this.useHeadIfNotFound) {
            this.requests.add(0, new ArgumentRequest("-f"));
        }
        if (this.isNotShortenPaths()) {
            this.requests.add(0, new ArgumentRequest("-N"));
        }
        if (this.notRunModuleProgram) {
            this.requests.add(0, new ArgumentRequest("-n"));
        }
        if (this.checkoutByDate != null && this.checkoutByDate.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-D"));
            this.requests.add(1, new ArgumentRequest(this.getCheckoutByDate()));
        }
        if (this.checkoutByRevision != null && this.checkoutByRevision.length() > 0) {
            this.requests.add(0, new ArgumentRequest("-r"));
            this.requests.add(1, new ArgumentRequest(this.getCheckoutByRevision()));
        }
        if (this.checkoutDirectory != null && !this.checkoutDirectory.equals("")) {
            this.requests.add(0, new ArgumentRequest("-d"));
            this.requests.add(1, new ArgumentRequest(this.getCheckoutDirectory()));
        }
        if (this.getKeywordSubst() != null) {
            this.requests.add(0, new ArgumentRequest("-k" + this.getKeywordSubst()));
        }
        n = this.requests.size() - n;
        this.requests.add(n++, new ArgumentRequest("--"));
        Iterator iterator = this.modules.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.requests.add(n++, new ArgumentRequest(string));
        }
        this.requests.add(new DirectoryRequest(".", clientServices.getRepository()));
        this.requests.add(CommandRequest.CHECKOUT);
        try {
            clientServices.processRequests(this.requests);
            if (this.pruneDirectories) {
                this.pruneEmptyDirectories();
            }
            this.requests.clear();
        }
        catch (CommandException commandException) {
            throw commandException;
        }
        catch (Exception exception) {
            throw new CommandException(exception, exception.getLocalizedMessage());
        }
    }

    public boolean isShowModules() {
        return this.showModules;
    }

    public void setShowModules(boolean bl) {
        this.showModules = bl;
    }

    public boolean isShowModulesWithStatus() {
        return this.showModulesWithStatus;
    }

    public void setShowModulesWithStatus(boolean bl) {
        this.showModulesWithStatus = bl;
    }

    public void setPruneDirectories(boolean bl) {
        this.pruneDirectories = bl;
    }

    public boolean getPruneDirectories() {
        return this.pruneDirectories;
    }

    public boolean isPipeToOutput() {
        return this.pipeToOutput;
    }

    public void setPipeToOutput(boolean bl) {
        this.pipeToOutput = bl;
    }

    public boolean isResetStickyOnes() {
        return this.resetStickyOnes;
    }

    public void setResetStickyOnes(boolean bl) {
        this.resetStickyOnes = bl;
    }

    public boolean isUseHeadIfNotFound() {
        return this.useHeadIfNotFound;
    }

    public void setUseHeadIfNotFound(boolean bl) {
        this.useHeadIfNotFound = bl;
    }

    public boolean isNotShortenPaths() {
        return this.notShortenPaths || !this.isNotShortenSet && this.checkoutDirectory == null;
    }

    public void setNotShortenPaths(boolean bl) {
        this.notShortenPaths = bl;
        this.isNotShortenSet = true;
    }

    public boolean isNotRunModuleProgram() {
        return this.notRunModuleProgram;
    }

    public void setNotRunModuleProgram(boolean bl) {
        this.notRunModuleProgram = bl;
    }

    public String getCheckoutByDate() {
        return this.checkoutByDate;
    }

    public void setCheckoutByDate(String string) {
        this.checkoutByDate = string;
    }

    public String getCheckoutByRevision() {
        return this.checkoutByRevision;
    }

    public void setCheckoutByRevision(String string) {
        this.checkoutByRevision = string;
    }

    public String getCheckoutDirectory() {
        return this.checkoutDirectory;
    }

    public void setCheckoutDirectory(String string) {
        this.checkoutDirectory = string;
    }

    public KeywordSubstitutionOptions getKeywordSubst() {
        return this.keywordSubst;
    }

    public void setKeywordSubst(KeywordSubstitutionOptions keywordSubstitutionOptions) {
        this.keywordSubst = keywordSubstitutionOptions;
    }

    public Builder createBuilder(EventManager eventManager) {
        if (this.isShowModules() || this.isShowModulesWithStatus()) {
            return new ModuleListBuilder(eventManager, this);
        }
        if (this.isPipeToOutput()) {
            return new PipedFilesBuilder(eventManager, this, this);
        }
        return new UpdateBuilder(eventManager, this.getLocalDirectory());
    }

    public File createTempFile(String string) throws IOException {
        File file = File.createTempFile("cvs", ".dff", this.getGlobalOptions().getTempDir());
        file.deleteOnExit();
        return file;
    }

    public String getCVSCommand() {
        StringBuffer stringBuffer = new StringBuffer("checkout ");
        stringBuffer.append(this.getCVSArguments());
        if (!this.isShowModules() && !this.isShowModulesWithStatus()) {
            Iterator iterator = this.modules.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                stringBuffer.append(string);
                stringBuffer.append(' ');
            }
        }
        return stringBuffer.toString();
    }

    public boolean setCVSCommand(char c, String string) {
        if (c == 'c') {
            this.setShowModules(true);
        } else if (c == 's') {
            this.setShowModulesWithStatus(true);
        } else if (c == 'p') {
            this.setPipeToOutput(true);
        } else if (c == 'R') {
            this.setRecursive(true);
        } else if (c == 'l') {
            this.setRecursive(false);
        } else if (c == 'A') {
            this.setResetStickyOnes(true);
        } else if (c == 'f') {
            this.setUseHeadIfNotFound(true);
        } else if (c == 'P') {
            this.setPruneDirectories(true);
        } else if (c == 'D') {
            this.setCheckoutByDate(string.trim());
        } else if (c == 'r') {
            this.setCheckoutByRevision(string.trim());
        } else if (c == 'd') {
            this.setCheckoutDirectory(string);
        } else if (c == 'N') {
            this.setNotShortenPaths(true);
        } else if (c == 'n') {
            this.setNotRunModuleProgram(true);
        } else if (c == 'k') {
            KeywordSubstitutionOptions keywordSubstitutionOptions = KeywordSubstitutionOptions.findKeywordSubstOption(string);
            this.setKeywordSubst(keywordSubstitutionOptions);
        } else {
            return false;
        }
        return true;
    }

    public String getOptString() {
        return "cnpslNPRAD:r:fk:d:";
    }

    public void resetCVSCommand() {
        this.setShowModules(false);
        this.setShowModulesWithStatus(false);
        this.setPipeToOutput(false);
        this.setRecursive(true);
        this.setResetStickyOnes(false);
        this.setUseHeadIfNotFound(false);
        this.setCheckoutByDate(null);
        this.setCheckoutByRevision(null);
        this.setKeywordSubst(null);
        this.setPruneDirectories(false);
        this.setNotShortenPaths(false);
        this.isNotShortenSet = false;
        this.setNotRunModuleProgram(false);
        this.setCheckoutDirectory(null);
    }

    public String getCVSArguments() {
        StringBuffer stringBuffer = new StringBuffer("");
        if (this.isShowModules()) {
            stringBuffer.append("-c ");
        }
        if (this.isShowModulesWithStatus()) {
            stringBuffer.append("-s ");
        }
        if (this.isPipeToOutput()) {
            stringBuffer.append("-p ");
        }
        if (!this.isRecursive()) {
            stringBuffer.append("-l ");
        }
        if (this.isResetStickyOnes()) {
            stringBuffer.append("-A ");
        }
        if (this.isUseHeadIfNotFound()) {
            stringBuffer.append("-f ");
        }
        if (this.getPruneDirectories()) {
            stringBuffer.append("-P ");
        }
        if (this.isNotShortenPaths()) {
            stringBuffer.append("-N ");
        }
        if (this.isNotRunModuleProgram()) {
            stringBuffer.append("-n ");
        }
        if (this.getKeywordSubst() != null) {
            stringBuffer.append("-k");
            stringBuffer.append(this.getKeywordSubst());
            stringBuffer.append(' ');
        }
        if (this.getCheckoutByRevision() != null && this.getCheckoutByRevision().length() > 0) {
            stringBuffer.append("-r ");
            stringBuffer.append(this.getCheckoutByRevision());
            stringBuffer.append(' ');
        }
        if (this.getCheckoutByDate() != null && this.getCheckoutByDate().length() > 0) {
            stringBuffer.append("-D ");
            stringBuffer.append(this.getCheckoutByDate());
            stringBuffer.append(' ');
        }
        if (this.getCheckoutDirectory() != null) {
            stringBuffer.append("-d ");
            stringBuffer.append(this.getCheckoutDirectory());
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void messageSent(MessageEvent messageEvent) {
        super.messageSent(messageEvent);
        if (this.pruneDirectories && messageEvent.getMessage().indexOf(UPDATING) > 0) {
            String string = messageEvent.getMessage().substring(messageEvent.getMessage().indexOf(UPDATING) + UPDATING.length());
            File file = new File(this.getLocalDirectory(), string);
            if (string.indexOf(47) != -1) {
                this.emptyDirectories.add(file);
            }
        }
    }

    private boolean pruneEmptyDirectory(File file) throws IOException {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            File file2;
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isFile()) {
                    bl = false;
                } else if (!fileArray[i].getName().equals("CVS")) {
                    bl = this.pruneEmptyDirectory(fileArray[i]);
                }
                if (!bl) break;
            }
            if (bl && (file2 = new File(file, "CVS/Entries")).exists()) {
                File file3 = new File(file, "CVS");
                File[] fileArray2 = file3.listFiles();
                for (int i = 0; i < fileArray2.length; ++i) {
                    fileArray2[i].delete();
                }
                file3.delete();
                file.delete();
                this.client.removeEntry(file);
            }
        }
        return bl;
    }

    private void pruneEmptyDirectories() throws IOException {
        Iterator iterator = this.emptyDirectories.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            if (!file.exists()) continue;
            this.pruneEmptyDirectory(file);
        }
        this.emptyDirectories.clear();
    }
}

