/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.lexer.api;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.groovy.editor.lexer.GroovyTokenId;
import org.netbeans.modules.groovy.gsp.lexer.GspLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum GspTokenId implements TokenId
{
    HTML("html"),
    GROOVYCOMMENT("comment"),
    GROOVY_EXPR("groovy"),
    GROOVY("groovy"),
    DELIMITER("groovy-delimiter"),
    GTAG("gtag"),
    ERROR("gsp_error");

    public static final String MIME_TYPE = "application/x-gsp";
    private final String primaryCategory;
    private static final Language<GspTokenId> language;

    public static boolean isGroovy(TokenId tokenId) {
        return tokenId == GROOVY || tokenId == GROOVY_EXPR || tokenId == GROOVYCOMMENT;
    }

    private GspTokenId(String string2) {
        this.primaryCategory = string2;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<GspTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<GspTokenId>(){

            protected Collection<GspTokenId> createTokenIds() {
                return EnumSet.allOf(GspTokenId.class);
            }

            protected Map<String, Collection<GspTokenId>> createTokenCategories() {
                return null;
            }

            public Lexer<GspTokenId> createLexer(LexerRestartInfo<GspTokenId> lexerRestartInfo) {
                return new GspLexer(lexerRestartInfo);
            }

            protected LanguageEmbedding<? extends TokenId> embedding(Token<GspTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                switch ((GspTokenId)token.id()) {
                    case HTML: {
                        return LanguageEmbedding.create((Language)HTMLTokenId.language(), (int)0, (int)0, (boolean)true);
                    }
                    case GROOVY_EXPR: 
                    case GROOVY: {
                        return LanguageEmbedding.create((Language)GroovyTokenId.language(), (int)0, (int)0, (boolean)false);
                    }
                }
                return null;
            }

            public String mimeType() {
                return GspTokenId.MIME_TYPE;
            }
        }.language();
    }
}

