/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.ui.customizer;

import java.awt.EventQueue;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import org.netbeans.modules.xml.retriever.catalog.CatalogEntry;
import org.netbeans.modules.xml.retriever.catalog.CatalogWriteModel;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.netbeans.modules.xml.xam.ui.ModelCookie;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceDecorator;
import org.netbeans.modules.xml.xam.ui.customizer.ExternalReferenceNode;
import org.netbeans.modules.xml.xam.ui.customizer.WaitNode;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class RetrievedFilesChildren
extends Children.Keys {
    private CatalogWriteModel cwm;
    private ExternalReferenceDecorator decorator;

    public RetrievedFilesChildren(CatalogWriteModel catalogWriteModel, ExternalReferenceDecorator externalReferenceDecorator) {
        this.cwm = catalogWriteModel;
        this.decorator = externalReferenceDecorator;
    }

    protected Node[] createNodes(Object object) {
        if (object == WaitNode.WAIT_KEY) {
            return WaitNode.createNode();
        }
        if (object instanceof CatalogEntry) {
            CatalogEntry catalogEntry = (CatalogEntry)object;
            try {
                ModelSource modelSource = this.cwm.getModelSource(new URI(catalogEntry.getSource()));
                if (modelSource == null) {
                    return new Node[0];
                }
                FileObject fileObject = (FileObject)modelSource.getLookup().lookup(FileObject.class);
                if (fileObject == null) {
                    return new Node[0];
                }
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                if (dataObject == null) {
                    return new Node[0];
                }
                ModelCookie modelCookie = (ModelCookie)dataObject.getCookie(ModelCookie.class);
                if (modelCookie == null) {
                    return new Node[0];
                }
                Object t = modelCookie.getModel();
                if (t == null) {
                    return new Node[0];
                }
                String string = this.decorator.getNamespace((Model)t);
                RetrievedFileNode retrievedFileNode = new RetrievedFileNode(catalogEntry, string, Children.LEAF, this.decorator);
                retrievedFileNode.setDisplayName(catalogEntry.getSource());
                Children.Array array = new Children.Array();
                array.add(new Node[]{retrievedFileNode});
                return new Node[]{new RetrievedFileNode(catalogEntry, string, (Children)array, this.decorator)};
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (CatalogModelException catalogModelException) {
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new Node[0];
    }

    protected void addNotify() {
        this.setKeys(WaitNode.getKeys());
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                RetrievedFilesChildren.this.setKeys(RetrievedFilesChildren.this.cwm.getCatalogEntries());
            }
        });
    }

    protected void removeNotify() {
        this.setKeys(Collections.emptySet());
    }

    public static class RetrievedFileNode
    extends AbstractNode
    implements ExternalReferenceNode {
        private boolean valid;
        private String location;
        private String targetNS;
        private ExternalReferenceDecorator decorator;

        RetrievedFileNode(CatalogEntry catalogEntry, String string, Children children, ExternalReferenceDecorator externalReferenceDecorator) {
            super(children);
            this.location = catalogEntry.getSource();
            this.valid = catalogEntry.isValid();
            this.targetNS = string;
            this.decorator = externalReferenceDecorator;
            this.setName(string);
            if (string == null) {
                this.setDisplayName(NbBundle.getMessage(RetrievedFileNode.class, (String)"LBL_NoTargetNamespace"));
            }
            this.setIconBaseWithExtension("org/netbeans/modules/xml/xam/ui/customizer/Schema_File.png");
        }

        public String getLocation() {
            return this.location;
        }

        public String getNamespace() {
            return this.targetNS;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getHtmlDisplayName() {
            String string = super.getHtmlDisplayName();
            if (this.isValid()) {
                if (this.decorator != null) {
                    if (string == null) {
                        string = this.getDisplayName();
                    }
                    string = this.decorator.getHtmlDisplayName(string, this);
                }
            } else {
                return "<s>" + string == null ? this.getDisplayName() : string + "</s>";
            }
            return string;
        }

        public Model getModel() {
            return null;
        }

        public boolean hasModel() {
            return false;
        }
    }
}

