/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.bdjo;

import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.bd.tools.bdjo.AppName;
import net.java.bd.tools.bdjo.AppProfile;
import net.java.bd.tools.bdjo.BDJO;
import net.java.bd.tools.bdjo.Binding;
import net.java.bd.tools.bdjo.HexStringShortAdapter;
import net.java.bd.tools.bdjo.Visibility;

public class ApplicationDescriptor {
    public static final int NUM_PROFILES_BITS = 4;
    public static final int MAX_PROFILES = 16;
    public static final int NUM_ICON_BITS = 8;
    public static final int MAX_ICON_LENGTH = 256;
    public static final int NUM_BASEDIR_BITS = 8;
    public static final int MAX_BASEDIR_LENGTH = 256;
    public static final int NUM_CLASSPATH_BITS = 8;
    public static final int MAX_CLASSPATH_LENGTH = 256;
    public static final int NUM_CLASSNAME_BITS = 8;
    public static final int MAX_CLASSNAME_LENGTH = 256;
    public static final int NUM_PARAMETER_BITS = 8;
    public static final int MAX_PARAMETER_LENGTH = 256;
    private AppProfile[] profiles;
    private short priority;
    private Binding binding = Binding.TITLE_BOUND_DISC_BOUND;
    private Visibility visibility = Visibility.V_00;
    private AppName[] names;
    private String iconLocator;
    private short iconFlags;
    private String baseDirectory;
    private String classpathExtension;
    private String initialClassName;
    private String[] parameters;

    public AppProfile[] getProfiles() {
        return this.profiles;
    }

    public void setProfiles(AppProfile[] appProfileArray) {
        if (appProfileArray != null && appProfileArray.length > 16) {
            throw new IllegalArgumentException("overflow profiles : " + appProfileArray.length);
        }
        this.profiles = appProfileArray;
    }

    public short getPriority() {
        return this.priority;
    }

    public void setPriority(short s) {
        this.priority = s;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public String getIconLocator() {
        return this.iconLocator;
    }

    public void setIconLocator(String string) {
        if (string != null && string.length() >= 256) {
            throw new IllegalArgumentException("iconLocator length exceeded : " + string.length());
        }
        this.iconLocator = string;
    }

    @XmlJavaTypeAdapter(value=HexStringShortAdapter.class)
    public Short getIconFlags() {
        return this.iconFlags;
    }

    public void setIconFlags(Short s) {
        this.iconFlags = s;
    }

    public String getBaseDirectory() {
        return this.baseDirectory;
    }

    public void setBaseDirectory(String string) {
        if (string != null && string.length() >= 256) {
            throw new IllegalArgumentException("baseDirectory length exceeded : " + string.length());
        }
        this.baseDirectory = string;
    }

    public String getClasspathExtension() {
        return this.classpathExtension;
    }

    public void setClasspathExtension(String string) {
        int n;
        if (string != null && (n = string.length()) >= 256) {
            throw new IllegalArgumentException("classpathExtension length exceeded : " + n);
        }
        this.classpathExtension = string;
    }

    public String getInitialClassName() {
        return this.initialClassName;
    }

    public void setInitialClassName(String string) {
        int n;
        if (string != null && (n = BDJO.utf8Length(string)) >= 256) {
            throw new IllegalArgumentException("initialClassName length exceeded : " + n);
        }
        this.initialClassName = string;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] stringArray) {
        if (stringArray != null) {
            for (String string : stringArray) {
                int n = BDJO.utf8Length(string);
                if (n < 256) continue;
                throw new IllegalArgumentException("parameter length exceeded : " + n);
            }
        }
        this.parameters = stringArray;
    }

    public AppName[] getNames() {
        return this.names;
    }

    public void setNames(AppName[] appNameArray) {
        this.names = appNameArray;
    }
}

