/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.bdjo;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import net.java.bd.tools.bdjo.AppCacheEntry;
import net.java.bd.tools.bdjo.AppCacheInfo;
import net.java.bd.tools.bdjo.AppInfo;
import net.java.bd.tools.bdjo.AppName;
import net.java.bd.tools.bdjo.AppProfile;
import net.java.bd.tools.bdjo.ApplicationDescriptor;
import net.java.bd.tools.bdjo.ApplicationManagementTable;
import net.java.bd.tools.bdjo.BDJO;
import net.java.bd.tools.bdjo.BDJOWriter;
import net.java.bd.tools.bdjo.Binding;
import net.java.bd.tools.bdjo.HaviDeviceConfig;
import net.java.bd.tools.bdjo.TableOfAccessiblePlayLists;
import net.java.bd.tools.bdjo.TerminalInfo;
import net.java.bd.tools.bdjo.Version;
import net.java.bd.tools.bdjo.Visibility;

public final class BDJOReader {
    private static volatile ScriptEngine javaFxEngine;

    private BDJOReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initJavaFxEngine() {
        if (javaFxEngine != null) return;
        Class<BDJOReader> clazz = BDJOReader.class;
        synchronized (BDJOReader.class) {
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            javaFxEngine = scriptEngineManager.getEngineByName("FX");
            if (javaFxEngine != null) return;
            throw new RuntimeException("cannot load JavaFX engine, check your CLASSPATH");
        }
    }

    public static synchronized BDJO readFX(Reader reader) throws ScriptException {
        BDJOReader.initJavaFxEngine();
        return (BDJO)javaFxEngine.eval(reader);
    }

    public static synchronized BDJO readFX(String string) throws ScriptException {
        BDJOReader.initJavaFxEngine();
        return (BDJO)javaFxEngine.eval(string);
    }

    public static BDJO readXML(Reader reader) throws JAXBException {
        String string = BDJO.class.getName();
        String string2 = string.substring(0, string.lastIndexOf(46));
        JAXBContext jAXBContext = JAXBContext.newInstance((String)string2);
        Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
        unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
        return (BDJO)unmarshaller.unmarshal(reader);
    }

    public static BDJO readXML(String string) throws JAXBException {
        return BDJOReader.readXML(new StringReader(string));
    }

    private static String iso646String(byte[] byArray) {
        try {
            return new String(byArray, "ISO646-US");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static String readISO646String(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        return BDJOReader.iso646String(byArray);
    }

    private static String toUTF8String(byte[] byArray) {
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    private static String readUTF8String(DataInputStream dataInputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        dataInputStream.read(byArray);
        return BDJOReader.toUTF8String(byArray);
    }

    private static TerminalInfo readTerminalInfo(DataInputStream dataInputStream) throws IOException {
        TerminalInfo terminalInfo = new TerminalInfo();
        dataInputStream.skipBytes(4);
        terminalInfo.setDefaultFontFile(BDJOReader.readISO646String(dataInputStream, 5));
        byte by = dataInputStream.readByte();
        int n = (0xF0 & by) >> 4;
        HaviDeviceConfig[] haviDeviceConfigArray = HaviDeviceConfig.values();
        for (int i = 0; i < haviDeviceConfigArray.length; ++i) {
            HaviDeviceConfig haviDeviceConfig = haviDeviceConfigArray[i];
            if (haviDeviceConfig.getId() != n) continue;
            terminalInfo.setInitialHaviConfig(haviDeviceConfig);
            break;
        }
        terminalInfo.setMenuCallMask((by & 8) != 0);
        terminalInfo.setTitleSearchMask((by & 4) != 0);
        dataInputStream.skipBytes(4);
        return terminalInfo;
    }

    private static AppCacheInfo readAppCacheInfo(DataInputStream dataInputStream) throws IOException {
        AppCacheInfo appCacheInfo = new AppCacheInfo();
        dataInputStream.skipBytes(4);
        int n = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(1);
        AppCacheEntry[] appCacheEntryArray = new AppCacheEntry[n];
        int n2 = 12;
        for (int i = 0; i < appCacheEntryArray.length; ++i) {
            AppCacheEntry appCacheEntry = new AppCacheEntry();
            appCacheEntry.setType(dataInputStream.readByte());
            appCacheEntry.setName(BDJOReader.readISO646String(dataInputStream, 5));
            appCacheEntry.setLanguage(BDJOReader.readISO646String(dataInputStream, 3));
            appCacheEntryArray[i] = appCacheEntry;
            dataInputStream.skipBytes(3);
        }
        appCacheInfo.setEntries(appCacheEntryArray);
        return appCacheInfo;
    }

    private static TableOfAccessiblePlayLists readTableOfAccessiblePlayLists(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(4);
        int n = 0xFFFF & dataInputStream.readShort();
        int n2 = (n & 0xFFE0) >> 5;
        TableOfAccessiblePlayLists tableOfAccessiblePlayLists = new TableOfAccessiblePlayLists();
        tableOfAccessiblePlayLists.setAccessToAllFlag((n & 0x10) != 0);
        tableOfAccessiblePlayLists.setAutostartFirstPlayListFlag((n & 8) != 0);
        String[] stringArray = new String[n2];
        dataInputStream.skipBytes(2);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = BDJOReader.readISO646String(dataInputStream, 5);
            dataInputStream.skipBytes(1);
        }
        tableOfAccessiblePlayLists.setPlayListFileNames(stringArray);
        return tableOfAccessiblePlayLists;
    }

    private static ApplicationManagementTable readApplicationManagementTable(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(4);
        int n = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(1);
        AppInfo[] appInfoArray = new AppInfo[n];
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            AppInfo appInfo = new AppInfo();
            appInfo.setControlCode(dataInputStream.readByte());
            byte by = dataInputStream.readByte();
            appInfo.setType((byte)((by & 0xF0) >> 4));
            appInfo.setOrganizationId(dataInputStream.readInt());
            appInfo.setApplicationId(dataInputStream.readShort());
            dataInputStream.skipBytes(10);
            by = dataInputStream.readByte();
            int n7 = (by & 0xF0) >> 4;
            dataInputStream.skipBytes(1);
            AppProfile[] appProfileArray = new AppProfile[n7];
            for (int j = 0; j < n7; ++j) {
                AppProfile appProfile = new AppProfile();
                appProfile.setProfile(dataInputStream.readUnsignedShort());
                appProfile.setMajorVersion((short)dataInputStream.readUnsignedByte());
                appProfile.setMinorVersion((short)dataInputStream.readUnsignedByte());
                appProfile.setMicroVersion((short)dataInputStream.readUnsignedByte());
                dataInputStream.skipBytes(1);
                appProfileArray[j] = appProfile;
            }
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor();
            applicationDescriptor.setProfiles(appProfileArray);
            applicationDescriptor.setPriority((short)dataInputStream.readUnsignedByte());
            by = dataInputStream.readByte();
            int n8 = (by & 0xC0) >> 6;
            Binding[] bindingArray = Binding.values();
            for (n6 = 0; n6 < bindingArray.length; ++n6) {
                if (bindingArray[n6].ordinal() != n8) continue;
                applicationDescriptor.setBinding(bindingArray[n6]);
                break;
            }
            n6 = (by & 0x30) >> 4;
            Visibility[] visibilityArray = Visibility.values();
            for (n5 = 0; n5 < visibilityArray.length; ++n5) {
                if (visibilityArray[n5].ordinal() != n6) continue;
                applicationDescriptor.setVisibility(visibilityArray[n5]);
                break;
            }
            if ((n5 = dataInputStream.readUnsignedShort()) > 0) {
                Object object;
                ArrayList<Object> arrayList = new ArrayList<Object>();
                for (n3 = 0; n3 < n5; n3 += n4) {
                    object = new AppName();
                    ((AppName)object).setLanguage(BDJOReader.readISO646String(dataInputStream, 3));
                    n3 += 3;
                    n4 = dataInputStream.readUnsignedByte();
                    ++n3;
                    ((AppName)object).setName(BDJOReader.readUTF8String(dataInputStream, n4));
                    arrayList.add(object);
                }
                object = new AppName[]{};
                arrayList.toArray((T[])object);
                applicationDescriptor.setNames((AppName[])object);
            }
            if ((n5 & 1) != 0) {
                dataInputStream.skipBytes(1);
            }
            n3 = dataInputStream.readUnsignedByte();
            applicationDescriptor.setIconLocator(BDJOReader.readISO646String(dataInputStream, n3));
            if ((n3 & 1) == 0) {
                dataInputStream.skipBytes(1);
            }
            applicationDescriptor.setIconFlags(dataInputStream.readShort());
            int n9 = dataInputStream.readUnsignedByte();
            applicationDescriptor.setBaseDirectory(BDJOReader.readISO646String(dataInputStream, n9));
            if ((n9 & 1) == 0) {
                dataInputStream.skipBytes(1);
            }
            int n10 = dataInputStream.readUnsignedByte();
            applicationDescriptor.setClasspathExtension(BDJOReader.readISO646String(dataInputStream, n10));
            if ((n10 & 1) == 0) {
                dataInputStream.skipBytes(1);
            }
            n4 = dataInputStream.readUnsignedByte();
            applicationDescriptor.setInitialClassName(BDJOReader.readUTF8String(dataInputStream, n4));
            if ((n4 & 1) == 0) {
                dataInputStream.skipBytes(1);
            }
            if ((n2 = dataInputStream.readUnsignedByte()) > 0) {
                int n11;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = 0; j <= n2; j += n11) {
                    n11 = dataInputStream.readUnsignedByte();
                    ++j;
                    arrayList.add(BDJOReader.readUTF8String(dataInputStream, n11));
                }
                String[] stringArray = new String[]{};
                arrayList.toArray(stringArray);
                applicationDescriptor.setParameters(stringArray);
            }
            if ((n2 & 1) == 0) {
                dataInputStream.skipBytes(1);
            }
            appInfo.setApplicationDescriptor(applicationDescriptor);
            appInfoArray[i] = appInfo;
        }
        ApplicationManagementTable applicationManagementTable = new ApplicationManagementTable();
        applicationManagementTable.setApplications(appInfoArray);
        return applicationManagementTable;
    }

    public static BDJO readBDJO(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        String string = BDJOReader.readISO646String(dataInputStream, 4);
        if (!string.equals("BDJO")) {
            throw new IOException("BDJO magic is missing, not a bdjo file?");
        }
        String string2 = BDJOReader.readISO646String(dataInputStream, 4);
        BDJO bDJO = new BDJO();
        bDJO.setVersion(Version.valueOf("V_" + string2));
        dataInputStream.skipBytes(4);
        dataInputStream.skipBytes(4);
        dataInputStream.skipBytes(4);
        dataInputStream.skipBytes(4);
        dataInputStream.skipBytes(4);
        dataInputStream.skipBytes(4);
        dataInputStream.skipBytes(16);
        bDJO.setTerminalInfo(BDJOReader.readTerminalInfo(dataInputStream));
        bDJO.setAppCacheInfo(BDJOReader.readAppCacheInfo(dataInputStream));
        bDJO.setTableOfAccessiblePlayLists(BDJOReader.readTableOfAccessiblePlayLists(dataInputStream));
        bDJO.setApplicationManagementTable(BDJOReader.readApplicationManagementTable(dataInputStream));
        bDJO.setKeyInterestTable(dataInputStream.readInt());
        int n = dataInputStream.readUnsignedShort();
        bDJO.setFileAccessInfo(BDJOReader.readISO646String(dataInputStream, n));
        return bDJO;
    }

    public static void main(String[] stringArray) throws Exception {
        BDJO bDJO;
        if (stringArray[0].endsWith(".fx")) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            bDJO = BDJOReader.readFX(bufferedReader);
        } else if (stringArray[0].endsWith(".bdjo")) {
            bDJO = BDJOReader.readBDJO(new BufferedInputStream(new FileInputStream(stringArray[0])));
        } else {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(stringArray[0]));
            bDJO = BDJOReader.readXML(bufferedReader);
        }
        BDJOWriter.writeFX(bDJO, new PrintWriter(System.out));
    }
}

