/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.impl.support.APTIncludeResolverImpl;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTIncludeHandlerImpl
implements APTIncludeHandler {
    private List<String> systemIncludePaths;
    private List<String> userIncludePaths;
    private Map<String, Integer> recurseIncludes = null;
    private static final int MAX_INCLUDE_DEEP = 5;
    private Stack<APTIncludeHandler.IncludeInfo> inclStack = null;
    private StartEntry startFile;

    APTIncludeHandlerImpl(StartEntry startEntry) {
        this(startEntry, new ArrayList<String>(), new ArrayList<String>());
    }

    public APTIncludeHandlerImpl(StartEntry startEntry, List<String> list, List<String> list2) {
        this.startFile = startEntry;
        this.systemIncludePaths = list;
        this.userIncludePaths = list2;
    }

    @Override
    public boolean pushInclude(String string, int n, int n2) {
        return this.pushIncludeImpl(string, n, n2);
    }

    @Override
    public String popInclude() {
        return this.popIncludeImpl();
    }

    @Override
    public APTIncludeResolver getResolver(String string) {
        return new APTIncludeResolverImpl(string, this.getCurDirIndex(), this.systemIncludePaths, this.userIncludePaths);
    }

    @Override
    public StartEntry getStartEntry() {
        return this.startFile;
    }

    private String getCurPath() {
        assert (this.inclStack != null);
        APTIncludeHandler.IncludeInfo includeInfo = this.inclStack.peek();
        return includeInfo.getIncludedPath();
    }

    private int getCurDirIndex() {
        if (this.inclStack != null && !this.inclStack.empty()) {
            APTIncludeHandler.IncludeInfo includeInfo = this.inclStack.peek();
            return includeInfo.getIncludedDirIndex();
        }
        return 0;
    }

    @Override
    public APTIncludeHandler.State getState() {
        return this.createStateImpl();
    }

    @Override
    public void setState(APTIncludeHandler.State state) {
        if (state instanceof StateImpl) {
            StateImpl stateImpl = (StateImpl)state;
            assert (!stateImpl.isCleaned());
            stateImpl.restoreTo(this);
        }
    }

    protected StateImpl createStateImpl() {
        return new StateImpl(this);
    }

    private boolean pushIncludeImpl(String string, int n, int n2) {
        Integer n3;
        if (this.recurseIncludes == null) {
            assert (this.inclStack == null) : this.inclStack.toString() + " started on " + this.startFile;
            this.inclStack = new Stack();
            this.recurseIncludes = new HashMap<String, Integer>();
        }
        Integer n4 = n3 = (n3 = this.recurseIncludes.get(string)) == null ? new Integer(1) : new Integer(n3 + 1);
        if (n3 < 5) {
            this.recurseIncludes.put(string, n3);
            this.inclStack.push(new IncludeInfoImpl(string, n, n2));
            return true;
        }
        assert (this.recurseIncludes.get(string) != null) : "included file must be in map";
        APTUtils.LOG.log(Level.WARNING, "RECURSIVE inclusion:\n\t{0}\n\tin {1}\n", new Object[]{string, this.getCurPath()});
        return false;
    }

    private String popIncludeImpl() {
        assert (this.inclStack != null);
        assert (!this.inclStack.isEmpty());
        assert (this.recurseIncludes != null);
        APTIncludeHandler.IncludeInfo includeInfo = this.inclStack.pop();
        String string = includeInfo.getIncludedPath();
        Integer n = this.recurseIncludes.remove(string);
        assert (n != null) : "must be added before";
        n = new Integer(n - 1);
        assert (n >= 0) : "can't be negative";
        if (n != 0) {
            this.recurseIncludes.put(string, n);
        }
        return string;
    }

    public String toString() {
        return APTIncludeHandlerImpl.toString(this.startFile.getStartFile(), this.systemIncludePaths, this.userIncludePaths, this.recurseIncludes, this.inclStack);
    }

    private static String toString(String string, List<String> list, List<String> list2, Map<String, Integer> map, Stack<APTIncludeHandler.IncludeInfo> stack) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("User includes:\n");
        stringBuilder.append(APTUtils.includes2String(list2));
        stringBuilder.append("\nSys includes:\n");
        stringBuilder.append(APTUtils.includes2String(list));
        stringBuilder.append("\nInclude Stack starting from:\n");
        stringBuilder.append(string).append("\n");
        stringBuilder.append(APTIncludeHandlerImpl.includesStack2String(stack));
        return stringBuilder.toString();
    }

    private static String includesStack2String(Stack<APTIncludeHandler.IncludeInfo> stack) {
        StringBuilder stringBuilder = new StringBuilder();
        if (stack == null) {
            stringBuilder.append("<not from #include>");
        } else {
            Iterator iterator = stack.iterator();
            while (iterator.hasNext()) {
                APTIncludeHandler.IncludeInfo includeInfo = (APTIncludeHandler.IncludeInfo)iterator.next();
                stringBuilder.append(includeInfo);
                if (!iterator.hasNext()) continue;
                stringBuilder.append("->\n");
            }
        }
        return stringBuilder.toString();
    }

    private static final class IncludeInfoImpl
    implements APTIncludeHandler.IncludeInfo,
    SelfPersistent,
    Persistent {
        private final String path;
        private final int directiveLine;
        private final int resolvedDirIndex;

        public IncludeInfoImpl(String string, int n, int n2) {
            assert (string != null);
            this.path = string;
            assert (n >= 0);
            this.directiveLine = n;
            this.resolvedDirIndex = n2;
        }

        public IncludeInfoImpl(DataInput dataInput) throws IOException {
            assert (dataInput != null);
            APTStringManager aPTStringManager = FilePathCache.getManager();
            String string = dataInput.readUTF();
            this.path = aPTStringManager == null ? string : ((Object)aPTStringManager.getString((CharSequence)string)).toString();
            this.directiveLine = dataInput.readInt();
            this.resolvedDirIndex = dataInput.readInt();
        }

        public String getIncludedPath() {
            return this.path;
        }

        public int getIncludeDirectiveLine() {
            return this.directiveLine;
        }

        public String toString() {
            String string = "(" + this.getIncludeDirectiveLine() + ": " + this.getIncludedPath() + ":" + this.getIncludedDirIndex() + ")";
            return string;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            IncludeInfoImpl includeInfoImpl = (IncludeInfoImpl)object;
            return this.directiveLine == includeInfoImpl.directiveLine && this.path.equals(includeInfoImpl.path) && this.resolvedDirIndex == includeInfoImpl.resolvedDirIndex;
        }

        public int hashCode() {
            int n = 3;
            n = 73 * n + (this.path != null ? this.path.hashCode() : 0);
            n = 73 * n + this.directiveLine;
            n = 73 * n + this.resolvedDirIndex;
            return n;
        }

        public void write(DataOutput dataOutput) throws IOException {
            assert (dataOutput != null);
            dataOutput.writeUTF(this.path);
            dataOutput.writeInt(this.directiveLine);
            dataOutput.writeInt(this.resolvedDirIndex);
        }

        public int getIncludedDirIndex() {
            return this.resolvedDirIndex;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class StateImpl
    implements APTIncludeHandler.State,
    Persistent,
    SelfPersistent {
        private final List<String> systemIncludePaths;
        private final List<String> userIncludePaths;
        private final StartEntry startFile;
        private final Map<String, Integer> recurseIncludes;
        private final Stack<APTIncludeHandler.IncludeInfo> inclStack;

        protected StateImpl(APTIncludeHandlerImpl aPTIncludeHandlerImpl) {
            this.systemIncludePaths = aPTIncludeHandlerImpl.systemIncludePaths;
            this.userIncludePaths = aPTIncludeHandlerImpl.userIncludePaths;
            this.startFile = aPTIncludeHandlerImpl.startFile;
            if (aPTIncludeHandlerImpl.recurseIncludes != null && !aPTIncludeHandlerImpl.recurseIncludes.isEmpty()) {
                assert (aPTIncludeHandlerImpl.inclStack != null && !aPTIncludeHandlerImpl.inclStack.empty()) : "must be in sync with inclStack";
                this.recurseIncludes = new HashMap<String, Integer>();
                this.recurseIncludes.putAll(aPTIncludeHandlerImpl.recurseIncludes);
            } else {
                this.recurseIncludes = null;
            }
            if (aPTIncludeHandlerImpl.inclStack != null && !aPTIncludeHandlerImpl.inclStack.empty()) {
                assert (aPTIncludeHandlerImpl.recurseIncludes != null && !aPTIncludeHandlerImpl.recurseIncludes.isEmpty()) : "must be in sync with recurseIncludes";
                this.inclStack = new Stack();
                this.inclStack.addAll(aPTIncludeHandlerImpl.inclStack);
            } else {
                this.inclStack = null;
            }
        }

        private StateImpl(StateImpl stateImpl, boolean bl) {
            this.startFile = stateImpl.startFile;
            this.inclStack = stateImpl.inclStack;
            if (bl) {
                this.systemIncludePaths = Collections.emptyList();
                this.userIncludePaths = Collections.emptyList();
                this.recurseIncludes = null;
            } else {
                this.systemIncludePaths = stateImpl.systemIncludePaths;
                this.userIncludePaths = stateImpl.userIncludePaths;
                this.recurseIncludes = stateImpl.recurseIncludes;
            }
        }

        private void restoreTo(APTIncludeHandlerImpl aPTIncludeHandlerImpl) {
            aPTIncludeHandlerImpl.userIncludePaths = this.userIncludePaths;
            aPTIncludeHandlerImpl.systemIncludePaths = this.systemIncludePaths;
            aPTIncludeHandlerImpl.startFile = this.startFile;
            if (!this.isCleaned()) {
                if (this.recurseIncludes != null) {
                    aPTIncludeHandlerImpl.recurseIncludes = new HashMap();
                    aPTIncludeHandlerImpl.recurseIncludes.putAll(this.recurseIncludes);
                }
                if (this.inclStack != null) {
                    aPTIncludeHandlerImpl.inclStack = new Stack();
                    aPTIncludeHandlerImpl.inclStack.addAll(this.inclStack);
                }
            }
        }

        public String toString() {
            return APTIncludeHandlerImpl.toString(this.startFile.getStartFile(), this.systemIncludePaths, this.userIncludePaths, this.recurseIncludes, this.inclStack);
        }

        public void write(DataOutput dataOutput) throws IOException {
            Object object;
            Object object2;
            int n;
            assert (dataOutput != null);
            this.startFile.write(dataOutput);
            assert (this.systemIncludePaths != null);
            assert (this.userIncludePaths != null);
            int n2 = this.systemIncludePaths.size();
            dataOutput.writeInt(n2);
            for (n = 0; n < n2; ++n) {
                dataOutput.writeUTF(this.systemIncludePaths.get(n));
            }
            n2 = this.userIncludePaths.size();
            dataOutput.writeInt(n2);
            for (n = 0; n < n2; ++n) {
                dataOutput.writeUTF(this.userIncludePaths.get(n));
            }
            if (this.recurseIncludes == null) {
                dataOutput.writeInt(-1);
            } else {
                Set<Map.Entry<String, Integer>> set = this.recurseIncludes.entrySet();
                object2 = set.iterator();
                assert (set != null);
                assert (object2 != null);
                dataOutput.writeInt(set.size());
                while (object2.hasNext()) {
                    object = object2.next();
                    assert (object != null);
                    dataOutput.writeUTF(object.getKey());
                    dataOutput.writeInt(object.getValue());
                }
            }
            if (this.inclStack == null) {
                dataOutput.writeInt(-1);
            } else {
                n2 = this.inclStack.size();
                dataOutput.writeInt(n2);
                for (int i = 0; i < n2; ++i) {
                    object2 = (APTIncludeHandler.IncludeInfo)this.inclStack.get(i);
                    assert (object2 != null);
                    object = new IncludeInfoImpl(object2.getIncludedPath(), object2.getIncludeDirectiveLine(), object2.getIncludedDirIndex());
                    assert (object != null);
                    ((IncludeInfoImpl)object).write(dataOutput);
                }
            }
        }

        public StateImpl(DataInput dataInput) throws IOException {
            Object object;
            int n;
            assert (dataInput != null);
            APTStringManager aPTStringManager = FilePathCache.getManager();
            this.startFile = new StartEntry(dataInput);
            this.systemIncludePaths = new ArrayList<String>();
            int n2 = dataInput.readInt();
            for (n = 0; n < n2; ++n) {
                object = dataInput.readUTF();
                object = aPTStringManager == null ? object : ((Object)aPTStringManager.getString((CharSequence)object)).toString();
                this.systemIncludePaths.add(n, (String)object);
            }
            this.userIncludePaths = new ArrayList<String>();
            n2 = dataInput.readInt();
            for (n = 0; n < n2; ++n) {
                object = dataInput.readUTF();
                object = aPTStringManager == null ? object : ((Object)aPTStringManager.getString((CharSequence)object)).toString();
                this.userIncludePaths.add(n, (String)object);
            }
            n2 = dataInput.readInt();
            if (n2 == -1) {
                this.recurseIncludes = null;
            } else {
                this.recurseIncludes = new HashMap<String, Integer>();
                for (n = 0; n < n2; ++n) {
                    object = dataInput.readUTF();
                    object = aPTStringManager == null ? object : ((Object)aPTStringManager.getString((CharSequence)object)).toString();
                    Integer n3 = new Integer(dataInput.readInt());
                    this.recurseIncludes.put((String)object, n3);
                }
            }
            n2 = dataInput.readInt();
            if (n2 == -1) {
                this.inclStack = null;
            } else {
                this.inclStack = new Stack();
                for (n = 0; n < n2; ++n) {
                    object = new IncludeInfoImpl(dataInput);
                    assert (object != null);
                    this.inclStack.add(n, (APTIncludeHandler.IncludeInfo)object);
                }
            }
        }

        final StartEntry getStartEntry() {
            return this.startFile;
        }

        public boolean equals(Object object) {
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            StateImpl stateImpl = (StateImpl)object;
            return this.startFile.equals(stateImpl.startFile) && this.compareStacks(this.inclStack, stateImpl.inclStack);
        }

        public int hashCode() {
            int n = 5;
            n = 67 * n + (this.startFile != null ? this.startFile.hashCode() : 0);
            n = 67 * n + (this.inclStack != null ? this.inclStack.hashCode() : 0);
            return n;
        }

        private boolean compareStacks(Stack<APTIncludeHandler.IncludeInfo> stack, Stack<APTIncludeHandler.IncludeInfo> stack2) {
            if (stack != null) {
                int n = stack.size();
                if (stack2 == null || stack2.size() != n) {
                    return false;
                }
                for (int i = 0; i < n; ++i) {
                    APTIncludeHandler.IncludeInfo includeInfo;
                    APTIncludeHandler.IncludeInfo includeInfo2 = (APTIncludeHandler.IncludeInfo)stack.get(i);
                    if (includeInfo2.equals(includeInfo = (APTIncludeHandler.IncludeInfo)stack2.get(i))) continue;
                    return false;
                }
                return true;
            }
            return stack2 == null;
        }

        List<APTIncludeHandler.IncludeInfo> getIncludeStack() {
            return this.inclStack;
        }

        boolean isCleaned() {
            return this.recurseIncludes == null && this.inclStack != null;
        }

        APTIncludeHandler.State copy(boolean bl) {
            return new StateImpl(this, bl);
        }

        List<String> getSysIncludePaths() {
            return this.systemIncludePaths;
        }

        List<String> getUserIncludePaths() {
            return this.userIncludePaths;
        }
    }
}

