/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.File;
import java.util.List;
import org.netbeans.modules.cnd.apt.impl.support.PathsCollectionIterator;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTIncludeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APTIncludeResolverImpl
implements APTIncludeResolver {
    private final int baseFileIncludeDirIndex;
    private final String baseFile;
    private final List<String> systemIncludePaths;
    private final List<String> userIncludePaths;

    public APTIncludeResolverImpl(String string, int n, List<String> list, List<String> list2) {
        this.baseFile = string;
        this.systemIncludePaths = list;
        this.userIncludePaths = list2;
        this.baseFileIncludeDirIndex = n;
    }

    @Override
    public ResolvedPath resolveInclude(APTInclude aPTInclude, APTMacroCallback aPTMacroCallback) {
        return this.resolveFilePath(aPTInclude.getFileName(aPTMacroCallback), aPTInclude.isSystem(aPTMacroCallback), false);
    }

    @Override
    public ResolvedPath resolveIncludeNext(APTIncludeNext aPTIncludeNext, APTMacroCallback aPTMacroCallback) {
        return this.resolveFilePath(aPTIncludeNext.getFileName(aPTMacroCallback), aPTIncludeNext.isSystem(aPTMacroCallback), true);
    }

    public String getBasePath() {
        return this.baseFile;
    }

    private ResolvedPath resolveFilePath(String string, boolean bl, boolean bl2) {
        ResolvedPath resolvedPath = null;
        if (string != null && string.length() > 0) {
            resolvedPath = APTIncludeUtils.resolveAbsFilePath(string);
            if (resolvedPath == null && !bl && !bl2) {
                resolvedPath = APTIncludeUtils.resolveFilePath(string, this.baseFile);
            }
            if (resolvedPath == null) {
                int n = bl2 ? this.baseFileIncludeDirIndex + 1 : 0;
                String string2 = null;
                if (bl && this.baseFile != null) {
                    string2 = new File(this.baseFile).getParent();
                }
                PathsCollectionIterator pathsCollectionIterator = new PathsCollectionIterator(this.userIncludePaths, this.systemIncludePaths, n, string2);
                resolvedPath = APTIncludeUtils.resolveFilePath(pathsCollectionIterator, string, n);
            }
            if (resolvedPath == null && bl && !bl2) {
                resolvedPath = APTIncludeUtils.resolveFilePath(string, this.baseFile);
            }
        }
        return resolvedPath;
    }
}

