/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import antlr.TokenStreamException;
import java.io.File;
import java.util.logging.Level;
import org.netbeans.modules.cnd.apt.debug.DebugUtils;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTConditionResolver;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludeResolver;
import org.netbeans.modules.cnd.apt.support.APTMacroCallback;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.support.ResolvedPath;
import org.netbeans.modules.cnd.apt.utils.APTUtils;

public abstract class APTAbstractWalker
extends APTWalker {
    private final APTPreprocHandler preprocHandler;
    private final String startPath;

    protected APTAbstractWalker(APTFile aPTFile, APTPreprocHandler aPTPreprocHandler) {
        super(aPTFile, aPTPreprocHandler == null ? null : aPTPreprocHandler.getMacroMap());
        this.startPath = aPTFile.getPath();
        this.preprocHandler = aPTPreprocHandler;
    }

    protected void onInclude(APT aPT) {
        if (this.getIncludeHandler() != null) {
            APTIncludeResolver aPTIncludeResolver = this.getIncludeHandler().getResolver(this.startPath);
            ResolvedPath resolvedPath = aPTIncludeResolver.resolveInclude((APTInclude)aPT, this.getMacroMap());
            if (resolvedPath == null) {
                if (DebugUtils.STANDALONE) {
                    if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                        System.err.println("FAILED INCLUDE: from " + new File(this.startPath).getName() + " for:\n\t" + aPT);
                    }
                } else {
                    APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{this.startPath, aPT});
                }
            }
            this.include(resolvedPath, (APTInclude)aPT);
        }
    }

    protected void onIncludeNext(APT aPT) {
        if (this.getIncludeHandler() != null) {
            APTIncludeResolver aPTIncludeResolver = this.getIncludeHandler().getResolver(this.startPath);
            ResolvedPath resolvedPath = aPTIncludeResolver.resolveIncludeNext((APTIncludeNext)aPT, this.getMacroMap());
            if (resolvedPath == null) {
                if (DebugUtils.STANDALONE) {
                    if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                        System.err.println("FAILED INCLUDE: from " + new File(this.startPath).getName() + " for:\n\t" + aPT);
                    }
                } else {
                    APTUtils.LOG.log(Level.WARNING, "failed resolving path from {0} for {1}", new Object[]{this.startPath, aPT});
                }
            }
            this.include(resolvedPath, (APTInclude)aPT);
        }
    }

    protected abstract void include(ResolvedPath var1, APTInclude var2);

    protected void onDefine(APT aPT) {
        APTDefine aPTDefine = (APTDefine)aPT;
        if (aPTDefine.isValid()) {
            this.getMacroMap().define(aPTDefine.getName(), aPTDefine.getParams(), aPTDefine.getBody());
        } else if (DebugUtils.STANDALONE) {
            if (APTUtils.LOG.getLevel().intValue() <= Level.SEVERE.intValue()) {
                System.err.println("INCORRECT #define directive: in " + new File(this.startPath).getName() + " for:\n\t" + aPT);
            }
        } else {
            APTUtils.LOG.log(Level.SEVERE, "INCORRECT #define directive: in {0} for:\n\t{1}", new Object[]{new File(this.startPath).getName(), aPT});
        }
    }

    protected void onUndef(APT aPT) {
        APTUndefine aPTUndefine = (APTUndefine)aPT;
        this.getMacroMap().undef(aPTUndefine.getName());
    }

    protected boolean onIf(APT aPT) {
        return this.eval(aPT);
    }

    protected boolean onIfdef(APT aPT) {
        return this.eval(aPT);
    }

    protected boolean onIfndef(APT aPT) {
        return this.eval(aPT);
    }

    protected boolean onElif(APT aPT, boolean bl) {
        return !bl && this.eval(aPT);
    }

    protected boolean onElse(APT aPT, boolean bl) {
        return !bl;
    }

    protected void onEndif(APT aPT, boolean bl) {
    }

    protected APTPreprocHandler getPreprocHandler() {
        return this.preprocHandler;
    }

    protected APTIncludeHandler getIncludeHandler() {
        return this.getPreprocHandler() == null ? null : this.getPreprocHandler().getIncludeHandler();
    }

    private boolean eval(APT aPT) {
        APTUtils.LOG.log(Level.FINE, "eval condition for {0}", new Object[]{aPT});
        boolean bl = false;
        try {
            bl = APTConditionResolver.evaluate(aPT, (APTMacroCallback)this.getMacroMap());
        }
        catch (TokenStreamException tokenStreamException) {
            APTUtils.LOG.log(Level.SEVERE, "error on evaluating condition node " + aPT, tokenStreamException);
        }
        return bl;
    }
}

