/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.entitygenerator;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dbschema.ColumnElement;

class SQLType {
    private int sqlType;
    private String stringValue;
    private Class[] typeList;
    private boolean supportsFinder;
    private static final SQLType UNKNOWN = new SQLType(1111, "UNKNOWN", new Class[0], false);
    private static SoftReference typeCache = new SoftReference<Object>(null);

    private SQLType(int n, String string, Class[] classArray, boolean bl) {
        this.sqlType = n;
        this.stringValue = string;
        this.typeList = classArray;
        this.supportsFinder = bl;
    }

    public boolean equals(Object object) {
        if (object == null || !this.getClass().isInstance(object)) {
            return false;
        }
        return ((SQLType)object).sqlType == this.sqlType;
    }

    public int hashCode() {
        return this.sqlType;
    }

    public String toString() {
        return this.stringValue;
    }

    public int sqlType() {
        return this.sqlType;
    }

    String getMemberType(ColumnElement columnElement) {
        String string = Serializable.class.getName();
        Class clazz = null;
        if (columnElement.isCharacterType()) {
            clazz = this.getClassForCharType(columnElement.getLength(), columnElement.isNullable());
        } else if (columnElement.isNumericType()) {
            clazz = this.getClassForNumericType(columnElement.getPrecision(), columnElement.getScale(), columnElement.isNullable());
        }
        if (clazz != null) {
            return clazz.getName();
        }
        if (this.typeList.length > 0) {
            string = this.typeList[0].getName();
        }
        if (string.equals("[B")) {
            string = "byte []";
        }
        return string;
    }

    public String getFirstNonPrimitiveType() {
        String string = null;
        for (Class clazz : this.typeList) {
            if (clazz.isPrimitive()) continue;
            string = clazz.getName();
            break;
        }
        if ("[B".equals(string)) {
            string = "byte []";
        }
        return string;
    }

    private Class getClassForCharType(Integer n, boolean bl) {
        switch (this.sqlType) {
            case 1: {
                if (n == null || n != 1) break;
                return this.typeList[bl ? 1 : 2];
            }
        }
        return null;
    }

    private Class getClassForNumericType(Integer n, Integer n2, boolean bl) {
        int n3 = n == null ? -1 : n;
        int n4 = n2 == null ? -1 : n2;
        switch (this.sqlType) {
            case 2: 
            case 3: {
                if (n3 <= 0 && n4 <= 0) {
                    return BigInteger.class;
                }
                if (n4 > 0) {
                    return BigDecimal.class;
                }
                if (n3 > 18) {
                    return BigInteger.class;
                }
                if (n3 > 9) {
                    return bl ? Long.class : Long.TYPE;
                }
                if (n3 > 4) {
                    return bl ? Integer.class : Integer.TYPE;
                }
                return bl ? Short.class : Short.TYPE;
            }
            case -7: 
            case -6: 
            case -5: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return this.typeList[bl ? 0 : 1];
            }
        }
        return null;
    }

    public boolean supportsFinder() {
        return this.supportsFinder;
    }

    public static SQLType getSQLType(int n) {
        List list = SQLType.getSQLTypes();
        int n2 = list.indexOf(new SQLType(n, null, null, false));
        return n2 == -1 ? UNKNOWN : (SQLType)list.get(n2);
    }

    private static List getSQLTypes() {
        List list = (List)typeCache.get();
        if (list == null) {
            list = SQLType.getAllSQLTypes();
            typeCache = new SoftReference<List>(list);
        }
        return list;
    }

    private static List getAllSQLTypes() {
        return Arrays.asList(new SQLType(2003, "ARRAY", new Class[0], false), new SQLType(-5, "BIGINT", new Class[]{BigInteger.class, Long.TYPE}, true), new SQLType(3, "DECIMAL", new Class[]{BigDecimal.class, BigInteger.class, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE}, true), new SQLType(2, "NUMERIC", new Class[]{BigDecimal.class, BigInteger.class, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE}, true), new SQLType(2004, "BLOB", new Class[0], false), new SQLType(1, "CHAR", new Class[]{String.class, Character.class, Character.TYPE}, true), new SQLType(-1, "LONGVARCHAR", new Class[]{String.class}, true), new SQLType(12, "VARCHAR", new Class[]{String.class}, true), new SQLType(2005, "CLOB", new Class[]{String.class}, false), new SQLType(91, "DATE", new Class[]{Date.class}, false), new SQLType(6, "FLOAT", new Class[]{Double.class, Double.TYPE}, true), new SQLType(8, "DOUBLE", new Class[]{Double.class, Double.TYPE}, true), new SQLType(7, "REAL", new Class[]{Float.class, Float.TYPE}, true), new SQLType(4, "INTEGER", new Class[]{Integer.class, Integer.TYPE}, true), new SQLType(2000, "JAVA_OBJECT", new Class[0], false), new SQLType(0, "NULL", new Class[0], false), new SQLType(1111, "OTHER", new Class[]{Object.class}, true), new SQLType(2002, "STRUCT", new Class[0], false), new SQLType(2001, "DISTINCT", new Class[0], false), new SQLType(-2, "BINARY", new Class[]{byte[].class}, false), new SQLType(-7, "BIT", new Class[]{Boolean.class, Boolean.TYPE}, true), new SQLType(-3, "VARBINARY", new Class[]{byte[].class}, false), new SQLType(-4, "LONGVARBINARY", new Class[]{byte[].class}, false), new SQLType(2006, "REF", new Class[0], false), new SQLType(5, "SMALLINT", new Class[]{Short.class, Short.TYPE}, true), new SQLType(-6, "TINYINT", new Class[]{Short.class, Short.TYPE}, true), new SQLType(92, "TIME", new Class[]{Time.class}, false), new SQLType(93, "TIMESTAMP", new Class[]{Timestamp.class}, false));
    }
}

