/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.ant.freeform.Actions;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.LookupMerger;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupMergerImpl
implements LookupMerger<ActionProvider> {
    private static final Logger LOG = Logger.getLogger(LookupMergerImpl.class.getName());

    public Class<ActionProvider> getMergeableClass() {
        return ActionProvider.class;
    }

    public ActionProvider merge(Lookup lookup) {
        return new ActionProviderImpl(lookup);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ActionProviderImpl
    implements ActionProvider {
        private final Lookup lkp;

        public ActionProviderImpl(Lookup lookup) {
            this.lkp = lookup;
        }

        private Collection<? extends ActionProvider> delegates() {
            ActionProvider actionProvider = null;
            ArrayList<ActionProvider> arrayList = new ArrayList<ActionProvider>();
            for (ActionProvider actionProvider2 : this.lkp.lookupAll(ActionProvider.class)) {
                if (actionProvider2 instanceof Actions) {
                    assert (actionProvider == null);
                    actionProvider = actionProvider2;
                    continue;
                }
                assert (actionProvider2 != this);
                arrayList.add(actionProvider2);
            }
            assert (actionProvider != null);
            arrayList.add(0, actionProvider);
            return arrayList;
        }

        public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
            boolean bl = false;
            for (ActionProvider actionProvider : this.delegates()) {
                if (!Arrays.asList(actionProvider.getSupportedActions()).contains(string)) continue;
                bl = true;
                boolean bl2 = actionProvider.isActionEnabled(string, lookup);
                LOG.log(Level.FINE, "delegate {0} says enabled={1} for {2} in {3}", new Object[]{actionProvider, bl2, string, lookup});
                if (!bl2) continue;
                return true;
            }
            if (bl) {
                return false;
            }
            throw new IllegalArgumentException(string);
        }

        public void invokeAction(String string, Lookup lookup) throws IllegalArgumentException {
            for (ActionProvider actionProvider : this.delegates()) {
                if (!Arrays.asList(actionProvider.getSupportedActions()).contains(string) || !actionProvider.isActionEnabled(string, lookup)) continue;
                LOG.log(Level.FINE, "delegating {0} on {1} to {2}", new Object[]{string, lookup, actionProvider});
                actionProvider.invokeAction(string, lookup);
                return;
            }
            throw new IllegalArgumentException(string);
        }

        public String[] getSupportedActions() {
            HashSet<String> hashSet = new HashSet<String>();
            Collection<? extends ActionProvider> collection = this.delegates();
            for (ActionProvider actionProvider : collection) {
                hashSet.addAll(Arrays.asList(actionProvider.getSupportedActions()));
            }
            LOG.log(Level.FINE, "delegates {0} report supported actions {1}", new Object[]{collection, hashSet});
            return hashSet.toArray(new String[hashSet.size()]);
        }
    }
}

