/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.TestModuleDependency;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Evaluator
implements PropertyEvaluator,
PropertyChangeListener,
AntProjectListener {
    private final NbModuleProject project;
    private final NbModuleProvider typeProvider;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private PropertyEvaluator delegate;
    private boolean loadedModuleList = false;
    private boolean runInAtomicAction;
    private static final Pattern ANT_PROP_REGEX = Pattern.compile("\\$\\{([a-zA-Z0-9._-]+)\\}");
    private static final Set<String> warnedModules = Collections.synchronizedSet(new HashSet());

    public Evaluator(NbModuleProject nbModuleProject, NbModuleProvider nbModuleProvider) {
        this.project = nbModuleProject;
        this.typeProvider = nbModuleProvider;
        this.delegate = this.createEvaluator(null);
        this.delegate.addPropertyChangeListener((PropertyChangeListener)this);
        nbModuleProject.getHelper().addAntProjectListener((AntProjectListener)this);
    }

    public String getProperty(String string) {
        PropertyEvaluator propertyEvaluator = this.delegatingEvaluator(false);
        assert (propertyEvaluator != this);
        String string2 = propertyEvaluator.getProperty(string);
        if (string2 == null && this.isModuleListDependentProperty(string) || this.isModuleListDependentValue(string2)) {
            return this.delegatingEvaluator(true).getProperty(string);
        }
        return string2;
    }

    public String evaluate(String string) {
        String string2 = this.delegatingEvaluator(false).evaluate(string);
        if (this.isModuleListDependentValue(string2)) {
            return this.delegatingEvaluator(true).evaluate(string);
        }
        return string2;
    }

    public Map<String, String> getProperties() {
        return this.delegatingEvaluator(true).getProperties();
    }

    private boolean isModuleListDependentProperty(String string) {
        return string.equals("module.classpath") || string.equals("cp") || string.endsWith(".cp") || string.endsWith(".cp.extra") || string.equals("cluster") || string.endsWith(".dir") && string.lastIndexOf(46, string.length() - 5) == -1;
    }

    private boolean isModuleListDependentValue(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = ANT_PROP_REGEX.matcher(string);
        while (matcher.find()) {
            if (!this.isModuleListDependentProperty(matcher.group(1))) continue;
            return true;
        }
        return false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private PropertyEvaluator delegatingEvaluator(final boolean bl) {
        return (PropertyEvaluator)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<PropertyEvaluator>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public PropertyEvaluator run() {
                Evaluator evaluator = Evaluator.this;
                synchronized (evaluator) {
                    if (bl && !Evaluator.this.loadedModuleList) {
                        Evaluator.this.reset();
                        if (Util.err.isLoggable(1)) {
                            Util.err.log("Needed to reset evaluator in " + Evaluator.this.project + "due to use of module-list-dependent property; now cp=" + Evaluator.this.delegate.getProperty("cp"));
                        }
                    }
                    return Evaluator.this.delegate;
                }
            }
        });
    }

    private void reset() {
        ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void run() {
                ModuleList moduleList;
                try {
                    moduleList = Evaluator.this.project.getModuleList();
                }
                catch (IOException iOException) {
                    Util.err.notify(1, (Throwable)iOException);
                    return null;
                }
                Evaluator evaluator = Evaluator.this;
                synchronized (evaluator) {
                    Evaluator.this.loadedModuleList = true;
                    Evaluator.this.delegate.removePropertyChangeListener((PropertyChangeListener)Evaluator.this);
                    Evaluator.this.delegate = Evaluator.this.createEvaluator(moduleList);
                    Evaluator.this.delegate.addPropertyChangeListener((PropertyChangeListener)Evaluator.this);
                    Evaluator.this.pcs.firePropertyChange(null, null, null);
                    return null;
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("netbeans.dest.dir".equals(propertyChangeEvent.getPropertyName()) || propertyChangeEvent.getPropertyName() == null) {
            this.reset();
        } else {
            Util.err.log("Refiring property change from delegate in " + propertyChangeEvent.getPropertyName() + " for " + this.project);
            this.pcs.firePropertyChange(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if (!this.runInAtomicAction && antProjectEvent.getPath().equals("nbproject/project.xml")) {
            this.reset();
        }
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    public void setRunInAtomicAction(boolean bl) {
        assert (ProjectManager.mutex().isWriteAccess());
        this.runInAtomicAction = bl;
    }

    public void removeListeners() {
        this.project.getHelper().removeAntProjectListener((AntProjectListener)this);
        this.delegate.removePropertyChangeListener((PropertyChangeListener)this);
    }

    private PropertyEvaluator createEvaluator(ModuleList moduleList) {
        Object object;
        Serializable serializable;
        Object object2;
        Object object3;
        File file;
        PropertyProvider propertyProvider = this.project.getHelper().getStockPropertyPreprovider();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file2 = this.project.getProjectDirectoryFile();
        NbModuleProvider.NbModuleType nbModuleType = this.typeProvider.getModuleType();
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            file = ModuleList.findNetBeansOrg(file2);
            assert (file != null) : "netbeans.org-type module not in a complete netbeans.org source root " + file2;
            hashMap.put("nb_all", file.getAbsolutePath());
            hashMap.put("netbeans.dest.dir", new File(file, ModuleList.DEST_DIR_IN_NETBEANS_ORG).getAbsolutePath());
        } else {
            file = null;
        }
        String string = this.project.getCodeNameBase();
        if (moduleList != null) {
            for (ModuleEntry comparable2 : moduleList.getAllEntriesSoft()) {
                object3 = comparable2.getNetBeansOrgPath();
                if (object3 == null) continue;
                hashMap.put(((String)object3 + ".dir").intern(), comparable2.getClusterDirectory().getAbsolutePath().intern());
            }
            object2 = moduleList.getEntry(string);
            if (object2 != null) {
                assert (file == null ^ object2.getNetBeansOrgPath() != null) : object2;
                File file3 = object2.getClusterDirectory();
                hashMap.put("cluster", file3.getAbsolutePath());
            }
        }
        object2 = new ArrayList();
        object2.add(PropertyUtils.fixedPropertyProvider(hashMap));
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            object2.add(this.project.getHelper().getPropertyProvider("nbproject/private/suite-private.properties"));
            object2.add(this.project.getHelper().getPropertyProvider("nbproject/suite.properties"));
            PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])object2.toArray(new PropertyProvider[object2.size()]));
            object3 = propertyEvaluator.getProperty("suite.dir");
            if (object3 != null) {
                serializable = PropertyUtils.resolveFile((File)file2, (String)object3);
                object2.add(PropertyUtils.propertiesFilePropertyProvider((File)new File((File)serializable, "nbproject" + File.separatorChar + "private" + File.separatorChar + "platform-private.properties")));
                object2.add(PropertyUtils.propertiesFilePropertyProvider((File)new File((File)serializable, "nbproject" + File.separatorChar + "platform.properties")));
            }
        } else if (nbModuleType == NbModuleProvider.STANDALONE) {
            object2.add(this.project.getHelper().getPropertyProvider("nbproject/private/platform-private.properties"));
            object2.add(this.project.getHelper().getPropertyProvider("nbproject/platform.properties"));
        }
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT || nbModuleType == NbModuleProvider.STANDALONE) {
            PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])object2.toArray(new PropertyProvider[object2.size()]));
            object2.add(new Util.UserPropertiesFileProvider(propertyEvaluator, file2));
            PropertyEvaluator propertyEvaluator2 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])object2.toArray(new PropertyProvider[object2.size()]));
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class DestDirProvider
            extends Util.ComputedPropertyProvider {
                public DestDirProvider(PropertyEvaluator propertyEvaluator) {
                    super(propertyEvaluator);
                }

                @Override
                protected Map<String, String> getProperties(Map<String, String> map) {
                    String string = map.get("nbplatform.active");
                    if (string != null) {
                        return Collections.singletonMap("netbeans.dest.dir", "${nbplatform." + string + ".netbeans.dest.dir}");
                    }
                    return Collections.emptyMap();
                }

                @Override
                protected Set<String> inputProperties() {
                    return Collections.singleton("nbplatform.active");
                }
            }
            object2.add(new DestDirProvider(propertyEvaluator2));
        }
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            File file4 = new File(file, "nbbuild");
            object2.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(file4, "user.build.properties")));
            object2.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(file4, "site.build.properties")));
            object2.add(PropertyUtils.propertiesFilePropertyProvider((File)new File(System.getProperty("user.home"), ".nbbuild.properties")));
        }
        PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])object2.toArray(new PropertyProvider[object2.size()]));
        object2.add(new NbJdkProvider(propertyEvaluator));
        object2.add(this.project.getHelper().getPropertyProvider("nbproject/private/private.properties"));
        object2.add(this.project.getHelper().getPropertyProvider("nbproject/project.properties"));
        object3 = new HashMap();
        if (string != null) {
            object3.put("code.name.base.dashes", string.replace('.', '-'));
        }
        object3.put("module.jar.dir", "modules");
        object3.put("module.jar.basename", "${code.name.base.dashes}.jar");
        object3.put("module.jar", "${module.jar.dir}/${module.jar.basename}");
        object3.put("manifest.mf", "manifest.mf");
        object3.put("src.dir", "src");
        object3.put("build.classes.dir", "build/classes");
        object3.put("javac.source", "1.4");
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            object3.put("test.user.dir", "${nb_all}/nbbuild/testuserdir");
        } else if (nbModuleType == NbModuleProvider.STANDALONE) {
            object3.put("test.user.dir", "build/testuserdir");
        } else {
            object3.put("test.user.dir", "${suite.dir}/build/testuserdir");
        }
        serializable = new HashSet<String>(Arrays.asList(NbModuleProject.COMMON_TEST_TYPES));
        Object object4 = serializable.iterator();
        while (object4.hasNext()) {
            object = (String)object4.next();
            object3.put("test." + (String)object + ".src.dir", "test/" + (String)object + "/src");
            object3.put("test." + (String)object + ".data.dir", "test/" + (String)object + "/data");
            object3.put("build.test." + (String)object + ".classes.dir", "build/test/" + (String)object + "/classes");
        }
        object2.add(PropertyUtils.fixedPropertyProvider((Map)object3));
        if (moduleList != null) {
            object2.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap("module.classpath", this.computeModuleClasspath(moduleList))));
            object4 = new HashMap();
            object4.put("cp.extra", "");
            object4.put("cp", "${module.classpath}:${cp.extra}");
            object4.put("run.cp", this.computeRuntimeModuleClasspath(moduleList) + ":${cp.extra}:${build.classes.dir}");
            PropertyEvaluator propertyEvaluator3 = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])object2.toArray(new PropertyProvider[object2.size()]));
            object = this.computeTestingClassPaths(moduleList, propertyEvaluator3, (Set<String>)((Object)serializable));
            serializable.addAll(object.keySet());
            Iterator iterator = serializable.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                object4.put("test." + string2 + ".cp.extra", "");
                TestClasspath testClasspath = TestClasspath.getOrEmpty((Map)object, string2);
                object4.put("test." + string2 + ".cp", "${cp}:${cluster}/${module.jar}:${test." + string2 + ".cp.extra}:" + testClasspath.getCompileClasspath());
                object4.put("test." + string2 + ".run.cp.extra", "");
                object4.put("test." + string2 + ".run.cp", "${test." + string2 + ".cp}:${build.test." + string2 + ".classes.dir}:${test." + string2 + ".run.cp.extra}:" + testClasspath.getRuntimeClasspath());
            }
            object2.add(PropertyUtils.fixedPropertyProvider((Map)object4));
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])object2.toArray(new PropertyProvider[object2.size()]));
    }

    private String computeModuleClasspath(ModuleList moduleList) {
        Element element = this.project.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "module-dependencies", "http://www.netbeans.org/ns/nb-module-project/3");
        assert (element2 != null) : "Malformed metadata in " + this.project;
        StringBuffer stringBuffer = new StringBuffer();
        for (Element element3 : Util.findSubElements(element2)) {
            if (Util.findElement(element3, "compile-dependency", "http://www.netbeans.org/ns/nb-module-project/3") == null) continue;
            Element element4 = Util.findElement(element3, "code-name-base", "http://www.netbeans.org/ns/nb-module-project/3");
            String string = Util.findText(element4);
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            if (moduleEntry == null) {
                Util.err.log(16, "Warning - could not find dependent module " + string + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            File file = moduleEntry.getJarLocation();
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(file.getAbsolutePath());
            stringBuffer.append(moduleEntry.getClassPathExtensions());
        }
        ModuleEntry moduleEntry = moduleList.getEntry(this.project.getCodeNameBase());
        if (moduleEntry == null) {
            return "";
        }
        stringBuffer.append(moduleEntry.getClassPathExtensions());
        return stringBuffer.toString();
    }

    private String computeRuntimeModuleClasspath(ModuleList moduleList) {
        Object object;
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(this.project.getCodeNameBase());
        HashSet<String> hashSet2 = new HashSet<String>();
        StringBuffer stringBuffer = new StringBuffer();
        while (!hashSet.isEmpty()) {
            object = hashSet.iterator();
            String string = (String)object.next();
            object.remove();
            if (!hashSet2.add(string)) continue;
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            if (moduleEntry == null) {
                Util.err.log(16, "Warning - could not find dependent module " + string + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            if (!string.equals(this.project.getCodeNameBase())) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(File.pathSeparatorChar);
                }
                stringBuffer.append(moduleEntry.getJarLocation().getAbsolutePath());
                stringBuffer.append(moduleEntry.getClassPathExtensions());
            }
            String[] stringArray = moduleEntry.getRunDependencies();
            hashSet.addAll(Arrays.asList(stringArray));
        }
        object = moduleList.getEntry(this.project.getCodeNameBase());
        if (object != null) {
            stringBuffer.append(object.getClassPathExtensions());
        }
        return stringBuffer.toString();
    }

    private Map<String, TestClasspath> computeTestingClassPaths(ModuleList moduleList, PropertyEvaluator propertyEvaluator, Set<String> set) {
        HashMap<String, TestClasspath> hashMap = new HashMap<String, TestClasspath>();
        ProjectXMLManager projectXMLManager = new ProjectXMLManager(this.project);
        Map<String, Set<TestModuleDependency>> map = projectXMLManager.getTestDependencies(moduleList);
        String string = propertyEvaluator.getProperty("test.dist.dir");
        if (string == null) {
            Object object2 = this.typeProvider.getModuleType();
            if (object2 == NbModuleProvider.NETBEANS_ORG) {
                String object = propertyEvaluator.getProperty("nb_all");
                string = object + File.separatorChar + "nbbuild" + File.separatorChar + "build" + File.separatorChar + "testdist";
            } else if (object2 == NbModuleProvider.SUITE_COMPONENT) {
                String string2 = propertyEvaluator.getProperty("suite.dir");
                string = string2 + File.separatorChar + "build" + File.separatorChar + "testdist";
            } else {
                String string3 = propertyEvaluator.getProperty("module.dir");
                string = string3 + File.separatorChar + "build" + File.separatorChar + "testdist";
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            this.computeTestType((String)entry.getKey(), new File(string), (Set)entry.getValue(), hashMap, moduleList);
        }
        for (String string4 : set) {
            if (map.containsKey(string4)) continue;
            this.computeTestType(string4, new File(string), Collections.<TestModuleDependency>emptySet(), hashMap, moduleList);
        }
        return hashMap;
    }

    private void computeTestType(String string, File file, Set<TestModuleDependency> set, Map<String, TestClasspath> map, ModuleList moduleList) {
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        HashSet<String> hashSet3 = new HashSet<String>();
        HashSet<String> hashSet4 = new HashSet<String>();
        HashSet<String> hashSet5 = new HashSet<String>();
        boolean bl = false;
        for (TestModuleDependency object2 : set) {
            String string2 = object2.getModule().getCodeNameBase();
            bl |= string2.equals("org.netbeans.libs.junit4");
            if (object2.isTest()) {
                if (object2.isCompile()) {
                    hashSet3.add(string2);
                }
                hashSet4.add(string2);
            }
            if (object2.isRecursive()) {
                this.processTestEntryRecursive(object2, hashSet, hashSet2, hashSet5, moduleList);
                continue;
            }
            hashSet2.add(string2);
            if (!object2.isCompile()) continue;
            hashSet.add(string2);
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!bl) {
            if (moduleList.getEntry("org.netbeans.libs.junit4") == null) {
                String[] stringArray;
                for (String string3 : stringArray = new String[]{"${nb_all}/xtest/lib/insanelib.jar", "${nb_all}/xtest/lib/junit.jar", "${nb_all}/xtest/lib/nbjunit-ide.jar", "${nb_all}/xtest/lib/nbjunit.jar", "${netbeans.dest.dir}/../../xtest/lib/insanelib.jar", "${netbeans.dest.dir}/../../xtest/lib/junit.jar", "${netbeans.dest.dir}/../../xtest/lib/nbjunit.jar", "${netbeans.dest.dir}/ide6/modules/ext/junit-3.8.1.jar", "${netbeans.dest.dir}/java2/modules/ext/junit-3.8.2.jar", "${netbeans.dest.dir}/java2/modules/ext/junit-4.1.jar", "${netbeans.dest.dir}/testtools/modules/ext/insanelib.jar", "${netbeans.dest.dir}/testtools/modules/ext/nbjunit.jar", "${netbeans.dest.dir}/testtools/modules/org-netbeans-modules-nbjunit-ide.jar", "${netbeans.dest.dir}/testtools/modules/org-netbeans-modules-nbjunit.jar", "${netbeans.home}/../ide6/modules/ext/junit-3.8.1.jar", "${netbeans.home}/../java2/modules/ext/junit-3.8.2.jar", "${netbeans.home}/../java2/modules/ext/junit-4.1.jar", "${netbeans.home}/../testtools/modules/ext/insanelib.jar", "${netbeans.home}/../testtools/modules/ext/nbjunit.jar", "${netbeans.home}/../testtools/modules/org-netbeans-modules-nbjunit-ide.jar", "${netbeans.home}/../testtools/modules/org-netbeans-modules-nbjunit.jar", "${netbeans.user}/modules/ext/insanelib.jar", "${netbeans.user}/modules/ext/nbjunit.jar", "${netbeans.user}/modules/org-netbeans-modules-nbjunit-ide.jar", "${netbeans.user}/modules/org-netbeans-modules-nbjunit.jar"}) {
                    stringBuilder.append(":");
                    stringBuilder.append(string3);
                }
                if (string.startsWith("qa-")) {
                    stringBuilder.append(":${nb_all}/jemmy/builds/jemmy.jar:${nb_all}/jellytools/builds/jelly2-nb.jar");
                }
            } else {
                String[] stringArray = new String[]{"org.netbeans.libs.junit4", "org.netbeans.modules.nbjunit", "org.netbeans.insane"};
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String string4 = stringArray[i];
                    hashSet.add(string4);
                    hashSet2.add(string4);
                }
                if (string.startsWith("qa-")) {
                    hashSet3.add("org.netbeans.modules.java.j2seproject");
                    hashSet4.add("org.netbeans.modules.java.j2seproject");
                    for (String string4 : new String[]{"org.netbeans.modules.jemmy", "org.netbeans.modules.jellytools"}) {
                        hashSet.add(string4);
                        hashSet2.add(string4);
                    }
                }
            }
        }
        TestClasspath testClasspath = new TestClasspath(this.mergePaths(hashSet, false, string, file, moduleList) + stringBuilder, this.mergePaths(hashSet2, false, string, file, moduleList) + stringBuilder, this.mergePaths(hashSet3, true, string, file, moduleList), this.mergePaths(hashSet4, true, string, file, moduleList));
        map.put(string, testClasspath);
    }

    private void processTestEntryRecursive(TestModuleDependency testModuleDependency, Set<String> set, Set<String> set2, Set<String> set3, ModuleList moduleList) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(testModuleDependency.getModule().getCodeNameBase());
        while (!hashSet.isEmpty()) {
            Iterator iterator = hashSet.iterator();
            String string = (String)iterator.next();
            iterator.remove();
            if (!set3.add(string)) continue;
            ModuleEntry moduleEntry = moduleList.getEntry(string);
            if (moduleEntry == null) {
                Util.err.log(16, "Warning - could not find dependent module " + string + " for " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()));
                continue;
            }
            if (!string.equals(this.project.getCodeNameBase())) {
                set2.add(string);
                if (testModuleDependency.isCompile()) {
                    set.add(string);
                }
            }
            String[] stringArray = moduleEntry.getRunDependencies();
            hashSet.addAll(Arrays.asList(stringArray));
        }
    }

    private String mergePaths(Set<String> set, boolean bl, String string, File file, ModuleList moduleList) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string2 : set) {
            ModuleEntry moduleEntry = moduleList.getEntry(string2);
            if (moduleEntry == null) {
                if (!warnedModules.add(string2)) continue;
                Logger.getLogger(Evaluator.class.getName()).warning("Cannot find test module dependency: " + string2);
                continue;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.append(':');
            }
            if (bl) {
                File file2 = moduleEntry.getClusterDirectory();
                if (file2 == null) continue;
                String string3 = file2.getName();
                char c = File.separatorChar;
                File file3 = new File(file, string + c + string3 + c + string2.replace('.', '-') + c + "tests.jar");
                stringBuffer.append(file3.getPath());
                if (string.equals("unit")) continue;
                stringBuffer.append(':');
                file3 = new File(file, "unit" + c + string3 + c + string2.replace('.', '-') + c + "tests.jar");
                stringBuffer.append(file3.getPath());
                continue;
            }
            stringBuffer.append(moduleEntry.getJarLocation().getPath());
            stringBuffer.append(moduleEntry.getClassPathExtensions());
        }
        return stringBuffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NbJdkProvider
    implements PropertyProvider,
    PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final PropertyChangeListener weakListener = WeakListeners.propertyChange((PropertyChangeListener)this, null);

        public NbJdkProvider(PropertyEvaluator propertyEvaluator) {
            this.eval = propertyEvaluator;
            propertyEvaluator.addPropertyChangeListener(this.weakListener);
            JavaPlatformManager.getDefault().addPropertyChangeListener(this.weakListener);
        }

        public final Map<String, String> getProperties() {
            Object object;
            String string;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string2 = this.eval.getProperty("nbjdk.home");
            if (string2 == null && (string = this.eval.getProperty("nbjdk.active")) != null && !string.equals("default") && (string2 = this.eval.getProperty("platforms." + string + ".home")) != null) {
                hashMap.put("nbjdk.home", string2);
            }
            if (string2 == null && (string = JavaPlatformManager.getDefault().getDefaultPlatform()) != null && (object = string.getInstallFolders()).size() == 1) {
                string2 = FileUtil.toFile((FileObject)((FileObject)object.iterator().next())).getAbsolutePath();
            }
            string = null;
            if (string2 != null) {
                object = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string2)));
                if (object != null) {
                    for (JavaPlatform javaPlatform : JavaPlatformManager.getDefault().getInstalledPlatforms()) {
                        if (!new HashSet(javaPlatform.getInstallFolders()).equals(Collections.singleton(object))) continue;
                        ClassPath classPath = javaPlatform.getBootstrapLibraries();
                        classPath.removePropertyChangeListener(this.weakListener);
                        classPath.addPropertyChangeListener(this.weakListener);
                        string = classPath.toString(ClassPath.PathConversionMode.WARN);
                        break;
                    }
                }
                if (string == null) {
                    string = Utilities.isMac() ? "${nbjdk.home}/../Classes/classes.jar" : "${nbjdk.home}/jre/lib/rt.jar".replace('/', File.separatorChar);
                }
            }
            if (string == null) {
                string = "${sun.boot.class.path}";
            }
            hashMap.put("nbjdk.bootclasspath", string);
            if (string2 != null && !Utilities.isMac()) {
                hashMap.put("tools.jar", string2 + "/lib/tools.jar".replace('/', File.separatorChar));
            }
            if (Util.err.isLoggable(1)) {
                object = new TreeMap(this.eval.getProperties());
                Iterator iterator = object.keySet().iterator();
                while (iterator.hasNext()) {
                    String string3 = (String)iterator.next();
                    if (string3.startsWith("nbjdk.") || string3.startsWith("platforms.")) continue;
                    iterator.remove();
                }
                object.putAll(hashMap);
                Util.err.log("JDK-related properties of " + Evaluator.this.project + ": " + object);
            }
            return hashMap;
        }

        public final void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public final void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (!(string == null || string.startsWith("nbjdk.") || string.startsWith("platforms.") || string.equals("entries") || string.equals("installedPlatforms"))) {
                return;
            }
            if (!this.changeSupport.hasListeners()) {
                return;
            }
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    NbJdkProvider.this.changeSupport.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RequestProcessor.getDefault().post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }
    }

    private static class TestClasspath {
        private final String compile;
        private final String runtime;
        private final String testCompile;
        private final String testRuntime;

        public TestClasspath(String string, String string2, String string3, String string4) {
            this.compile = string;
            this.runtime = string2;
            this.testCompile = string3;
            this.testRuntime = string4;
        }

        public String getCompileClasspath() {
            return this.compile + ':' + this.testCompile;
        }

        public String getRuntimeClasspath() {
            return this.runtime + ':' + this.testRuntime;
        }

        private static TestClasspath getOrEmpty(Map map, String string) {
            TestClasspath testClasspath = (TestClasspath)map.get(string);
            if (testClasspath == null) {
                testClasspath = new TestClasspath("", "", "", "");
            }
            return testClasspath;
        }
    }
}

