/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.metainf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.metainf.Service;
import org.netbeans.modules.apisupport.project.metainf.ServiceNodeHandler;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ServiceViewUpdater {
    private static Map<SuiteProject, List<Service>> suiteToServices = new WeakHashMap<SuiteProject, List<Service>>();

    ServiceViewUpdater() {
    }

    public static void serviceUpdated(Service service, ServiceNodeHandler serviceNodeHandler) throws IOException {
        block3: {
            File file;
            FileObject fileObject;
            NbModuleProvider.NbModuleType nbModuleType;
            block4: {
                block2: {
                    SuiteProject suiteProject = ServiceViewUpdater.getSuite(serviceNodeHandler);
                    if (suiteProject == null) break block2;
                    SubprojectProvider subprojectProvider = (SubprojectProvider)suiteProject.getLookup().lookup(SubprojectProvider.class);
                    Iterator iterator = subprojectProvider.getSubprojects().iterator();
                    while (iterator.hasNext()) {
                        ServiceNodeHandler serviceNodeHandler2 = (ServiceNodeHandler)((Project)iterator.next()).getLookup().lookup(ServiceNodeHandler.class);
                        if (serviceNodeHandler2 == null) continue;
                        serviceNodeHandler2.updateService(service);
                    }
                    break block3;
                }
                nbModuleType = ((NbModuleProvider)serviceNodeHandler.getProject().getLookup().lookup(NbModuleProvider.class)).getModuleType();
                if (nbModuleType != NbModuleProvider.STANDALONE) break block4;
                serviceNodeHandler.updateService(service);
                break block3;
            }
            if (nbModuleType != NbModuleProvider.NETBEANS_ORG || (fileObject = FileUtil.toFileObject((File)(file = ModuleList.findNetBeansOrg(FileUtil.toFile((FileObject)serviceNodeHandler.getProject().getProjectDirectory()))))) == null) break block3;
            Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
            for (int i = 0; i < projectArray.length; ++i) {
                ServiceNodeHandler serviceNodeHandler3;
                if (!(projectArray[i] instanceof NbModuleProject)) continue;
                NbModuleProject nbModuleProject = (NbModuleProject)projectArray[i];
                NbModuleProvider.NbModuleType nbModuleType2 = ((NbModuleProvider)serviceNodeHandler.getProject().getLookup().lookup(NbModuleProvider.class)).getModuleType();
                if (nbModuleType2 != NbModuleProvider.NETBEANS_ORG || !FileUtil.isParentOf((FileObject)fileObject, (FileObject)nbModuleProject.getProjectDirectory()) || (serviceNodeHandler3 = (ServiceNodeHandler)nbModuleProject.getLookup().lookup(ServiceNodeHandler.class)) == null) continue;
                serviceNodeHandler3.updateService(service);
            }
        }
    }

    private static SuiteProject getSuite(ServiceNodeHandler serviceNodeHandler) throws IOException {
        SuiteProject suiteProject = null;
        Project project = serviceNodeHandler.getProject();
        NbModuleProvider.NbModuleType nbModuleType = ((NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class)).getModuleType();
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
            assert (suiteProvider != null) : project;
            File file = suiteProvider.getSuiteDirectory();
            if (file == null || !file.isDirectory()) {
                throw new IOException("Could not locate suite for " + project);
            }
            Project project2 = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
            if (project2 instanceof SuiteProject) {
                suiteProject = (SuiteProject)project2;
            }
        }
        return suiteProject;
    }

    static List<Service> getAllServices(ServiceNodeHandler serviceNodeHandler) throws IOException {
        SuiteProject suiteProject = ServiceViewUpdater.getSuite(serviceNodeHandler);
        if (suiteProject != null) {
            List<Service> list = suiteToServices.get(suiteProject);
            if (list == null) {
                list = Service.getPlatfromServices(serviceNodeHandler.getProject());
            }
            SubprojectProvider subprojectProvider = (SubprojectProvider)suiteProject.getLookup().lookup(SubprojectProvider.class);
            for (NbModuleProject nbModuleProject : subprojectProvider.getSubprojects()) {
                list.addAll(Service.getOnlyProjectServices(nbModuleProject));
            }
            suiteToServices.put(suiteProject, list);
            return list;
        }
        return Service.getPlatfromServices(serviceNodeHandler.getProject());
    }

    static List<Service> filterServices(List list, ServiceNodeHandler serviceNodeHandler) throws IOException {
        if (ServiceViewUpdater.getSuite(serviceNodeHandler) != null) {
            List<Service> list2 = ServiceViewUpdater.getAllServices(serviceNodeHandler);
            ArrayList<Service> arrayList = new ArrayList<Service>();
            NbModuleProvider nbModuleProvider = (NbModuleProvider)serviceNodeHandler.getProject().getLookup().lookup(NbModuleProvider.class);
            String string = nbModuleProvider.getCodeNameBase();
            for (int i = 0; i < list2.size(); ++i) {
                Service service = list2.get(i);
                if (!service.getCodebase().equals(string)) continue;
                arrayList.add(service);
            }
            return arrayList;
        }
        return Service.getOnlyProjectServices(serviceNodeHandler.getProject());
    }
}

