/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.queries;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.TestEntry;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Element;

public final class SourceForBinaryImpl
implements SourceForBinaryQueryImplementation {
    private final NbModuleProject project;
    private URL classesUrl;
    private final Map<String, URL> testClassesUrl = new HashMap<String, URL>();
    private Map<URL, SourceForBinaryQuery.Result> cache = new HashMap<URL, SourceForBinaryQuery.Result>();

    public SourceForBinaryImpl(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL uRL) {
        SourceForBinaryQuery.Result result = this.cache.get(uRL);
        if (result == null) {
            Object object;
            File file = FileUtil.archiveOrDirForURL((URL)uRL);
            if (file != null) {
                object = null;
                if (file.getAbsolutePath().endsWith(this.project.evaluator().getProperty("module.jar").replace('/', File.separatorChar))) {
                    object = this.project.getSourceDirectory();
                } else {
                    TestEntry object2 = TestEntry.get(file);
                    if (object2 != null && this.project.getCodeNameBase().equals(object2.getCodeNameBase())) {
                        object = this.project.getTestSourceDirectory(object2.getTestType());
                    }
                }
                if (object != null) {
                    result = new Result((FileObject)object);
                    return result;
                }
            }
            if (uRL.equals(this.getClassesUrl())) {
                object = this.project.getSourceDirectory();
                if (object != null) {
                    result = new Result((FileObject)object);
                }
            } else {
                for (String string : this.project.supportedTestTypes()) {
                    Object object2;
                    if (!uRL.equals(this.getTestClassesUrl(string)) || (object2 = this.project.getTestSourceDirectory(string)) == null) continue;
                    result = new Result((FileObject)object2);
                    break;
                }
                if (result == null) {
                    block1: for (Map.Entry entry : this.project.getExtraCompilationUnits().entrySet()) {
                        for (Element element : Util.findSubElements((Element)entry.getValue())) {
                            if (!element.getLocalName().equals("built-to")) continue;
                            String string = Util.findText(element);
                            assert (string != null) : "Null content for <built-to> in " + this.project;
                            String string2 = this.project.evaluator().evaluate(string);
                            if (string2 == null) continue;
                            File file2 = this.project.getHelper().resolveFile(string2);
                            URL uRL2 = FileUtil.urlForArchiveOrDir((File)file2);
                            if (uRL2 == null) {
                                Logger.getLogger(SourceForBinaryImpl.class.getName()).log(Level.WARNING, "In " + FileUtil.getFileDisplayName((FileObject)this.project.getProjectDirectory()) + " " + file2 + " is neither a directory nor a JAR");
                                continue;
                            }
                            if (!uRL2.equals(uRL)) continue;
                            result = new Result((FileObject)entry.getKey());
                            break block1;
                        }
                    }
                }
            }
            if (result != null) {
                this.cache.put(uRL, result);
            }
        }
        return result;
    }

    private URL getClassesUrl() {
        if (this.classesUrl == null) {
            File file = this.project.getClassesDirectory();
            this.classesUrl = file != null ? FileUtil.urlForArchiveOrDir((File)file) : null;
        }
        return this.classesUrl;
    }

    private URL getTestClassesUrl(String string) {
        if (!this.testClassesUrl.containsKey(string) && this.project.supportedTestTypes().contains(string)) {
            File file = this.project.getTestClassesDirectory(string);
            this.testClassesUrl.put(string, FileUtil.urlForArchiveOrDir((File)file));
        }
        return this.testClassesUrl.get(string);
    }

    private static class Result
    implements SourceForBinaryQuery.Result {
        private FileObject res;

        public Result(FileObject fileObject) {
            assert (fileObject != null);
            this.res = fileObject;
        }

        public FileObject[] getRoots() {
            return new FileObject[]{this.res};
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }
}

