/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.net.URL;
import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.apisupport.project.ui.ShowJavadocAction;
import org.openide.ErrorManager;
import org.openide.actions.EditAction;
import org.openide.actions.FindAction;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

class ActionFilterNode
extends FilterNode {
    private static final int MODE_PACKAGE = 2;
    private static final int MODE_FILE = 3;
    private static final int MODE_FILE_CONTENT = 4;
    private final int mode;
    private Action[] actionCache;

    static ActionFilterNode create(Node node) {
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        assert (dataObject != null);
        FileObject fileObject = dataObject.getPrimaryFile();
        ProxyLookup proxyLookup = new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.singleton((Object)new JavadocProvider(fileObject, fileObject))});
        return new ActionFilterNode(node, 2, fileObject, (Lookup)proxyLookup);
    }

    private ActionFilterNode(Node node, int n, FileObject fileObject, FileObject fileObject2) {
        this(node, n, fileObject, (Lookup)new ProxyLookup(new Lookup[]{node.getLookup(), Lookups.singleton((Object)new JavadocProvider(fileObject, fileObject2))}));
    }

    private ActionFilterNode(Node node, int n) {
        super(node, (Children)(node.isLeaf() ? FilterNode.Children.LEAF : new ActionFilterChildren(node, n, null)));
        this.mode = n;
    }

    private ActionFilterNode(Node node, int n, FileObject fileObject, Lookup lookup) {
        super(node, (Children)(node.isLeaf() ? FilterNode.Children.LEAF : new ActionFilterChildren(node, n, fileObject)), lookup);
        this.mode = n;
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray = this.initActions();
        return actionArray;
    }

    public Action getPreferredAction() {
        Action[] actionArray;
        if (this.mode == 3 && (actionArray = this.initActions()).length > 0 && (actionArray[0] instanceof OpenAction || actionArray[0] instanceof EditAction)) {
            return actionArray[0];
        }
        return null;
    }

    private Action[] initActions() {
        if (this.actionCache == null) {
            ArrayList<Action> arrayList = new ArrayList<Action>(2);
            if (this.mode == 3) {
                for (Action action : super.getActions(false)) {
                    if (!(action instanceof OpenAction) && !(action instanceof EditAction)) continue;
                    arrayList.add(action);
                }
                arrayList.add((Action)SystemAction.get(ShowJavadocAction.class));
            } else if (this.mode == 2) {
                arrayList.add((Action)SystemAction.get(ShowJavadocAction.class));
                for (Action action : super.getActions(false)) {
                    if (!(action instanceof FindAction)) continue;
                    arrayList.add(action);
                }
            }
            this.actionCache = arrayList.toArray(new Action[arrayList.size()]);
        }
        return this.actionCache;
    }

    private static class JavadocProvider
    implements ShowJavadocAction.JavadocProvider {
        private final FileObject cpRoot;
        private final FileObject resource;

        JavadocProvider(FileObject fileObject, FileObject fileObject2) {
            this.cpRoot = fileObject;
            this.resource = fileObject2;
        }

        public boolean hasJavadoc() {
            try {
                boolean bl = this.resource != null;
                int n = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots().length;
                return bl && n > 0;
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                return false;
            }
        }

        public void showJavadoc() {
            try {
                URL uRL;
                String string = FileUtil.getRelativePath((FileObject)this.cpRoot, (FileObject)this.resource);
                URL[] uRLArray = JavadocForBinaryQuery.findJavadoc((URL)this.cpRoot.getURL()).getRoots();
                if (string.length() == 0) {
                    uRL = ShowJavadocAction.findJavadoc("overview-summary.html", uRLArray);
                    if (uRL == null) {
                        uRL = ShowJavadocAction.findJavadoc("index.html", uRLArray);
                    }
                } else if (this.resource.isFolder()) {
                    uRL = ShowJavadocAction.findJavadoc(string + "/package-summary.html", uRLArray);
                } else {
                    String string2 = string.substring(0, string.lastIndexOf(46)) + ".html";
                    uRL = ShowJavadocAction.findJavadoc(string2, uRLArray);
                }
                ShowJavadocAction.showJavaDoc(uRL, string.replace('/', '.'));
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify((Throwable)fileStateInvalidException);
            }
        }
    }

    private static class ActionFilterChildren
    extends FilterNode.Children {
        private final int mode;
        private final FileObject cpRoot;

        ActionFilterChildren(Node node, int n, FileObject fileObject) {
            super(node);
            this.mode = n;
            this.cpRoot = fileObject;
        }

        protected Node[] createNodes(Node node) {
            switch (this.mode) {
                case 2: {
                    DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                    if (dataObject == null) {
                        assert (false) : "DataNode without DataObject in Lookup";
                        return new Node[0];
                    }
                    if (dataObject.getPrimaryFile().isFolder()) {
                        return new Node[]{new ActionFilterNode(node, 2, this.cpRoot, dataObject.getPrimaryFile())};
                    }
                    return new Node[]{new ActionFilterNode(node, 3, this.cpRoot, dataObject.getPrimaryFile())};
                }
                case 3: 
                case 4: {
                    return new Node[]{new ActionFilterNode(node, 4)};
                }
            }
            assert (false) : "Unknown mode";
            return new Node[0];
        }
    }
}

