/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public final class EditDependencyPanel
extends JPanel {
    private final ModuleDependency origDep;
    private final URL javadoc;
    private final ManifestManager.PackageExport[] pp;
    private final DefaultListModel packagesModel = new DefaultListModel();
    private JList availablePkg;
    private JScrollPane availablePkgSP;
    private JLabel codeNameBase;
    private JTextField codeNameBaseValue;
    private JRadioButton implVer;
    private JCheckBox includeInCP;
    private JLabel jarLocation;
    private JTextField jarLocationValue;
    private JLabel releaseVersion;
    private JTextField releaseVersionValue;
    private JButton showJavadocButton;
    private JRadioButton specVer;
    private JTextField specVerValue;
    private ButtonGroup versionGroup;

    public EditDependencyPanel(ModuleDependency moduleDependency, NbPlatform nbPlatform) {
        this.origDep = moduleDependency;
        this.pp = this.origDep.getModuleEntry().getPublicPackages();
        this.initComponents();
        this.initDependency();
        this.javadoc = nbPlatform == null ? Util.findJavadocForNetBeansOrgModules(this.origDep) : Util.findJavadoc(this.origDep, nbPlatform);
        this.showJavadocButton.setEnabled(this.javadoc != null);
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.title.AccessibleContext.accessibleName"));
    }

    private void refresh() {
        this.specVerValue.setEnabled(this.specVer.isSelected());
        this.includeInCP.setEnabled(this.hasAvailablePackages());
        if (!this.includeInCP.isEnabled()) {
            this.includeInCP.setSelected(false);
        }
    }

    private boolean hasAvailablePackages() {
        return this.implVer.isSelected() || this.pp.length > 0;
    }

    private void initDependency() {
        ModuleEntry moduleEntry = this.origDep.getModuleEntry();
        UIUtil.setText(this.codeNameBaseValue, moduleEntry.getCodeNameBase());
        UIUtil.setText(this.jarLocationValue, moduleEntry.getJarLocation().getAbsolutePath());
        UIUtil.setText(this.releaseVersionValue, this.origDep.getReleaseVersion());
        UIUtil.setText(this.specVerValue, this.origDep.hasImplementationDepedendency() ? moduleEntry.getSpecificationVersion() : this.origDep.getSpecificationVersion());
        this.implVer.setSelected(this.origDep.hasImplementationDepedendency());
        this.availablePkg.setEnabled(this.hasAvailablePackages());
        this.includeInCP.setSelected(this.origDep.hasCompileDependency());
        this.refreshAvailablePackages();
        this.refresh();
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDependencyPanel.this.refreshAvailablePackages();
            }
        };
        this.implVer.addActionListener(actionListener);
        this.specVer.addActionListener(actionListener);
    }

    public void refreshAvailablePackages() {
        this.packagesModel.clear();
        if (this.hasAvailablePackages()) {
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < this.pp.length; ++i) {
                treeSet.add(this.pp[i].getPackage() + (this.pp[i].isRecursive() ? ".**" : ""));
            }
            if (this.implVer.isSelected()) {
                treeSet.addAll(this.origDep.getModuleEntry().getAllPackageNames());
            }
            for (String string : treeSet) {
                this.packagesModel.addElement(string);
            }
        } else {
            this.packagesModel.addElement(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel_empty"));
        }
        this.availablePkg.setModel(this.packagesModel);
    }

    public ModuleDependency getEditedDependency() {
        ModuleDependency moduleDependency = new ModuleDependency(this.origDep.getModuleEntry(), this.releaseVersionValue.getText().trim(), this.specVerValue.getText().trim(), this.includeInCP.isSelected(), this.implVer.isSelected());
        return moduleDependency;
    }

    private void initComponents() {
        this.versionGroup = new ButtonGroup();
        this.codeNameBase = new JLabel();
        this.jarLocation = new JLabel();
        this.releaseVersion = new JLabel();
        this.releaseVersionValue = new JTextField();
        this.specVer = new JRadioButton();
        this.specVerValue = new JTextField();
        this.implVer = new JRadioButton();
        this.includeInCP = new JCheckBox();
        this.availablePkgSP = new JScrollPane();
        this.availablePkg = new JList();
        this.codeNameBaseValue = new JTextField();
        this.jarLocationValue = new JTextField();
        this.showJavadocButton = new JButton();
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setPreferredSize(new Dimension(400, 300));
        this.setLayout(new GridBagLayout());
        this.codeNameBase.setLabelFor(this.codeNameBaseValue);
        Mnemonics.setLocalizedText((JLabel)this.codeNameBase, (String)NbBundle.getMessage(EditDependencyPanel.class, (String)"LBL_CNB"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.codeNameBase, gridBagConstraints);
        this.codeNameBase.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.codeNameBase.AccessibleContext.accessibleDescription"));
        this.jarLocation.setLabelFor(this.jarLocationValue);
        Mnemonics.setLocalizedText((JLabel)this.jarLocation, (String)NbBundle.getMessage(EditDependencyPanel.class, (String)"LBL_JAR"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 12);
        this.add((Component)this.jarLocation, gridBagConstraints);
        this.jarLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.jarLocation.AccessibleContext.accessibleDescription"));
        this.releaseVersion.setLabelFor(this.releaseVersionValue);
        Mnemonics.setLocalizedText((JLabel)this.releaseVersion, (String)NbBundle.getMessage(EditDependencyPanel.class, (String)"LBL_MajorReleaseVersion"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 12);
        this.add((Component)this.releaseVersion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.releaseVersionValue, gridBagConstraints);
        this.releaseVersionValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.releaseVersionValue.AccessibleContext.accessibleName"));
        this.releaseVersionValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.releaseVersionValue.AccessibleContext.accessibleDescription"));
        this.versionGroup.add(this.specVer);
        this.specVer.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.specVer, (String)NbBundle.getMessage(EditDependencyPanel.class, (String)"LBL_SpecificationVersion"));
        this.specVer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDependencyPanel.this.versionChanged(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.specVer, gridBagConstraints);
        this.specVer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.specVer.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.specVerValue, gridBagConstraints);
        this.specVerValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.specVerValue.AccessibleContext.accessibleName"));
        this.specVerValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.specVerValue.AccessibleContext.accessibleDescription"));
        this.versionGroup.add(this.implVer);
        Mnemonics.setLocalizedText((AbstractButton)this.implVer, (String)NbBundle.getMessage(EditDependencyPanel.class, (String)"LBL_ImplementationVersion"));
        this.implVer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDependencyPanel.this.versionChanged(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.implVer, gridBagConstraints);
        this.implVer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.implVer.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.includeInCP, (String)NbBundle.getMessage(EditDependencyPanel.class, (String)"LBL_IncludeAPIPackages"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.includeInCP, gridBagConstraints);
        this.includeInCP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.includeInCP.AccessibleContext.accessibleDescription"));
        this.availablePkgSP.setViewportView(this.availablePkg);
        this.availablePkg.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.availablePkg.AccessibleContext.accessibleName"));
        this.availablePkg.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.availablePkg.AccessibleContext.accessibleDescription"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.availablePkgSP, gridBagConstraints);
        this.codeNameBaseValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.codeNameBaseValue, gridBagConstraints);
        this.codeNameBaseValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.codeNameBaseValue.AccessibleContext.accessibleName"));
        this.codeNameBaseValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.codeNameBaseValue.AccessibleContext.accessibleDescription"));
        this.jarLocationValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jarLocationValue, gridBagConstraints);
        this.jarLocationValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.jarLocationValue.AccessibleContext.accessibleName"));
        this.jarLocationValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.jarLocationValue.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.showJavadocButton, (String)NbBundle.getMessage(EditDependencyPanel.class, (String)"CTL_ShowJavadoc"));
        this.showJavadocButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditDependencyPanel.this.showJavadoc(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.showJavadocButton, gridBagConstraints);
        this.showJavadocButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditDependencyPanel.class, (String)"EditDependencyPanel.showJavadocButton.AccessibleContext.accessibleDescription"));
    }

    private void showJavadoc(ActionEvent actionEvent) {
        HtmlBrowser.URLDisplayer.getDefault().showURL(this.javadoc);
    }

    private void versionChanged(ActionEvent actionEvent) {
        this.refresh();
        if (this.implVer.isSelected()) {
            this.includeInCP.setSelected(true);
        }
    }
}

