/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatter;
import org.openide.util.NbBundle;

class SplashUISupport {
    private SplashUISupport() {
    }

    static Rectangle stringToBounds(String string) throws NumberFormatException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        block6: for (int i = 0; i < 4; ++i) {
            if (!stringTokenizer.hasMoreElements()) {
                throw new NumberFormatException();
            }
            switch (i) {
                case 0: {
                    n4 = Integer.parseInt(stringTokenizer.nextToken());
                    continue block6;
                }
                case 1: {
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                    continue block6;
                }
                case 2: {
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                    continue block6;
                }
                case 3: {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                }
            }
        }
        return new Rectangle(n4, n3, n2, n);
    }

    static String boundsToString(Rectangle rectangle) throws NumberFormatException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.valueOf(rectangle.x)).append(",");
        stringBuffer.append(String.valueOf(rectangle.y)).append(",");
        stringBuffer.append(String.valueOf(rectangle.width)).append(",");
        stringBuffer.append(String.valueOf(rectangle.height));
        return stringBuffer.toString();
    }

    static Color stringToColor(String string) throws NumberFormatException {
        return new Color(Integer.decode(string));
    }

    static String colorToString(Color color) throws NumberFormatException {
        return "0x" + Integer.toString(0xFFFFFF & color.getRGB(), 16).toUpperCase(Locale.ENGLISH);
    }

    static int stringToInteger(String string) throws NumberFormatException {
        return Integer.decode(string);
    }

    static String integerToString(int n) throws NumberFormatException {
        return Integer.toString(n, 10);
    }

    static JFormattedTextField getIntegerField() {
        JFormattedTextField jFormattedTextField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        jFormattedTextField = new JFormattedTextField(new FontFormatter(jFormattedTextField.getFormatter()));
        return jFormattedTextField;
    }

    static JFormattedTextField getBoundsField() {
        JFormattedTextField jFormattedTextField = new JFormattedTextField(new BoundsFormatter());
        return jFormattedTextField;
    }

    static ColorComboBox getColorComboBox() {
        ColorComboBox colorComboBox = new ColorComboBox();
        return colorComboBox;
    }

    static class ColorComboBox
    extends JComboBox {
        public static final String PROP_COLOR = "color";
        public static final Value CUSTOM_COLOR = new Value(ColorComboBox.loc("Custom"), null);
        private static Map<Color, String> colorMap = new HashMap<Color, String>();
        private static Object[] content;

        public ColorComboBox() {
            super(content);
            this.setRenderer(new Renderer());
            this.setEditable(true);
            this.setEditor(new Renderer());
            this.setSelectedItem(new Value(null, null));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (ColorComboBox.this.getSelectedItem() == CUSTOM_COLOR) {
                        Color color = JColorChooser.showDialog(SwingUtilities.getAncestorOfClass(Dialog.class, ColorComboBox.this), ColorComboBox.loc("SelectColor"), null);
                        ColorComboBox.this.setColor(color);
                    }
                    ColorComboBox.this.firePropertyChange(ColorComboBox.PROP_COLOR, null, null);
                }
            });
        }

        public void setDefaultColor(Color color) {
            Object[] objectArray = new Object[content.length];
            System.arraycopy(content, 0, objectArray, 0, content.length);
            objectArray[ColorComboBox.content.length - 1] = new Value(NbBundle.getMessage(SplashUISupport.class, (String)"SplashUISupport_color_default"), color);
            this.setModel(new DefaultComboBoxModel<Object>(objectArray));
        }

        public void setColor(Color color) {
            if (color == null) {
                this.setSelectedIndex(content.length - 1);
            } else {
                this.setSelectedItem(new Value(color));
            }
        }

        public Color getColor() {
            if (this.getSelectedIndex() == content.length - 1) {
                return null;
            }
            return ((Value)this.getSelectedItem()).color;
        }

        private static String loc(String string) {
            return NbBundle.getMessage(ColorComboBox.class, (String)string);
        }

        static {
            colorMap.put(Color.BLACK, ColorComboBox.loc("Black"));
            colorMap.put(Color.BLUE, ColorComboBox.loc("Blue"));
            colorMap.put(Color.CYAN, ColorComboBox.loc("Cyan"));
            colorMap.put(Color.DARK_GRAY, ColorComboBox.loc("Dark_Gray"));
            colorMap.put(Color.GRAY, ColorComboBox.loc("Gray"));
            colorMap.put(Color.GREEN, ColorComboBox.loc("Green"));
            colorMap.put(Color.LIGHT_GRAY, ColorComboBox.loc("Light_Gray"));
            colorMap.put(Color.MAGENTA, ColorComboBox.loc("Magenta"));
            colorMap.put(Color.ORANGE, ColorComboBox.loc("Orange"));
            colorMap.put(Color.PINK, ColorComboBox.loc("Pink"));
            colorMap.put(Color.RED, ColorComboBox.loc("Red"));
            colorMap.put(Color.WHITE, ColorComboBox.loc("White"));
            colorMap.put(Color.YELLOW, ColorComboBox.loc("Yellow"));
            content = new Object[]{new Value(Color.BLACK), new Value(Color.BLUE), new Value(Color.CYAN), new Value(Color.DARK_GRAY), new Value(Color.GRAY), new Value(Color.GREEN), new Value(Color.LIGHT_GRAY), new Value(Color.MAGENTA), new Value(Color.ORANGE), new Value(Color.PINK), new Value(Color.RED), new Value(Color.WHITE), new Value(Color.YELLOW), CUSTOM_COLOR, new Value(NbBundle.getMessage(SplashUISupport.class, (String)"SplashUISupport_color_none"), null)};
        }

        private class Renderer
        extends JComponent
        implements ListCellRenderer,
        ComboBoxEditor {
            private int SIZE = 9;
            private Value value;

            Renderer() {
                this.setPreferredSize(new Dimension(50, this.getFontMetrics(ColorComboBox.this.getFont()).getHeight() + 2));
                this.setOpaque(true);
            }

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (!this.isEnabled()) {
                    graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
                }
                Color color = graphics.getColor();
                Dimension dimension = this.getSize();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, dimension.width, dimension.height);
                int n = (dimension.height - this.SIZE) / 2;
                if (this.value.color != null) {
                    graphics.setColor(Color.black);
                    graphics.drawRect(n, n, this.SIZE, this.SIZE);
                    graphics.setColor(this.value.color);
                    graphics.fillRect(n + 1, n + 1, this.SIZE - 1, this.SIZE - 1);
                }
                if (this.value.text != null) {
                    graphics.setColor(Color.black);
                    if (this.value.color != null) {
                        graphics.drawString(this.value.text, n + this.SIZE + 5, n + this.SIZE);
                    } else {
                        graphics.drawString(this.value.text, 5, n + this.SIZE);
                    }
                }
                graphics.setColor(color);
            }

            public void setEnabled(boolean bl) {
                this.setBackground(bl ? SystemColor.text : SystemColor.control);
                super.setEnabled(bl);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.value = (Value)object;
                this.setEnabled(jList.isEnabled());
                return this;
            }

            public Component getEditorComponent() {
                this.setEnabled(ColorComboBox.this.isEnabled());
                return this;
            }

            public void setItem(Object object) {
                this.value = (Value)object;
            }

            public Object getItem() {
                return this.value;
            }

            public void selectAll() {
            }

            public void addActionListener(ActionListener actionListener) {
            }

            public void removeActionListener(ActionListener actionListener) {
            }
        }

        private static class Editor
        extends JLabel
        implements ComboBoxEditor {
            private Object value;

            Editor() {
            }

            public Component getEditorComponent() {
                return this;
            }

            public void setItem(Object object) {
                this.value = object;
                if (this.value instanceof String) {
                    this.setText(NbBundle.getMessage(SplashUISupport.class, (String)"SplashUISupport_color_default"));
                    super.setForeground(SystemColor.textText);
                    super.setBackground(SystemColor.text);
                } else {
                    this.setText("");
                    super.setBackground((Color)this.value);
                }
            }

            public Object getItem() {
                return this.value;
            }

            public void setBackground(Color color) {
            }

            public void setForeground(Color color) {
            }

            public void selectAll() {
            }

            public void addActionListener(ActionListener actionListener) {
            }

            public void removeActionListener(ActionListener actionListener) {
            }
        }

        public static class Value {
            String text;
            Color color;

            Value(Color color) {
                this.color = color;
                this.text = (String)colorMap.get(color);
                if (this.text != null) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append('[').append(color.getRed()).append(',').append(color.getGreen()).append(',').append(color.getBlue()).append(']');
                this.text = stringBuffer.toString();
            }

            Value(String string, Color color) {
                this.text = string;
                this.color = color;
            }
        }
    }

    private static class BoundsFormatter
    extends DefaultFormatter {
        BoundsFormatter() {
            this.setOverwriteMode(false);
        }

        public Object stringToValue(String string) throws ParseException {
            if (string == null) {
                return super.stringToValue(string);
            }
            try {
                return SplashUISupport.stringToBounds(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(string, 0);
            }
        }

        public String valueToString(Object object) throws ParseException {
            if (object == null) {
                return super.valueToString(object);
            }
            try {
                return SplashUISupport.boundsToString((Rectangle)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException(object.toString(), 0);
            }
        }
    }

    private static class FontFormatter
    extends DefaultFormatter {
        private JFormattedTextField.AbstractFormatter deleg;

        FontFormatter(JFormattedTextField.AbstractFormatter abstractFormatter) {
            this.setOverwriteMode(false);
            this.deleg = abstractFormatter;
        }

        public Object stringToValue(String string) throws ParseException {
            Object object = this.deleg.stringToValue(string);
            int n = ((Number)object).intValue();
            if (n < 0) {
                throw new ParseException(string, 0);
            }
            return object;
        }

        public String valueToString(Object object) throws ParseException {
            return this.deleg.valueToString(object);
        }
    }
}

