/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.ui.platform.NbPlatformCustomizer;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicVisualPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.NewModuleProjectData;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class BasicInfoVisualPanel
extends BasicVisualPanel.NewTemplatePanel {
    private ButtonModel lastSelectedType;
    private static String lastSelectedSuite;
    private boolean locationUpdated;
    private boolean nameUpdated;
    private boolean moduleTypeGroupAttached = true;
    private boolean mainProjectTouched;
    private JButton browseButton;
    private JButton browseSuiteButton;
    private JLabel chooserFiller;
    private JLabel filler;
    private JLabel folderLbl;
    private JTextField folderValue;
    private JPanel infoPanel;
    private JLabel locationLbl;
    private JTextField locationValue;
    private JCheckBox mainProject;
    private JButton managePlatform;
    private JButton manageSuitePlatform;
    private JLabel moduleSuite;
    private JComboBox moduleSuiteValue;
    private ButtonGroup moduleTypeGroup;
    private JLabel nameLbl;
    JTextField nameValue;
    private JLabel platform;
    private JComboBox platformValue;
    private JPanel pnlThouShaltBeholdLayout;
    private JSeparator separator3;
    private JRadioButton standAloneModule;
    private JRadioButton suiteComponent;
    private JLabel suitePlatform;
    private JComboBox suitePlatformValue;
    private JPanel typeChooserPanel;

    BasicInfoVisualPanel(NewModuleProjectData newModuleProjectData) {
        super(newModuleProjectData);
        this.initComponents();
        this.initAccessibility();
        this.initPlatformCombos();
        this.setComponentsVisibility();
        switch (newModuleProjectData.getWizardType()) {
            case SUITE: 
            case APPLICATION: {
                this.detachModuleTypeGroup();
                break;
            }
            case MODULE: 
            case SUITE_COMPONENT: {
                if (this.moduleSuiteValue.getItemCount() <= 0) break;
                this.restoreSelectedSuite();
                this.suiteComponent.setSelected(true);
                this.mainProject.setSelected(false);
                break;
            }
            case LIBRARY_MODULE: {
                this.moduleSuite.setText(BasicInfoVisualPanel.getMessage("LBL_Add_to_Suite"));
                this.suiteComponent.setSelected(true);
                if (this.moduleSuiteValue.getItemCount() <= 0) break;
                this.restoreSelectedSuite();
                break;
            }
            default: {
                assert (false) : "Unknown wizard type = " + (Object)((Object)newModuleProjectData.getWizardType());
                break;
            }
        }
        this.attachDocumentListeners();
        this.setInitialLocation();
        this.setInitialProjectName();
        this.updateEnabled();
    }

    private void setInitialLocation() {
        if (this.isSuiteComponent()) {
            this.computeAndSetLocation((String)this.moduleSuiteValue.getSelectedItem(), true);
        } else {
            String string = this.computeLocationValue(ProjectChooser.getProjectsFolder().getAbsolutePath());
            File file = new File(string);
            if (SuiteUtils.isSuite(file)) {
                this.computeAndSetLocation(file.getParent(), true);
            } else {
                this.setLocation(string, true);
            }
        }
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_BasicInfoVisualPanel"));
        this.browseButton.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_BrowseButton"));
        this.browseSuiteButton.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_BrowseSuiteButton"));
        this.folderValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_FolderValue"));
        this.locationValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_LocationValue"));
        this.mainProject.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_MainProject"));
        this.managePlatform.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_ManagePlatform"));
        this.manageSuitePlatform.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_ManageSuitePlatform"));
        this.moduleSuiteValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_ModuleSuiteValue"));
        this.nameValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_NameValue"));
        this.platformValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_PlatformValue"));
        this.standAloneModule.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_StandAloneModule"));
        this.suiteComponent.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_SuiteModule"));
        this.suitePlatformValue.getAccessibleContext().setAccessibleDescription(BasicInfoVisualPanel.getMessage("ACS_CTL_SuitePlatformValue"));
    }

    private void setComponentsVisibility() {
        boolean bl = this.isSuiteWizard();
        boolean bl2 = this.isSuiteComponentWizard();
        boolean bl3 = this.isLibraryWizard();
        this.typeChooserPanel.setVisible(!bl);
        this.suitePlatform.setVisible(bl);
        this.suitePlatformValue.setVisible(bl);
        this.manageSuitePlatform.setVisible(bl);
        this.mainProject.setVisible(!bl3);
        this.suiteComponent.setVisible(!bl3);
        this.platform.setVisible(!bl3);
        this.platformValue.setVisible(!bl3);
        this.managePlatform.setVisible(!bl3);
        this.standAloneModule.setVisible(!bl3);
        this.mainProject.setSelected(!bl3);
        this.standAloneModule.setVisible(!bl2 && !bl3);
        this.platform.setVisible(!bl2 && !bl3);
        this.platformValue.setVisible(!bl2 && !bl3);
        this.managePlatform.setVisible(!bl2 && !bl3);
        this.suiteComponent.setVisible(!bl2 && !bl3);
    }

    private void restoreSelectedSuite() {
        String string = this.getPreferredSuiteDir();
        if (string != null) {
            lastSelectedSuite = string;
        }
        if (lastSelectedSuite != null) {
            int n = this.moduleSuiteValue.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                if (!lastSelectedSuite.equals(this.moduleSuiteValue.getModel().getElementAt(i))) continue;
                this.moduleSuiteValue.setSelectedItem(lastSelectedSuite);
                break;
            }
        }
    }

    private String getPreferredSuiteDir() {
        return (String)this.getSettings().getProperty("preferredSuiteDir");
    }

    private boolean isOneSuiteDedicatedMode() {
        Boolean bl = (Boolean)this.getSettings().getProperty("oneSuiteDedicatedMode");
        return bl != null ? bl : false;
    }

    private String getNameValue() {
        return this.nameValue.getText().trim();
    }

    private String getLocationValue() {
        return this.locationValue.getText().trim();
    }

    private File getLocationFile() {
        return new File(this.getLocationValue());
    }

    private void updateEnabled() {
        boolean bl = this.isNetBeansOrgFolder();
        this.standAloneModule.setEnabled(!bl);
        this.suiteComponent.setEnabled(!bl);
        boolean bl2 = this.isStandAlone();
        boolean bl3 = this.isSuiteComponent();
        this.platform.setEnabled(bl2);
        this.platformValue.setEnabled(bl2);
        this.managePlatform.setEnabled(bl2);
        this.moduleSuite.setEnabled(bl3);
        this.moduleSuiteValue.setEnabled(bl3 && !this.isOneSuiteDedicatedMode());
        this.browseSuiteButton.setEnabled(bl3 && !this.isOneSuiteDedicatedMode());
    }

    void updateAndCheck() {
        this.updateGUI();
        if ("".equals(this.getNameValue())) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_NameCannotBeEmpty"));
        } else if ("".equals(this.getLocationValue())) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_LocationCannotBeEmpty"));
        } else if (this.isLibraryWizard() && this.isNetBeansOrgFolder()) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_LibraryWrapperForNBOrgUnsupported"));
        } else if (this.isSuiteComponent() && this.moduleSuiteValue.getSelectedItem() == null) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_ChooseRegularSuite"));
        } else if (this.isStandAlone() && (this.platformValue.getSelectedItem() == null || !((NbPlatform)this.platformValue.getSelectedItem()).isValid())) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_ChosenPlatformIsInvalid"));
        } else if (this.isSuiteWizard() && (this.suitePlatformValue.getSelectedItem() == null || !((NbPlatform)this.suitePlatformValue.getSelectedItem()).isValid())) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_ChosenPlatformIsInvalid"));
        } else if (this.getFolder().exists()) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_ProjectFolderExists"));
        } else if (!this.getLocationFile().exists()) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_LocationMustExist"));
        } else if (!this.getLocationFile().canWrite()) {
            this.setError(BasicInfoVisualPanel.getMessage("MSG_LocationNotWritable"));
        } else {
            this.markValid();
        }
    }

    private void updateGUI() {
        this.folderValue.setText(this.getFolder().getPath());
        if (this.isSuiteWizard() || this.isNetBeansOrgFolder()) {
            this.detachModuleTypeGroup();
        } else {
            this.attachModuleTypeGroup();
        }
        this.updateEnabled();
    }

    private void detachModuleTypeGroup() {
        if (this.moduleTypeGroupAttached) {
            this.lastSelectedType = this.moduleTypeGroup.getSelection();
            this.moduleTypeGroup.remove(this.standAloneModule);
            this.moduleTypeGroup.remove(this.suiteComponent);
            this.standAloneModule.setSelected(false);
            this.suiteComponent.setSelected(false);
            this.moduleTypeGroupAttached = false;
        }
    }

    private void attachModuleTypeGroup() {
        if (!this.moduleTypeGroupAttached) {
            this.moduleTypeGroup.add(this.standAloneModule);
            this.moduleTypeGroup.add(this.suiteComponent);
            if (this.isLibraryWizard()) {
                this.suiteComponent.setSelected(true);
            } else {
                this.moduleTypeGroup.setSelected(this.lastSelectedType, true);
            }
            this.moduleTypeGroupAttached = true;
        }
    }

    private void setProjectName(String string, int n) {
        String string2;
        while ((string2 = this.validFreeModuleName(string, n)) == null) {
            ++n;
        }
        this.nameValue.setText(string2);
    }

    private String validFreeModuleName(String string, int n) {
        String string2 = MessageFormat.format(string, new Integer(n));
        File file = new File(this.getLocationValue(), string2);
        return file.exists() ? null : string2;
    }

    void storeData() {
        this.getData().setProjectName(this.getNameValue());
        this.getData().setProjectLocation(this.getLocationValue());
        this.getData().setProjectFolder(this.folderValue.getText());
        this.getData().setMainProject(this.mainProject.isSelected());
        this.getData().setNetBeansOrg(this.isNetBeansOrgFolder());
        this.getData().setStandalone(this.isStandAlone());
        this.getData().setSuiteRoot((String)this.moduleSuiteValue.getSelectedItem());
        if (this.isSuiteWizard() && this.suitePlatformValue.getSelectedItem() != null) {
            this.getData().setPlatformID(((NbPlatform)this.suitePlatformValue.getSelectedItem()).getID());
        } else if (this.platformValue.getSelectedItem() != null) {
            this.getData().setPlatformID(((NbPlatform)this.platformValue.getSelectedItem()).getID());
        }
    }

    void refreshData() {
        if (this.getData().getProjectName() != null) {
            this.nameValue.setText(this.getData().getProjectName());
        } else {
            this.setInitialProjectName();
        }
    }

    private void setInitialProjectName() {
        String string = null;
        int n = 0;
        switch (this.getData().getWizardType()) {
            case SUITE: 
            case APPLICATION: {
                n = ModuleUISettings.getDefault().getNewSuiteCounter() + 1;
                string = "TXT_Suite";
                this.getData().setSuiteCounter(n);
                break;
            }
            case MODULE: 
            case SUITE_COMPONENT: {
                n = ModuleUISettings.getDefault().getNewModuleCounter() + 1;
                string = "TXT_Module";
                this.getData().setModuleCounter(n);
                break;
            }
            case LIBRARY_MODULE: {
                n = ModuleUISettings.getDefault().getNewModuleCounter() + 1;
                string = "TXT_Library";
                this.getData().setModuleCounter(n);
                break;
            }
            default: {
                assert (false) : "Unknown wizard type = " + (Object)((Object)this.getData().getWizardType());
                break;
            }
        }
        this.setProjectName(BasicInfoVisualPanel.getMessage(string), n);
        this.nameValue.select(0, this.nameValue.getText().length());
        this.nameUpdated = false;
    }

    private void attachDocumentListeners() {
        UIUtil.DocumentAdapter documentAdapter = new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicInfoVisualPanel.this.updateAndCheck();
            }
        };
        this.nameValue.getDocument().addDocumentListener(documentAdapter);
        this.nameValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicInfoVisualPanel.this.nameUpdated = true;
            }
        });
        this.locationValue.getDocument().addDocumentListener(documentAdapter);
        this.locationValue.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent documentEvent) {
                BasicInfoVisualPanel.this.locationUpdated = true;
            }
        });
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.updateAndCheck();
            }
        };
        this.platformValue.addActionListener(actionListener);
        this.suitePlatformValue.addActionListener(actionListener);
    }

    private File getFolder() {
        StringBuffer stringBuffer = new StringBuffer(this.getLocationValue());
        if (stringBuffer.length() != 0) {
            stringBuffer.append(File.separator);
        }
        stringBuffer.append(this.getNameValue());
        return FileUtil.normalizeFile((File)new File(stringBuffer.toString()));
    }

    private boolean isNetBeansOrgFolder() {
        return ModuleList.findNetBeansOrg(this.getFolder()) != null;
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(BasicInfoVisualPanel.class, (String)string);
    }

    private void initPlatformCombos() {
        if (this.platformValue.getItemCount() <= 0) {
            return;
        }
        boolean bl = false;
        String string = ModuleUISettings.getDefault().getLastUsedPlatformID();
        for (int i = 0; i < this.platformValue.getItemCount(); ++i) {
            if (!((NbPlatform)this.platformValue.getItemAt(i)).getID().equals(string)) continue;
            this.platformValue.setSelectedIndex(i);
            this.suitePlatformValue.setSelectedIndex(i);
            bl = true;
            break;
        }
        if (!bl) {
            NbPlatform nbPlatform = NbPlatform.getDefaultPlatform();
            this.platformValue.setSelectedItem(nbPlatform == null ? this.platformValue.getItemAt(0) : nbPlatform);
            this.suitePlatformValue.setSelectedItem(nbPlatform == null ? this.suitePlatformValue.getItemAt(0) : nbPlatform);
        }
    }

    private void setLocation(String string, boolean bl) {
        boolean bl2 = bl && !this.locationUpdated;
        this.locationValue.setText(string);
        this.locationUpdated = bl2 ^ true;
    }

    private void computeAndSetLocation(String string, boolean bl) {
        this.setLocation(this.computeLocationValue(string), bl);
    }

    private String computeLocationValue(String string) {
        File file;
        if (string == null) {
            string = System.getProperty("user.home");
        }
        if (!(file = new File(string)).exists() && file.getParent() != null) {
            return this.computeLocationValue(file.getParent());
        }
        return file.exists() ? string : System.getProperty("user.home");
    }

    private boolean isStandAlone() {
        return this.standAloneModule.isSelected();
    }

    private boolean isSuiteComponent() {
        return this.suiteComponent.isSelected();
    }

    private void initComponents() {
        this.moduleTypeGroup = new ButtonGroup();
        this.infoPanel = new JPanel();
        this.nameLbl = new JLabel();
        this.locationLbl = new JLabel();
        this.folderLbl = new JLabel();
        this.nameValue = new JTextField();
        this.locationValue = new JTextField();
        this.browseButton = new JButton();
        this.filler = new JLabel();
        this.folderValue = new JTextField();
        this.suitePlatform = new JLabel();
        this.suitePlatformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.manageSuitePlatform = new JButton();
        this.separator3 = new JSeparator();
        this.mainProject = new JCheckBox();
        this.typeChooserPanel = new JPanel();
        this.standAloneModule = new JRadioButton();
        this.platform = new JLabel();
        this.platformValue = PlatformComponentFactory.getNbPlatformsComboxBox();
        this.managePlatform = new JButton();
        this.suiteComponent = new JRadioButton();
        this.moduleSuite = new JLabel();
        this.moduleSuiteValue = PlatformComponentFactory.getSuitesComboBox();
        this.browseSuiteButton = new JButton();
        this.chooserFiller = new JLabel();
        this.pnlThouShaltBeholdLayout = new JPanel();
        this.setLayout(new GridBagLayout());
        this.infoPanel.setLayout(new GridBagLayout());
        this.nameLbl.setLabelFor(this.nameValue);
        Mnemonics.setLocalizedText((JLabel)this.nameLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.nameLbl, gridBagConstraints);
        this.locationLbl.setLabelFor(this.locationValue);
        Mnemonics.setLocalizedText((JLabel)this.locationLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectLocation"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.locationLbl, gridBagConstraints);
        this.folderLbl.setLabelFor(this.folderValue);
        Mnemonics.setLocalizedText((JLabel)this.folderLbl, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ProjectFolder"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.infoPanel.add((Component)this.folderLbl, gridBagConstraints);
        this.nameValue.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)this.nameValue, gridBagConstraints);
        this.locationValue.setHorizontalAlignment(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.locationValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_BrowseButton_o"));
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.browseLocation(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.browseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.weighty = 1.0;
        this.infoPanel.add((Component)this.filler, gridBagConstraints);
        this.folderValue.setEditable(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.infoPanel.add((Component)this.folderValue, gridBagConstraints);
        this.suitePlatform.setLabelFor(this.suitePlatformValue);
        Mnemonics.setLocalizedText((JLabel)this.suitePlatform, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 6, 12);
        this.infoPanel.add((Component)this.suitePlatform, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 6, 0);
        this.infoPanel.add((Component)this.suitePlatformValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.manageSuitePlatform, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_ManagePlatforms_g"));
        this.manageSuitePlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.manageSuitePlatformActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 12, 6, 0);
        this.infoPanel.add((Component)this.manageSuitePlatform, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 6, 0);
        this.infoPanel.add((Component)this.separator3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.infoPanel, gridBagConstraints);
        this.mainProject.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.mainProject, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_SetAsMainProject"));
        this.mainProject.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.mainProjectActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.mainProject, gridBagConstraints);
        this.typeChooserPanel.setLayout(new GridBagLayout());
        this.moduleTypeGroup.add(this.standAloneModule);
        this.standAloneModule.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.standAloneModule, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_StandaloneModule"));
        this.standAloneModule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.typeChanged(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.typeChooserPanel.add((Component)this.standAloneModule, gridBagConstraints);
        this.platform.setLabelFor(this.platformValue);
        Mnemonics.setLocalizedText((JLabel)this.platform, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_NetBeansPlatform"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 18, 0, 12);
        this.typeChooserPanel.add((Component)this.platform, gridBagConstraints);
        this.platformValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.platformChosen(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.typeChooserPanel.add((Component)this.platformValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.managePlatform, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_ManagePlatforms_g"));
        this.managePlatform.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.managePlatformActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.typeChooserPanel.add((Component)this.managePlatform, gridBagConstraints);
        this.moduleTypeGroup.add(this.suiteComponent);
        Mnemonics.setLocalizedText((AbstractButton)this.suiteComponent, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_AddToModuleSuite"));
        this.suiteComponent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.typeChanged(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(18, 0, 0, 0);
        this.typeChooserPanel.add((Component)this.suiteComponent, gridBagConstraints);
        this.moduleSuite.setLabelFor(this.moduleSuiteValue);
        Mnemonics.setLocalizedText((JLabel)this.moduleSuite, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"LBL_ModuleSuite"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 12);
        this.typeChooserPanel.add((Component)this.moduleSuite, gridBagConstraints);
        this.moduleSuiteValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.moduleSuiteChosen(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.typeChooserPanel.add((Component)this.moduleSuiteValue, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browseSuiteButton, (String)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"CTL_BrowseButton_w"));
        this.browseSuiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicInfoVisualPanel.this.browseModuleSuite(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.typeChooserPanel.add((Component)this.browseSuiteButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.typeChooserPanel.add((Component)this.chooserFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.typeChooserPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlThouShaltBeholdLayout, gridBagConstraints);
    }

    private void manageSuitePlatformActionPerformed(ActionEvent actionEvent) {
        this.managePlatform(this.suitePlatformValue);
    }

    private void mainProjectActionPerformed(ActionEvent actionEvent) {
        this.mainProjectTouched = true;
    }

    private void managePlatformActionPerformed(ActionEvent actionEvent) {
        this.managePlatform(this.platformValue);
    }

    private void managePlatform(JComboBox jComboBox) {
        NbPlatformCustomizer.showCustomizer();
        jComboBox.setModel(new PlatformComponentFactory.NbPlatformListModel());
        jComboBox.requestFocus();
        this.updateAndCheck();
    }

    private void platformChosen(ActionEvent actionEvent) {
        this.updateAndCheck();
    }

    private void moduleSuiteChosen(ActionEvent actionEvent) {
        if (!this.locationUpdated) {
            String string = (String)this.moduleSuiteValue.getSelectedItem();
            this.computeAndSetLocation(string, true);
            lastSelectedSuite = string;
        }
        this.updateAndCheck();
    }

    private void browseModuleSuite(ActionEvent actionEvent) {
        JFileChooser jFileChooser = ProjectChooser.projectChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            UIUtil.setProjectChooserDirParent(file);
            try {
                Project project = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)file));
                if (project != null) {
                    String string = SuiteUtils.getSuiteDirectoryPath(project);
                    if (string != null) {
                        PlatformComponentFactory.addUserSuite(string);
                        this.moduleSuiteValue.addItem(string);
                        this.moduleSuiteValue.setSelectedItem(string);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(BasicInfoVisualPanel.class, (String)"MSG_NotRegularSuite", (Object)ProjectUtils.getInformation((Project)project).getDisplayName())));
                    }
                }
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }
    }

    private void typeChanged(ActionEvent actionEvent) {
        if (!this.mainProjectTouched) {
            this.mainProject.setSelected(this.isStandAlone());
        }
        if (!this.locationUpdated) {
            this.setInitialLocation();
        }
        if (!this.nameUpdated) {
            this.setInitialProjectName();
        }
        this.updateAndCheck();
    }

    private void browseLocation(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(this.getLocationValue());
        jFileChooser.setFileSelectionMode(1);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            this.computeAndSetLocation(jFileChooser.getSelectedFile().getAbsolutePath(), false);
        }
    }
}

