/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.CreatedModifiedFilesFactory;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.wizard.librarydescriptor.NewLibraryDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CreatedModifiedFilesProvider {
    private static final String VOLUME_CLASS = "classpath";
    private static final String VOLUME_SRC = "src";
    private static final String VOLUME_JAVADOC = "javadoc";
    private static final String LIBRARY_LAYER_ENTRY = "org-netbeans-api-project-libraries/Libraries";

    private CreatedModifiedFilesProvider() {
    }

    static CreatedModifiedFiles createInstance(NewLibraryDescriptor.DataModel dataModel) {
        CreatedModifiedFiles createdModifiedFiles = new CreatedModifiedFiles(dataModel.getProject());
        CreatedModifiedFilesProvider.addOperations(createdModifiedFiles, dataModel);
        return createdModifiedFiles;
    }

    private static void addOperations(CreatedModifiedFiles createdModifiedFiles, NewLibraryDescriptor.DataModel dataModel) {
        FileObject fileObject = CreatedModifiedFiles.getTemplate("libdescriptemplate.xml");
        Map<String, String> map = CreatedModifiedFilesProvider.getTokens(createdModifiedFiles, dataModel.getProject(), dataModel);
        String string = CreatedModifiedFilesProvider.getLibraryDescriptorEntryPath(dataModel.getLibraryName());
        createdModifiedFiles.add(createdModifiedFiles.createLayerEntry(string, fileObject, map, null, null));
        createdModifiedFiles.add(createdModifiedFiles.bundleKeyDefaultBundle(dataModel.getLibraryName(), dataModel.getLibraryDisplayName()));
    }

    private static String getPackagePlusBundle(Project project) {
        NbModuleProject nbModuleProject = (NbModuleProject)project.getLookup().lookup(NbModuleProject.class);
        assert (nbModuleProject != null) : "this template works only with default netbeans modules.";
        ManifestManager manifestManager = ManifestManager.getInstance(nbModuleProject.getManifest(), false);
        String string = manifestManager.getLocalizingBundle().replace('/', '.');
        if (string.endsWith(".properties")) {
            string = string.substring(0, string.length() - 11);
        }
        return string;
    }

    static String getLibraryDescriptorEntryPath(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LIBRARY_LAYER_ENTRY).append("/").append(string).append(".xml");
        return stringBuffer.toString();
    }

    private static String transformURL(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jar:nbinst://").append(string).append("/");
        stringBuffer.append(string2).append(string3).append("!/");
        return stringBuffer.toString();
    }

    private static Map<String, String> getTokens(CreatedModifiedFiles createdModifiedFiles, Project project, NewLibraryDescriptor.DataModel dataModel) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Library library = dataModel.getLibrary();
        hashMap.put("NAME", dataModel.getLibraryName());
        hashMap.put("BUNDLE", CreatedModifiedFilesProvider.getPackagePlusBundle(project).replace('/', '.'));
        Iterator<URL> iterator = library.getContent(VOLUME_CLASS).iterator();
        hashMap.put("CLASSPATH", CreatedModifiedFilesProvider.getTokenSubstitution(iterator, createdModifiedFiles, dataModel, "libs/"));
        iterator = library.getContent(VOLUME_SRC).iterator();
        hashMap.put("SRC", CreatedModifiedFilesProvider.getTokenSubstitution(iterator, createdModifiedFiles, dataModel, "sources/"));
        iterator = library.getContent(VOLUME_JAVADOC).iterator();
        hashMap.put("JAVADOC", CreatedModifiedFilesProvider.getTokenSubstitution(iterator, createdModifiedFiles, dataModel, "docs/"));
        return hashMap;
    }

    private static String getTokenSubstitution(Iterator<URL> iterator, CreatedModifiedFiles createdModifiedFiles, NewLibraryDescriptor.DataModel dataModel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            URL uRL = iterator.next();
            String string2 = CreatedModifiedFilesProvider.addArchiveToCopy(createdModifiedFiles, dataModel, uRL, "release/" + string);
            if (string2 == null) continue;
            String string3 = dataModel.getModuleInfo().getCodeNameBase();
            String string4 = CreatedModifiedFilesProvider.transformURL(string3, string, string2);
            stringBuffer.append("<resource>");
            stringBuffer.append(string4);
            if (iterator.hasNext()) {
                stringBuffer.append("</resource>\n");
                continue;
            }
            stringBuffer.append("</resource>");
        }
        return stringBuffer.toString();
    }

    private static String addArchiveToCopy(CreatedModifiedFiles createdModifiedFiles, NewLibraryDescriptor.DataModel dataModel, URL uRL, String string) {
        FileObject fileObject;
        String string2 = null;
        URL uRL2 = FileUtil.getArchiveFile((URL)uRL);
        if (uRL2 != null && FileUtil.isArchiveFile((URL)uRL2)) {
            FileObject fileObject2 = URLMapper.findFileObject((URL)uRL2);
            if (fileObject2 == null) {
                return null;
            }
            string2 = fileObject2.getNameExt();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append(string2);
            createdModifiedFiles.add(createdModifiedFiles.createFile(stringBuffer.toString(), fileObject2));
        } else if ("file".equals(uRL.getProtocol()) && (fileObject = URLMapper.findFileObject((URL)uRL)) != null) {
            string2 = dataModel.getLibraryName() + ".zip";
            string = string + string2;
            createdModifiedFiles.add(new ZipAndCopyOperation(dataModel.getProject(), fileObject, string));
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ZipAndCopyOperation
    extends CreatedModifiedFilesFactory.OperationBase {
        private FileObject folderToZip;
        private String relativePath;

        ZipAndCopyOperation(Project project, FileObject fileObject, String string) {
            super(project);
            this.folderToZip = fileObject;
            this.relativePath = string;
            this.addCreatedOrModifiedPath(string, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() throws IOException {
            ArrayList arrayList = Collections.list(this.folderToZip.getChildren(true));
            if (arrayList.isEmpty()) {
                return;
            }
            FileObject fileObject = this.getProject().getProjectDirectory();
            assert (fileObject != null);
            FileObject fileObject2 = fileObject.getFileObject(this.relativePath);
            if (fileObject2 == null) {
                fileObject2 = FileUtil.createData((FileObject)fileObject, (String)this.relativePath);
            }
            assert (fileObject2 != null);
            FileLock fileLock = null;
            OutputStream outputStream = null;
            try {
                fileLock = fileObject2.lock();
                outputStream = fileObject2.getOutputStream(fileLock);
                ZipAndCopyOperation.createZipFile(outputStream, this.folderToZip, arrayList);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void createZipFile(OutputStream outputStream, FileObject fileObject, Collection<? extends FileObject> collection) throws IOException {
            ZipOutputStream zipOutputStream = null;
            try {
                zipOutputStream = new ZipOutputStream(outputStream);
                for (FileObject fileObject2 : collection) {
                    String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                    if (fileObject2.isFolder()) {
                        if (fileObject2.getChildren().length > 0) continue;
                        if (!string.endsWith("/")) {
                            string = string + "/";
                        }
                    }
                    ZipEntry zipEntry = new ZipEntry(string);
                    zipOutputStream.putNextEntry(zipEntry);
                    if (fileObject2.isData()) {
                        InputStream inputStream = null;
                        try {
                            inputStream = fileObject2.getInputStream();
                            FileUtil.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                    zipOutputStream.closeEntry();
                }
            }
            finally {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
            }
        }
    }
}

