/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.options.NewOptionsIterator;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class OptionsPanel0
extends BasicWizardIterator.Panel {
    private NewOptionsIterator.DataModel data;
    private DocumentListener fieldsDL;
    private JRadioButton advancedButton;
    private JCheckBox allowSecondaryPanelsCheckBox;
    private ButtonGroup buttonGroup1;
    private JTextField categoryNameField;
    private JLabel categoryNameLbl;
    private JLabel displayNameLbl1;
    private JPanel dummyPanel;
    private JButton iconButton;
    private JTextField iconField;
    private JLabel iconLbl;
    private JRadioButton optionsCategoryButton;
    private JComboBox primaryPanelCombo;
    private JLabel primaryPanelComboLbl;
    private JTextField primaryPanelTitle;
    private JTextField secondaryPanelTitle;
    private JLabel titleLbl;
    private JTextField tooltipField1;
    private JLabel tooltipLbl1;

    public OptionsPanel0(WizardDescriptor wizardDescriptor, NewOptionsIterator.DataModel dataModel) {
        super(wizardDescriptor);
        this.data = dataModel;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_OptionsWizardTitle"));
    }

    private String[] getPrimaryIdsFromLayer() {
        FileObject fileObject;
        ArrayList<String> arrayList = new ArrayList<String>();
        FileSystem fileSystem = LayerUtils.layerForProject(this.data.getProject()).layer(false);
        if (fileSystem != null && (fileObject = fileSystem.findResource("OptionsDialog")) != null) {
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (fileObject2.isFolder()) continue;
                arrayList.add(fileObject2.getName());
            }
            Collections.sort(arrayList);
        }
        arrayList.add(0, "Miscellaneous");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private void addListeners() {
        if (this.fieldsDL == null) {
            this.fieldsDL = new UIUtil.DocumentAdapter(){

                public void insertUpdate(DocumentEvent documentEvent) {
                    OptionsPanel0.this.updateData();
                }
            };
            this.categoryNameField.getDocument().addDocumentListener(this.fieldsDL);
            this.secondaryPanelTitle.getDocument().addDocumentListener(this.fieldsDL);
            this.iconField.getDocument().addDocumentListener(this.fieldsDL);
            this.primaryPanelTitle.getDocument().addDocumentListener(this.fieldsDL);
            this.tooltipField1.getDocument().addDocumentListener(this.fieldsDL);
            if (this.primaryPanelCombo.getEditor().getEditorComponent() instanceof JTextField) {
                ((JTextField)this.primaryPanelCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.fieldsDL);
            }
        }
    }

    private void removeListeners() {
        if (this.fieldsDL != null) {
            this.categoryNameField.getDocument().removeDocumentListener(this.fieldsDL);
            this.secondaryPanelTitle.getDocument().removeDocumentListener(this.fieldsDL);
            this.iconField.getDocument().removeDocumentListener(this.fieldsDL);
            this.primaryPanelTitle.getDocument().removeDocumentListener(this.fieldsDL);
            this.tooltipField1.getDocument().removeDocumentListener(this.fieldsDL);
            this.fieldsDL = null;
        }
    }

    protected void storeToDataModel() {
        this.removeListeners();
        this.updateData();
    }

    protected void readFromDataModel() {
        this.addListeners();
    }

    private void updateData() {
        int n = 0;
        if (this.advancedButton.isSelected()) {
            assert (!this.optionsCategoryButton.isSelected());
            n = this.data.setDataForSecondaryPanel(this.primaryPanelCombo.getEditor().getItem().toString(), this.secondaryPanelTitle.getText(), this.tooltipField1.getText());
        } else {
            assert (this.optionsCategoryButton.isSelected());
            n = this.data.setDataForPrimaryPanel(this.primaryPanelTitle.getText(), this.categoryNameField.getText(), this.iconField.getText(), this.allowSecondaryPanelsCheckBox.isSelected());
        }
        String string = this.data.getMessage(n);
        if (NewOptionsIterator.DataModel.isSuccessCode(n)) {
            this.markValid();
        } else if (NewOptionsIterator.DataModel.isErrorCode(n)) {
            this.setError(string);
        } else if (NewOptionsIterator.DataModel.isWarningCode(n)) {
            this.setWarning(string);
        } else if (NewOptionsIterator.DataModel.isInfoCode(n)) {
            this.setInfo(string, false);
        } else assert (false) : n;
    }

    protected String getPanelName() {
        return NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_OptionsPanel0_Title");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(OptionsPanel0.class);
    }

    private static String getMessage(String string) {
        return NbBundle.getMessage(OptionsPanel0.class, (String)string);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_OptionsPanel0"));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_LBL_Advanced"));
        this.optionsCategoryButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_LBL_OptionsCategory"));
        this.primaryPanelTitle.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_Title"));
        this.tooltipField1.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_Tooltip"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_DisplayName"));
        this.categoryNameField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_CategoryName"));
        this.iconField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_IconPath"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_IconButton"));
        this.allowSecondaryPanelsCheckBox.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_AllowSecondaryPanels"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("ACS_CTL_PrimaryPanelCombo"));
    }

    public void addNotify() {
        super.addNotify();
        this.addListeners();
        this.updateData();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeListeners();
    }

    private void enableDisable() {
        boolean bl = this.advancedButton.isSelected();
        assert (bl != this.optionsCategoryButton.isSelected());
        this.categoryNameField.setEnabled(!bl);
        this.categoryNameLbl.setEnabled(!bl);
        this.iconButton.setEnabled(!bl);
        this.iconField.setEnabled(!bl);
        this.iconLbl.setEnabled(!bl);
        this.primaryPanelTitle.setEnabled(!bl);
        this.titleLbl.setEnabled(!bl);
        this.allowSecondaryPanelsCheckBox.setEnabled(!bl);
        this.primaryPanelComboLbl.setEnabled(bl);
        this.primaryPanelCombo.setEnabled(bl);
        this.secondaryPanelTitle.setEnabled(bl);
        this.displayNameLbl1.setEnabled(bl);
        this.tooltipField1.setEnabled(bl);
        this.tooltipLbl1.setEnabled(bl);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.advancedButton = new JRadioButton();
        this.optionsCategoryButton = new JRadioButton();
        this.dummyPanel = new JPanel();
        this.categoryNameLbl = new JLabel();
        this.categoryNameField = new JTextField();
        this.displayNameLbl1 = new JLabel();
        this.secondaryPanelTitle = new JTextField();
        this.tooltipLbl1 = new JLabel();
        this.tooltipField1 = new JTextField();
        this.titleLbl = new JLabel();
        this.primaryPanelTitle = new JTextField();
        this.iconLbl = new JLabel();
        this.iconField = new JTextField();
        this.iconButton = new JButton();
        this.allowSecondaryPanelsCheckBox = new JCheckBox();
        this.primaryPanelComboLbl = new JLabel();
        this.primaryPanelCombo = new JComboBox();
        this.buttonGroup1.add(this.advancedButton);
        this.advancedButton.setSelected(true);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/wizard/options/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.advancedButton, (String)resourceBundle.getString("LBL_Advanced"));
        this.advancedButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.advancedButton.setMargin(new Insets(0, 0, 0, 0));
        this.advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.advancedButtonActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.optionsCategoryButton);
        Mnemonics.setLocalizedText((AbstractButton)this.optionsCategoryButton, (String)resourceBundle.getString("LBL_OptionsCategory"));
        this.optionsCategoryButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optionsCategoryButton.setMargin(new Insets(0, 0, 0, 0));
        this.optionsCategoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.optionsCategoryButtonActionPerformed(actionEvent);
            }
        });
        this.categoryNameLbl.setLabelFor(this.categoryNameField);
        Mnemonics.setLocalizedText((JLabel)this.categoryNameLbl, (String)resourceBundle.getString("LBL_CategoryName"));
        this.categoryNameLbl.setEnabled(false);
        this.categoryNameField.setEnabled(false);
        this.displayNameLbl1.setLabelFor(this.secondaryPanelTitle);
        Mnemonics.setLocalizedText((JLabel)this.displayNameLbl1, (String)resourceBundle.getString("LBL_DisplaName"));
        this.tooltipLbl1.setLabelFor(this.tooltipField1);
        Mnemonics.setLocalizedText((JLabel)this.tooltipLbl1, (String)resourceBundle.getString("LBL_Tooltip"));
        this.titleLbl.setLabelFor(this.primaryPanelTitle);
        Mnemonics.setLocalizedText((JLabel)this.titleLbl, (String)resourceBundle.getString("LBL_Title"));
        this.titleLbl.setEnabled(false);
        this.primaryPanelTitle.setEnabled(false);
        this.iconLbl.setLabelFor(this.iconField);
        Mnemonics.setLocalizedText((JLabel)this.iconLbl, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Icon"));
        this.iconLbl.setEnabled(false);
        this.iconField.setEditable(false);
        this.iconField.setText(NbBundle.getMessage(OptionsPanel0.class, (String)"CTL_None"));
        this.iconField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.iconButton, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_Icon_Browse"));
        this.iconButton.setEnabled(false);
        this.iconButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.iconButtonActionPerformed(actionEvent);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.allowSecondaryPanelsCheckBox, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_AllowSecondaryPanels"));
        this.allowSecondaryPanelsCheckBox.setEnabled(false);
        this.allowSecondaryPanelsCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.allowSecondaryPanelsCheckBoxActionPerformed(actionEvent);
            }
        });
        this.primaryPanelComboLbl.setLabelFor(this.primaryPanelCombo);
        Mnemonics.setLocalizedText((JLabel)this.primaryPanelComboLbl, (String)NbBundle.getMessage(OptionsPanel0.class, (String)"LBL_PrimaryPanelCombo"));
        this.primaryPanelCombo.setEditable(true);
        this.primaryPanelCombo.setModel(new DefaultComboBoxModel<String>(this.getPrimaryIdsFromLayer()));
        this.primaryPanelCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionsPanel0.this.primaryPanelComboActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.advancedButton, -2, 400, -2).add(98, 98, 98)).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.allowSecondaryPanelsCheckBox, -2, 215, -2).addContainerGap(277, Short.MAX_VALUE)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.tooltipLbl1).add((Component)this.displayNameLbl1).add((Component)this.primaryPanelComboLbl)).add(22, 22, 22).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.primaryPanelCombo, 0, 379, Short.MAX_VALUE).add((Component)this.secondaryPanelTitle, -1, 379, Short.MAX_VALUE).add((Component)this.tooltipField1, -1, 379, Short.MAX_VALUE)).add(10, 10, 10)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(13, 13, 13).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.categoryNameLbl).add((Component)this.iconLbl)).add(19, 19, 19).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.iconField, -1, 290, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.iconButton)).add((Component)this.categoryNameField, -1, 379, Short.MAX_VALUE).add((Component)this.primaryPanelTitle, -1, 379, Short.MAX_VALUE)).add(10, 10, 10)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(235, 235, 235).add((Component)this.dummyPanel, -2, -1, -2)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(13, 13, 13).add((Component)this.titleLbl).add(373, 373, 373))).add(1, (Component)this.optionsCategoryButton, -2, 400, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.advancedButton).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.primaryPanelComboLbl).add((Component)this.primaryPanelCombo, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.displayNameLbl1).add((Component)this.secondaryPanelTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.tooltipLbl1).add((Component)this.tooltipField1, -2, -1, -2)).add(12, 12, 12).add((Component)this.optionsCategoryButton).add(9, 9, 9).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.titleLbl).add((Component)this.primaryPanelTitle, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.categoryNameLbl).add((Component)this.categoryNameField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.iconLbl).add((Component)this.iconButton).add((Component)this.iconField, -2, -1, -2)).addPreferredGap(1).add((Component)this.allowSecondaryPanelsCheckBox).add(28, 28, 28).add((Component)this.dummyPanel, -2, -1, -2).add(56, 56, 56)));
        this.advancedButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.advancedButton.AccessibleContext.accessibleDescription"));
        this.optionsCategoryButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.optionsCategoryButton.AccessibleContext.accessibleDescription"));
        this.dummyPanel.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.dummyPanel.AccessibleContext.accessibleName"));
        this.dummyPanel.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.dummyPanel.AccessibleContext.accessibleDescription"));
        this.categoryNameLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.categoryNameLbl.AccessibleContext.accessibleDescription"));
        this.categoryNameField.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.categoryNameField.AccessibleContext.accessibleName"));
        this.categoryNameField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.categoryNameField.AccessibleContext.accessibleDescription"));
        this.displayNameLbl1.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.displayNameLbl1.AccessibleContext.accessibleDescription"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.displayNameField1.AccessibleContext.accessibleName"));
        this.secondaryPanelTitle.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.displayNameField1.AccessibleContext.accessibleDescription"));
        this.tooltipLbl1.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.tooltipLbl1.AccessibleContext.accessibleDescription"));
        this.tooltipField1.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.tooltipField1.AccessibleContext.accessibleName"));
        this.tooltipField1.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.tooltipField1.AccessibleContext.accessibleDescription"));
        this.titleLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.titleLbl.AccessibleContext.accessibleDescription"));
        this.primaryPanelTitle.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.titleField.AccessibleContext.accessibleName"));
        this.primaryPanelTitle.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.titleField.AccessibleContext.accessibleDescription"));
        this.iconLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconLbl.AccessibleContext.accessibleDescription"));
        this.iconField.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.iconField.AccessibleContext.accessibleName"));
        this.iconField.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconField.AccessibleContext.accessibleDescription"));
        this.iconButton.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.iconButton.AccessibleContext.accessibleDescription"));
        this.allowSecondaryPanelsCheckBox.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.allowSecondaryPanelsCheckBox.AccessibleContext.accessibleDescription"));
        this.primaryPanelComboLbl.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelComboLbl.AccessibleContext.accessibleDescription"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelCombo.AccessibleContext.accessibleName"));
        this.primaryPanelCombo.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.primaryPanelCombo.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(OptionsPanel0.getMessage("OptionsPanel0.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(OptionsPanel0.getMessage("OptionsPanel0.AccessibleContext.accessibleDescription"));
    }

    private void optionsCategoryButtonActionPerformed(ActionEvent actionEvent) {
        this.enableDisable();
        this.updateData();
    }

    private void advancedButtonActionPerformed(ActionEvent actionEvent) {
        this.enableDisable();
        this.updateData();
    }

    private void iconButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = UIUtil.getIconFileChooser(this.iconField.getText());
        int n = jFileChooser.showDialog(this, OptionsPanel0.getMessage("LBL_Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.iconField.setText(file.getAbsolutePath());
        }
    }

    private void allowSecondaryPanelsCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.updateData();
    }

    private void primaryPanelComboActionPerformed(ActionEvent actionEvent) {
        this.updateData();
    }
}

