/*
 * Decompiled with CFR 0.152.
 */
package net.java.bd.tools.security;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.naming.ldap.LdapName;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilderFactory;
import net.java.bd.tools.security.CredentialUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sun.misc.BASE64Decoder;
import sun.misc.HexDumpEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;

class CredentialVerifier {
    CredentialVerifier() {
    }

    public static void verify(String jarfile, String permReqFileName, String rootCert) throws Exception {
        JarFile jf = new JarFile(jarfile);
        ZipEntry je = jf.getEntry(permReqFileName);
        if (je == null) {
            CredentialVerifier.verifyError("Jar Entry:" + permReqFileName + " not found.");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document doc = factory.newDocumentBuilder().parse(jf.getInputStream(je));
        Element e = doc.getDocumentElement();
        Node credNode = CredentialUtil.getNodeWithTag(e, "persistentfilecredential");
        Node grantorNode = CredentialUtil.getNodeWithTag(credNode, "grantoridentifier");
        String grantorOrg = ((Element)grantorNode).getAttribute("id");
        System.out.println("*************** Verifying Credentials ***********");
        System.out.println("Grantor's organization Id:" + grantorOrg);
        grantorOrg = grantorOrg.substring(2);
        int grantorId = Integer.parseInt(grantorOrg, 16);
        X509Certificate[] grantorCerts = CredentialVerifier.verifyCertChainFileId(credNode, grantorId, jarfile);
        if (grantorCerts.length < 2) {
            CredentialVerifier.verifyError("Unable to find grantor certs");
        }
        System.out.println("####### <certchainfileid> Verification PASSED #######");
        CredentialVerifier.verifySignature(e, grantorId, jarfile, rootCert, grantorCerts);
        System.out.println("*************** Verification Done ***********");
    }

    private static void verifyError(String errMsg) {
        System.out.println("===========================");
        System.out.println("VERFICATION FAILED:" + errMsg);
        System.out.println("===========================");
        System.exit(1);
    }

    private static X509Certificate[] verifyCertChainFileId(Node credNode, int grantorId, String jarFileName) throws Exception {
        Node fileIdNode = CredentialUtil.getNodeWithTag(credNode, "certchainfileid");
        if (fileIdNode == null) {
            CredentialVerifier.verifyError("No elements in the permission request file with tag: certchainfileid");
        }
        String base64Data = fileIdNode.getTextContent();
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] derData = decoder.decodeBuffer(base64Data);
        DerInputStream derin = new DerInputStream(derData);
        DerValue[] issuerAndSerialNumber = derin.getSequence(2);
        byte[] issuerBytes = issuerAndSerialNumber[0].toByteArray();
        X500Principal issuerName = new X500Principal(issuerBytes);
        BigInteger certificateSerialNumber = issuerAndSerialNumber[1].getBigInteger();
        System.out.println("Looking for cert with issuerName:" + issuerName + " and cert serial no:" + Integer.toHexString(certificateSerialNumber.intValue()));
        X509Certificate[] returnCerts = new X509Certificate[2];
        Collection certs = CredentialVerifier.retrieveCerts(jarFileName);
        Iterator i = certs.iterator();
        int found = 0;
        while (i.hasNext() && found < 2) {
            X509Certificate cert = (X509Certificate)i.next();
            if (issuerName.equals(cert.getIssuerX500Principal())) {
                LdapName dn = new LdapName(issuerName.toString());
                String org = (String)dn.getRdn(dn.size() - 2).getValue();
                int indexOrgId = org.lastIndexOf(".");
                String orgId = null;
                if (indexOrgId != -1) {
                    orgId = org.substring(indexOrgId + 1);
                } else {
                    System.out.println("Could not retrieve the orgId");
                }
                int certOrgId = Integer.parseInt(orgId, 16);
                if (grantorId != certOrgId) {
                    System.out.println("grantor org Id with that in the certificate did not match");
                }
                if (certificateSerialNumber.equals(cert.getSerialNumber())) {
                    System.out.println("Found the grantor's certificate:" + cert.getSubjectX500Principal());
                    returnCerts[0] = cert;
                    ++found;
                }
            }
            if (!issuerName.equals(cert.getSubjectX500Principal()) || !issuerName.equals(cert.getIssuerX500Principal())) continue;
            returnCerts[1] = cert;
            ++found;
        }
        return returnCerts;
    }

    private static void verifySignature(Element e, int grantorId, String jarfile, String granteeRootCertName, X509Certificate[] grantorCerts) throws Exception {
        int credentialUsage = 0;
        String geOrgId = e.getAttribute("orgid");
        geOrgId = geOrgId.substring(2);
        int granteeOrgId = Integer.parseInt(geOrgId, 16);
        String geAppId = e.getAttribute("appid");
        geAppId = geAppId.substring(2);
        short granteeAppId = Short.parseShort(geAppId, 16);
        FileInputStream fis = new FileInputStream(granteeRootCertName);
        BufferedInputStream bis = new BufferedInputStream(fis);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate granteeRootCert = (X509Certificate)cf.generateCertificate(bis);
        byte[] granteeRootCertDigest = CredentialUtil.getCertDigest(granteeRootCert);
        byte[] grantorRootCertDigest = CredentialUtil.getCertDigest(grantorCerts[1]);
        Node credNode = CredentialUtil.getNodeWithTag(e, "persistentfilecredential");
        NodeList credAttrs = credNode.getChildNodes();
        String expDate = null;
        ArrayList<CredentialUtil.Files> fileList = new ArrayList<CredentialUtil.Files>();
        for (int i = 0; i < credAttrs.getLength(); ++i) {
            Node cNode = credAttrs.item(i);
            if (cNode.getNodeName().equals("expirationdate")) {
                expDate = ((Element)cNode).getAttribute("date");
                continue;
            }
            if (!cNode.getNodeName().equals("filename")) continue;
            String filePath = cNode.getTextContent();
            NamedNodeMap fileAttrs = cNode.getAttributes();
            String read = fileAttrs.getNamedItem("read").getNodeValue();
            String write = fileAttrs.getNamedItem("write").getNodeValue();
            CredentialUtil.Files f = new CredentialUtil.Files(read, write, filePath);
            fileList.add(f);
        }
        byte[] expiryDate = CredentialUtil.getAscii(expDate);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(450);
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeByte(credentialUsage);
        dos.writeInt(granteeOrgId);
        dos.writeShort(granteeAppId);
        dos.write(granteeRootCertDigest, 0, granteeRootCertDigest.length);
        dos.writeInt(grantorId);
        dos.write(grantorRootCertDigest, 0, grantorRootCertDigest.length);
        dos.write(expiryDate, 0, expiryDate.length);
        for (CredentialUtil.Files f : fileList) {
            byte[] readPerm = CredentialUtil.getAscii(f.read);
            byte[] writePerm = CredentialUtil.getAscii(f.write);
            byte[] filepath = CredentialUtil.getAscii(f.filepath);
            short fileLength = (short)filepath.length;
            dos.write(readPerm, 0, readPerm.length);
            dos.write(writePerm, 0, writePerm.length);
            dos.writeShort(fileLength);
            dos.write(filepath, 0, filepath.length);
        }
        dos.close();
        byte[] data = baos.toByteArray();
        System.out.println("Data gathered for signature verification:");
        HexDumpEncoder hexDump = new HexDumpEncoder();
        System.out.println(hexDump.encodeBuffer(data));
        Node signNode = CredentialUtil.getNodeWithTag(credNode, "signature");
        if (signNode == null) {
            CredentialVerifier.verifyError("No elements in the permission request file with tag: signature");
        }
        String base64Data = signNode.getTextContent();
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] signature = decoder.decodeBuffer(base64Data);
        Signature verifier = Signature.getInstance("SHA1withRSA");
        verifier.initVerify(grantorCerts[0]);
        verifier.update(data);
        boolean verified = verifier.verify(signature);
        if (verified) {
            System.out.println("####### Credentials signature verification PASSED ######");
        } else {
            CredentialVerifier.verifyError("Credentials signature verification FAILED");
        }
    }

    private static Collection retrieveCerts(String jarFileName) throws Exception {
        JarFile jf = new JarFile(jarFileName);
        JarEntry jarEntry = (JarEntry)jf.getEntry("META-INF/SIG-BD00.RSA");
        InputStream in = jf.getInputStream(jarEntry);
        CertificateFactory cf = CertificateFactory.getInstance("X509");
        Collection<? extends Certificate> certs = cf.generateCertificates(in);
        System.out.println("# of certs in the signed Jar File:" + certs.size());
        jf.close();
        return certs;
    }
}

