/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.application;

import com.sun.jersey.impl.application.InjectableProviderFactory;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.service.ComponentProvider;
import com.sun.jersey.spi.service.ServiceFinder;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComponentProviderCache {
    private static final Logger LOGGER = Logger.getLogger(ComponentProviderCache.class.getName());
    private final InjectableProviderFactory injectableFactory;
    private final ComponentProvider componentProvider;
    private final Set<Class<?>> providers;
    private final Set<?> providerInstances;
    private final Map<Class, Object> cache;

    public ComponentProviderCache(InjectableProviderFactory injectableFactory, ComponentProvider componentProvider, Set<Class<?>> providers, Set<?> providerInstances) {
        this.injectableFactory = injectableFactory;
        this.componentProvider = componentProvider;
        this.providers = providers;
        this.providerInstances = providerInstances;
        this.cache = new HashMap<Class, Object>();
        for (Object p : providerInstances) {
            this.cache.put(p.getClass(), p);
        }
    }

    public <T> Set<T> getProviders(Class<T> provider) {
        LinkedHashSet<T> ps = new LinkedHashSet<T>();
        ps.addAll(this.getProviderInstances(provider));
        for (Class pc : this.getProviderClasses(provider)) {
            Object o = this.getComponent(pc);
            if (o == null) continue;
            ps.add(provider.cast(o));
        }
        return ps;
    }

    public <T> Set<T> getProvidersAndServices(Class<T> provider) {
        LinkedHashSet<T> ps = new LinkedHashSet<T>();
        ps.addAll(this.getProviderInstances(provider));
        for (Class pc : this.getProviderAndServiceClasses(provider)) {
            Object o = this.getComponent(pc);
            if (o == null) continue;
            ps.add(provider.cast(o));
        }
        return ps;
    }

    public void injectOnComponents() {
        for (Object v : this.cache.values()) {
            this.componentProvider.inject(v);
        }
    }

    private Object getComponent(Class<?> provider) {
        Object o = this.cache.get(provider);
        if (o != null) {
            return o;
        }
        try {
            InjectableProviderFactory.ConstructorInjectablePair<?> cip = this.injectableFactory.getConstructor(provider);
            if (cip == null || cip.is.size() == 0) {
                o = this.componentProvider.getInstance(ComponentProvider.Scope.Singleton, provider);
            } else {
                Object[] params = new Object[cip.is.size()];
                int i = 0;
                for (Injectable injectable : cip.is) {
                    if (injectable == null) continue;
                    params[i++] = injectable.getValue(null);
                }
                o = this.componentProvider.getInstance(ComponentProvider.Scope.Singleton, cip.con, params);
            }
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.log(Level.CONFIG, "A dependent class, " + ex.getLocalizedMessage() + ", of the component " + provider + " is not found." + " The component is ignored.");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println(ex.getLocalizedMessage());
            LOGGER.log(Level.CONFIG, "The provider class, " + provider + ", could not be instantiated");
            return null;
        }
        this.cache.put(provider, o);
        return o;
    }

    private <T> Set<T> getProviderInstances(Class<T> service) {
        LinkedHashSet<T> sp = new LinkedHashSet<T>();
        for (Object p : this.providerInstances) {
            if (!service.isInstance(p)) continue;
            sp.add(service.cast(p));
        }
        return sp;
    }

    private Set<Class> getProviderClasses(Class<?> service) {
        LinkedHashSet<Class> sp = new LinkedHashSet<Class>();
        for (Class<?> p : this.providers) {
            if (!service.isAssignableFrom(p)) continue;
            sp.add(p);
        }
        return sp;
    }

    private Set<Class> getProviderAndServiceClasses(Class<?> service) {
        Class<?>[] pca;
        LinkedHashSet<Class> sp = new LinkedHashSet<Class>(this.getProviderClasses(service));
        LOGGER.log(Level.CONFIG, "Searching for providers that implement: " + service);
        for (Class<?> pc : pca = ServiceFinder.find(service, true).toClassArray()) {
            LOGGER.log(Level.CONFIG, "    Provider found: " + pc);
        }
        for (Class<?> pc : pca) {
            sp.add(pc);
        }
        return sp;
    }
}

