/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.modelapi.annotation;

import com.sun.jersey.impl.modelapi.annotation.AnnotatedMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodList
implements Iterable<AnnotatedMethod> {
    private AnnotatedMethod[] methods;

    public MethodList(Class c) {
        this(c.getMethods());
    }

    public MethodList(List<Method> methods) {
        this.methods = new AnnotatedMethod[methods.size()];
        for (int i = 0; i < methods.size(); ++i) {
            this.methods[i] = new AnnotatedMethod(methods.get(i));
        }
    }

    public MethodList(Method ... methods) {
        this.methods = new AnnotatedMethod[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            this.methods[i] = new AnnotatedMethod(methods[i]);
        }
    }

    public MethodList(AnnotatedMethod ... methods) {
        this.methods = methods;
    }

    @Override
    public Iterator<AnnotatedMethod> iterator() {
        return Arrays.asList(this.methods).iterator();
    }

    public <T extends Annotation> MethodList isNotPublic() {
        return this.filter(new Filter(){

            public boolean keep(AnnotatedMethod m) {
                return !Modifier.isPublic(m.getMethod().getModifiers());
            }
        });
    }

    public <T extends Annotation> MethodList hasNumParams(final int i) {
        return this.filter(new Filter(){

            public boolean keep(AnnotatedMethod m) {
                return m.getParameterTypes().length == i;
            }
        });
    }

    public <T extends Annotation> MethodList hasReturnType(final Class<?> r) {
        return this.filter(new Filter(){

            public boolean keep(AnnotatedMethod m) {
                return m.getMethod().getReturnType() == r;
            }
        });
    }

    public <T extends Annotation> MethodList nameStartsWith(final String s) {
        return this.filter(new Filter(){

            public boolean keep(AnnotatedMethod m) {
                return m.getMethod().getName().startsWith(s);
            }
        });
    }

    public <T extends Annotation> MethodList hasAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            public boolean keep(AnnotatedMethod m) {
                return m.getAnnotation(annotation) != null;
            }
        });
    }

    public <T extends Annotation> MethodList hasMetaAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            public boolean keep(AnnotatedMethod m) {
                for (Annotation a : m.getAnnotations()) {
                    if (a.annotationType().getAnnotation(annotation) == null) continue;
                    return true;
                }
                return false;
            }
        });
    }

    public <T extends Annotation> MethodList hasNotAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            public boolean keep(AnnotatedMethod m) {
                return m.getAnnotation(annotation) == null;
            }
        });
    }

    public <T extends Annotation> MethodList hasNotMetaAnnotation(final Class<T> annotation) {
        return this.filter(new Filter(){

            public boolean keep(AnnotatedMethod m) {
                for (Annotation a : m.getAnnotations()) {
                    if (a.annotationType().getAnnotation(annotation) == null) continue;
                    return false;
                }
                return true;
            }
        });
    }

    private MethodList filter(Filter f) {
        ArrayList<AnnotatedMethod> r = new ArrayList<AnnotatedMethod>();
        for (AnnotatedMethod m : this.methods) {
            if (!f.keep(m)) continue;
            r.add(m);
        }
        return new MethodList(r.toArray(new AnnotatedMethod[0]));
    }

    private static interface Filter {
        public boolean keep(AnnotatedMethod var1);
    }
}

