/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.provider.entity;

import com.sun.jersey.impl.ImplMessages;
import com.sun.jersey.impl.provider.entity.AbstractMessageReaderWriterProvider;
import com.sun.jersey.impl.util.ThrowHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONObjectProvider
extends AbstractMessageReaderWriterProvider<JSONObject> {
    public JSONObjectProvider() {
        Class<JSONObject> c = JSONObject.class;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return type == JSONObject.class;
    }

    public JSONObject readFrom(Class<JSONObject> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return new JSONObject(JSONObjectProvider.readFromAsString(entityStream, mediaType));
        }
        catch (JSONException je) {
            throw ThrowHelper.withInitCause((Exception)((Object)je), new IOException(ImplMessages.ERROR_PARSING_JSON_OBJECT()));
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations) {
        return type == JSONObject.class;
    }

    public void writeTo(JSONObject t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(entityStream, JSONObjectProvider.getCharset(mediaType, UTF8));
            t.write((Writer)writer);
            writer.write("\n");
            writer.flush();
        }
        catch (JSONException je) {
            throw ThrowHelper.withInitCause((Exception)((Object)je), new IOException(ImplMessages.ERROR_WRITING_JSON_OBJECT()));
        }
    }
}

