/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.provider.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class SourceProvider {
    private static IOException getIOException(Exception cause) throws IOException {
        IOException e = new IOException();
        e.initCause(cause);
        return e;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ProduceMime(value={"application/xml", "text/xml", "*/*"})
    @ConsumeMime(value={"application/xml", "text/xml", "*/*"})
    public static final class SourceWriter
    implements MessageBodyWriter<Source> {
        private final TransformerFactory tf = TransformerFactory.newInstance();

        public boolean isWriteable(Class<?> t, Type gt, Annotation[] as) {
            return Source.class.isAssignableFrom(t);
        }

        public long getSize(Source o) {
            return -1L;
        }

        public void writeTo(Source o, Class<?> t, Type gt, Annotation[] as, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
            try {
                StreamResult sr = new StreamResult(entityStream);
                this.tf.newTransformer().transform(o, sr);
            }
            catch (TransformerException ex) {
                throw SourceProvider.getIOException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ProduceMime(value={"application/xml", "text/xml", "*/*"})
    @ConsumeMime(value={"application/xml", "text/xml", "*/*"})
    public static final class DOMSourceReader
    implements MessageBodyReader<DOMSource> {
        private final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

        public DOMSourceReader() {
            this.dbf.setNamespaceAware(true);
        }

        public boolean isReadable(Class<?> t, Type gt, Annotation[] as) {
            return DOMSource.class == t;
        }

        public DOMSource readFrom(Class<DOMSource> t, Type gt, Annotation[] as, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
            try {
                Document d = this.dbf.newDocumentBuilder().parse(entityStream);
                return new DOMSource(d);
            }
            catch (SAXException ex) {
                throw SourceProvider.getIOException(ex);
            }
            catch (ParserConfigurationException ex) {
                throw SourceProvider.getIOException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ProduceMime(value={"application/xml", "text/xml", "*/*"})
    @ConsumeMime(value={"application/xml", "text/xml", "*/*"})
    public static final class SAXSourceReader
    implements MessageBodyReader<SAXSource> {
        public boolean isReadable(Class<?> t, Type gt, Annotation[] as) {
            return SAXSource.class == t;
        }

        public SAXSource readFrom(Class<SAXSource> t, Type gt, Annotation[] as, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
            return new SAXSource(new InputSource(entityStream));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @ProduceMime(value={"application/xml", "text/xml", "*/*"})
    @ConsumeMime(value={"application/xml", "text/xml", "*/*"})
    public static final class StreamSourceReader
    implements MessageBodyReader<StreamSource> {
        public boolean isReadable(Class<?> t, Type gt, Annotation[] as) {
            return StreamSource.class == t;
        }

        public StreamSource readFrom(Class<StreamSource> t, Type gt, Annotation[] as, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
            return new StreamSource(entityStream);
        }
    }
}

