/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.uri;

import com.sun.jersey.api.uri.UriComponent;
import com.sun.jersey.api.uri.UriTemplate;

public final class PathTemplate
extends UriTemplate {
    public PathTemplate(String template) {
        this(template, false);
    }

    public PathTemplate(String template, boolean encode) {
        super(PathTemplate.encodeOrValidate(PathTemplate.prefixWithSlash(template), encode));
    }

    private static String encodeOrValidate(String path, boolean encode) {
        if (encode) {
            return UriComponent.encode(path, UriComponent.Type.PATH, true);
        }
        UriComponent.validate(path, UriComponent.Type.PATH, true);
        return path;
    }

    private static String prefixWithSlash(String regex) {
        return !regex.startsWith("/") ? "/" + regex : regex;
    }
}

