/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.uri.rules;

import com.sun.jersey.impl.uri.PathPattern;
import com.sun.jersey.impl.uri.rules.AtomicMatchingPatterns;
import com.sun.jersey.impl.uri.rules.PatternRulePair;
import com.sun.jersey.impl.uri.rules.automata.AutomataMatchingUriTemplateRules;
import com.sun.jersey.spi.uri.rules.UriRule;
import com.sun.jersey.spi.uri.rules.UriRules;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UriRulesFactory {
    private UriRulesFactory() {
    }

    public static UriRules<UriRule> create(Map<PathPattern, UriRule> rulesMap) {
        return UriRulesFactory.create(rulesMap, null);
    }

    public static UriRules<UriRule> create(Map<PathPattern, UriRule> rulesMap, List<PatternRulePair<UriRule>> rules) {
        ArrayList<PatternRulePair<UriRule>> l = new ArrayList<PatternRulePair<UriRule>>();
        for (Map.Entry<PathPattern, UriRule> e : rulesMap.entrySet()) {
            l.add(new PatternRulePair<UriRule>(e.getKey(), e.getValue()));
        }
        if (rules != null) {
            l.addAll(rules);
        }
        return UriRulesFactory.create(l);
    }

    public static UriRules<UriRule> create(List<PatternRulePair<UriRule>> rules) {
        if (rules.size() < 8) {
            return new AtomicMatchingPatterns<UriRule>(rules);
        }
        return new AutomataMatchingUriTemplateRules<UriRule>(rules);
    }
}

