/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.spi.container;

import com.sun.jersey.api.Responses;
import com.sun.jersey.api.core.HttpRequestContext;
import com.sun.jersey.impl.MultivaluedMapImpl;
import com.sun.jersey.impl.VariantSelector;
import com.sun.jersey.impl.http.header.AcceptableMediaType;
import com.sun.jersey.impl.http.header.HttpHeaderFactory;
import com.sun.jersey.impl.http.header.reader.HttpHeaderReader;
import com.sun.jersey.impl.model.HttpHelper;
import com.sun.jersey.spi.container.InBoundHeaders;
import com.sun.jersey.spi.container.WebApplication;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWorkers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerRequest
implements HttpRequestContext {
    private static final Logger LOGGER = Logger.getLogger(ContainerRequest.class.getName());
    private static final Annotation[] EMTPTY_ANNOTATIONS = new Annotation[0];
    private final MessageBodyWorkers bodyContext;
    private String method;
    private InputStream entity;
    private URI baseUri;
    private URI requestUri;
    private URI absolutePathUri;
    private InBoundHeaders headers;
    private int headersModCount;
    private MediaType contentType;
    private List<MediaType> accept;
    private Map<String, Cookie> cookies;
    private MultivaluedMap<String, String> cookieNames;

    public ContainerRequest(WebApplication wa, String method, URI baseUri, URI requestUri, InBoundHeaders headers, InputStream entity) {
        this.bodyContext = wa.getMessageBodyWorkers();
        this.method = method;
        this.baseUri = baseUri;
        this.requestUri = requestUri;
        this.headers = headers;
        this.headersModCount = headers.getModCount();
        this.entity = entity;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setUris(URI baseUri, URI requestUri) {
        this.baseUri = baseUri;
        this.requestUri = requestUri;
        this.absolutePathUri = null;
    }

    public void setEntity(InputStream entity) {
        this.entity = entity;
    }

    public void setHeaders(InBoundHeaders headers) {
        this.headers = headers;
        this.headersModCount = headers.getModCount();
        this.contentType = null;
        this.accept = null;
        this.cookies = null;
        this.cookieNames = null;
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public URI getRequestUri() {
        return this.requestUri;
    }

    @Override
    public URI getAbsolutePath() {
        if (this.absolutePathUri != null) {
            return this.absolutePathUri;
        }
        this.absolutePathUri = UriBuilder.fromUri((URI)this.requestUri).encode(false).replaceQueryParams("").fragment("").build();
        return this.absolutePathUri;
    }

    @Override
    public String getHeaderValue(String name) {
        List v = (List)this.getRequestHeaders().get((Object)name);
        if (v == null) {
            return null;
        }
        if (v.isEmpty()) {
            return "";
        }
        if (v.size() == 1) {
            return (String)v.get(0);
        }
        StringBuilder sb = new StringBuilder((String)v.get(0));
        for (int i = 1; i < v.size(); ++i) {
            String s = (String)v.get(i);
            if (s.length() <= 0) continue;
            sb.append(',').append(s);
        }
        return sb.toString();
    }

    @Override
    public <T> T getEntity(Class<T> type, Type genericType, Annotation[] as) {
        try {
            MediaType mediaType = this.getMediaType();
            MessageBodyReader bw = this.bodyContext.getMessageBodyReader(type, genericType, as, mediaType);
            if (bw == null) {
                LOGGER.severe("A message body reader for Java type, " + type + ", and MIME media type, " + mediaType + ", was not found");
                throw new WebApplicationException(Responses.unsupportedMediaType().build());
            }
            return (T)bw.readFrom(type, genericType, as, mediaType, (MultivaluedMap)this.headers, this.entity);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public <T> T getEntity(Class<T> type) {
        return this.getEntity(type, type, EMTPTY_ANNOTATIONS);
    }

    @Override
    public String getHttpMethod() {
        return this.method;
    }

    @Override
    public MediaType getAcceptableMediaType(List<MediaType> mediaTypes) {
        if (mediaTypes.isEmpty()) {
            return this.getAcceptableMediaTypes().get(0);
        }
        for (MediaType a : this.getAcceptableMediaTypes()) {
            if (a.getType().equals("*")) {
                return mediaTypes.get(0);
            }
            for (MediaType m : mediaTypes) {
                if (!m.isCompatible(a)) continue;
                return m;
            }
        }
        return null;
    }

    @Override
    public MultivaluedMap<String, String> getCookieNameValueMap() {
        if (this.cookieNames == null || this.headersModCount != this.headers.getModCount()) {
            this.cookieNames = new MultivaluedMapImpl();
            for (Map.Entry<String, Cookie> e : this.getCookies().entrySet()) {
                this.cookieNames.putSingle((Object)e.getKey(), (Object)e.getValue().getValue());
            }
        }
        return this.cookieNames;
    }

    public MultivaluedMap<String, String> getRequestHeaders() {
        return this.headers;
    }

    public List<String> getRequestHeader(String name) {
        return (List)this.headers.get(name);
    }

    public List<MediaType> getAcceptableMediaTypes() {
        if (this.accept == null || this.headersModCount != this.headers.getModCount()) {
            this.accept = new ArrayList<AcceptableMediaType>(HttpHelper.getAccept(this));
        }
        return this.accept;
    }

    public List<String> getAcceptableLanguages() {
        throw new UnsupportedOperationException();
    }

    public MediaType getMediaType() {
        if (this.contentType == null || this.headersModCount != this.headers.getModCount()) {
            this.contentType = HttpHelper.getContentType(this);
        }
        return this.contentType;
    }

    public String getLanguage() {
        return (String)this.getRequestHeaders().getFirst((Object)"Content-Langauge");
    }

    public Map<String, Cookie> getCookies() {
        if (this.cookies == null || this.headersModCount != this.headers.getModCount()) {
            this.cookies = new HashMap<String, Cookie>();
            List cl = (List)this.getRequestHeaders().get((Object)"Cookie");
            if (cl != null) {
                for (String cookie : cl) {
                    if (cookie == null) continue;
                    this.cookies.putAll(HttpHeaderFactory.createCookies(cookie));
                }
            }
        }
        return this.cookies;
    }

    public Variant selectVariant(List<Variant> variants) {
        if (variants == null || variants.isEmpty()) {
            throw new IllegalArgumentException("The list of variants is null or empty");
        }
        return VariantSelector.selectVariant(this, variants);
    }

    public Response.ResponseBuilder evaluatePreconditions(EntityTag eTag) {
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r == null) {
            r = this.evaluateIfNoneMatch(eTag);
        }
        return r;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified) {
        long lastModifiedTime = lastModified.getTime();
        Response.ResponseBuilder r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
        if (r == null) {
            r = this.evaluateIfModifiedSince(lastModifiedTime);
        }
        return r;
    }

    public Response.ResponseBuilder evaluatePreconditions(Date lastModified, EntityTag eTag) {
        Response.ResponseBuilder r = this.evaluateIfMatch(eTag);
        if (r == null) {
            long lastModifiedTime = lastModified.getTime();
            r = this.evaluateIfUnmodifiedSince(lastModifiedTime);
            if (r == null) {
                r = this.evaluateIfNoneMatch(eTag);
            }
            if (r == null) {
                r = this.evaluateIfModifiedSince(lastModifiedTime);
            }
        }
        return r;
    }

    private Response.ResponseBuilder evaluateIfMatch(EntityTag eTag) {
        String ifMatchHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Match");
        if (ifMatchHeader != null && !ifMatchHeader.trim().equals("*") && !ifMatchHeader.contains(eTag.getValue())) {
            return Responses.preconditionFailed();
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfNoneMatch(EntityTag eTag) {
        String ifNoneMatchHeader = (String)this.getRequestHeaders().getFirst((Object)"If-None-Match");
        if (ifNoneMatchHeader != null && (ifNoneMatchHeader.trim().equals("*") || ifNoneMatchHeader.contains(eTag.getValue()))) {
            String httpMethod = this.getHttpMethod();
            if (httpMethod.equals("GET") || httpMethod.equals("HEAD")) {
                return Response.notModified((EntityTag)eTag);
            }
            return Responses.preconditionFailed();
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfUnmodifiedSince(long lastModified) {
        String ifUnmodifiedSinceHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Unmodified-Since");
        if (ifUnmodifiedSinceHeader != null) {
            try {
                long ifUnmodifiedSince = HttpHeaderReader.readDate(ifUnmodifiedSinceHeader).getTime() + 1000L;
                if (lastModified > ifUnmodifiedSince) {
                    return Responses.preconditionFailed();
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private Response.ResponseBuilder evaluateIfModifiedSince(long lastModified) {
        String ifModifiedSinceHeader = (String)this.getRequestHeaders().getFirst((Object)"If-Modified-Since");
        if (ifModifiedSinceHeader != null) {
            try {
                long ifModifiedSince = HttpHeaderReader.readDate(ifModifiedSinceHeader).getTime() + 1000L;
                if (ifModifiedSince > lastModified) {
                    return Responses.notModified();
                }
            }
            catch (ParseException ex) {
                // empty catch block
            }
        }
        return null;
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException();
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException();
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException();
    }

    public String getAuthenticationScheme() {
        throw new UnsupportedOperationException();
    }
}

