/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.design;

import java.awt.Color;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.design.CasaDesignModelListener;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphUtilities;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeFactory;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.AutoLayoutAction;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.BuildAction;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.CasaValidateAction;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.DeployAction;
import org.openide.util.NbBundle;

public class CasaDesignView {
    private CasaDataObject mDataObject;
    private CasaModelGraphScene mScene;
    private CasaDesignModelListener mModelListener;
    private JScrollPane mScroller;
    private JToolBar mToolBar;
    private AbstractAction mAutoLayoutAction;
    private AbstractAction mBuildAction;
    private AbstractAction mDeployAction;
    private AbstractAction mValidateAction;

    public CasaDesignView(CasaDataObject casaDataObject) {
        this.mDataObject = casaDataObject;
        this.mScroller = new JScrollPane();
        this.mScroller.getVerticalScrollBar().setUnitIncrement(30);
        this.mScroller.getHorizontalScrollBar().setUnitIncrement(20);
        final CasaWrapperModel casaWrapperModel = this.mDataObject.getEditorSupport().getModel();
        if (casaWrapperModel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    new CasaValidateAction(casaWrapperModel).actionPerformed(null);
                }
            });
        }
        JComponent jComponent = null;
        if (casaWrapperModel == null) {
            jComponent = this.getErrorPane();
        } else {
            this.mScene = new CasaModelGraphScene(this.mDataObject, casaWrapperModel, new CasaNodeFactory(this.mDataObject, casaWrapperModel));
            this.mDataObject.getEditorSupport().setScene(this.mScene);
            jComponent = this.mScene.getViewComponent();
            this.initializeSceneForDesignView();
        }
        this.mScroller.setViewportView(jComponent);
        this.setupActions();
        this.setupToolBar();
        if (casaWrapperModel != null) {
            this.mModelListener = new CasaDesignModelListener(this.mDataObject, this.mScene);
            this.mScene.registerModelListener(this.mModelListener);
        }
    }

    public void render() {
        CasaWrapperModel casaWrapperModel = this.mDataObject.getEditorSupport().getModel();
        if (casaWrapperModel != null) {
            CasaModelGraphUtilities.renderModel(casaWrapperModel, this.mScene);
        }
    }

    public JComponent getContent() {
        return this.mScene.getViewComponent();
    }

    private void initializeSceneForDesignView() {
        this.mScroller.addComponentListener(new ComponentAdapter(){
            private boolean mIsIgnoringResizeEvents;

            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getID() == 101 && !this.mIsIgnoringResizeEvents && CasaDesignView.this.mScene != null && CasaDesignView.this.mScene.isVisible() && CasaDesignView.this.mScene.isValidated()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            mIsIgnoringResizeEvents = true;
                            RegionUtilities.stretchScene(CasaDesignView.this.mScene);
                            mIsIgnoringResizeEvents = false;
                        }
                    });
                }
            }
        });
        AdjustmentListener adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                if (!adjustmentEvent.getValueIsAdjusting() && CasaDesignView.this.mScene != null && CasaDesignView.this.mScene.isVisible() && CasaDesignView.this.mScene.isValidated()) {
                    try {
                        RegionUtilities.stretchScene(CasaDesignView.this.mScene);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace(System.err);
                    }
                }
            }
        };
        this.mScroller.getHorizontalScrollBar().addAdjustmentListener(adjustmentListener);
        this.mScroller.getVerticalScrollBar().addAdjustmentListener(adjustmentListener);
    }

    private void setupActions() {
        CasaWrapperModel casaWrapperModel = this.mScene.getModel();
        this.mAutoLayoutAction = new AutoLayoutAction(this.mDataObject);
        this.mBuildAction = new BuildAction(casaWrapperModel);
        this.mDeployAction = new DeployAction(casaWrapperModel);
        this.mValidateAction = new CasaValidateAction(casaWrapperModel);
    }

    private void setupToolBar() {
        this.mToolBar = new JToolBar();
        this.mToolBar.addSeparator();
        this.mToolBar.add(this.createButton(this.mAutoLayoutAction, (String)this.mAutoLayoutAction.getValue("Name"), (Icon)this.mAutoLayoutAction.getValue("SmallIcon")));
        this.mToolBar.addSeparator();
        this.mToolBar.add(this.createButton(this.mBuildAction, (String)this.mBuildAction.getValue("Name"), (Icon)this.mBuildAction.getValue("SmallIcon")));
        this.mToolBar.add(this.createButton(this.mDeployAction, (String)this.mDeployAction.getValue("Name"), (Icon)this.mDeployAction.getValue("SmallIcon")));
        this.mToolBar.addSeparator();
        this.mToolBar.add(this.createButton(this.mValidateAction, (String)this.mValidateAction.getValue("Name"), (Icon)this.mValidateAction.getValue("SmallIcon")));
    }

    private JButton createButton(Action action, String string, Icon icon) {
        JButton jButton = new JButton(action);
        jButton.setText("");
        jButton.setToolTipText(string);
        jButton.setIcon(icon);
        return jButton;
    }

    public JToolBar getToolBar() {
        return this.mToolBar;
    }

    public JComponent getComponent() {
        return this.mScroller;
    }

    public JComponent getErrorPane() {
        JLabel jLabel = new JLabel();
        jLabel.setText(NbBundle.getMessage(this.getClass(), (String)"MSG_ModelError"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setHorizontalTextPosition(0);
        jLabel.setEnabled(false);
        Color color = UIManager.getColor("window");
        jLabel.setBackground(color != null ? color : Color.white);
        jLabel.setOpaque(true);
        return jLabel;
    }

    public void closeView() {
        if (this.mScene != null) {
            this.mScene.cleanup();
            this.mScene = null;
        }
        if (this.mModelListener != null) {
            this.mModelListener.cleanup();
        }
    }

    public CasaModelGraphScene getScene() {
        return this.mScene;
    }
}

