/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.design;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.router.RouterFactory;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.design.CasaDesignModelListener;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphUtilities;
import org.netbeans.modules.compapp.casaeditor.graph.BannerSceneListener;
import org.netbeans.modules.compapp.casaeditor.graph.CasaConnectionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.CasaGraphAbstractScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetBinding;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngine;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngineExternal;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngineInternal;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidgetBindingConsumes;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidgetBindingProvides;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidgetEngineConsumes;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidgetEngineProvides;
import org.netbeans.modules.compapp.casaeditor.graph.CasaProcessTitleWidget;
import org.netbeans.modules.compapp.casaeditor.graph.CasaRegionWidget;
import org.netbeans.modules.compapp.casaeditor.graph.ErrableWidget;
import org.netbeans.modules.compapp.casaeditor.graph.RegionResizeHandler;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;
import org.netbeans.modules.compapp.casaeditor.graph.WidgetMover;
import org.netbeans.modules.compapp.casaeditor.graph.actions.CasaBadgeEditAction;
import org.netbeans.modules.compapp.casaeditor.graph.actions.CasaConnectAction;
import org.netbeans.modules.compapp.casaeditor.graph.actions.CasaPaletteAcceptProvider;
import org.netbeans.modules.compapp.casaeditor.graph.actions.CasaPopupMenuAction;
import org.netbeans.modules.compapp.casaeditor.graph.actions.CasaPopupMenuProvider;
import org.netbeans.modules.compapp.casaeditor.graph.actions.CasaRemoveAction;
import org.netbeans.modules.compapp.casaeditor.graph.actions.DoubleClickToOpenAction;
import org.netbeans.modules.compapp.casaeditor.graph.actions.MouseWheelScrollAction;
import org.netbeans.modules.compapp.casaeditor.graph.actions.RegionResizeAction;
import org.netbeans.modules.compapp.casaeditor.graph.layout.CasaRectangularSelectAction;
import org.netbeans.modules.compapp.casaeditor.graph.layout.CustomizableDevolveLayout;
import org.netbeans.modules.compapp.casaeditor.graph.layout.LayoutBindings;
import org.netbeans.modules.compapp.casaeditor.graph.layout.LayoutEngines;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConsumes;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpoint;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaPort;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaProvides;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaRegion;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.model.casa.validation.CasaValidationListener;
import org.netbeans.modules.compapp.casaeditor.multiview.CasaGraphMultiViewElement;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeFactory;
import org.netbeans.modules.compapp.casaeditor.nodes.ServiceUnitProcessNode;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaModelGraphScene
extends CasaGraphAbstractScene<CasaComponent, CasaComponent, CasaComponent, CasaComponent>
implements PropertyChangeListener,
CasaValidationListener {
    private static final Logger LOGGER = Logger.getLogger(CasaModelGraphScene.class.getName());
    private LayerWidget mMainLayer = new LayerWidget((Scene)this);
    private LayerWidget mConnectionLayer = new LayerWidget((Scene)this);
    private LayerWidget mGlassLayer = new LayerWidget((Scene)this);
    private LayerWidget mDragLayer = new LayerWidget((Scene)this);
    private Router mOrthogonalRouter;
    private Router mDirectRouter;
    private Router mCurrentRouter = this.mDirectRouter = RouterFactory.createDirectRouter();
    private WidgetAction mDoubleClickOpenAction = new DoubleClickToOpenAction();
    private WidgetAction mPopupMenuAction = new CasaPopupMenuAction(new CasaPopupMenuProvider());
    private WidgetAction mMoveControlPointAction = ActionFactory.createOrthogonalMoveControlPointAction();
    private WidgetAction mMoveActionBindingRegion;
    private WidgetAction mMoveActionEngineRegion;
    private WidgetAction mMoveActionExternalRegion;
    private CasaRegionWidget mBindingRegion;
    private CasaRegionWidget mEngineRegion;
    private CasaRegionWidget mExternalRegion;
    private int mMinimumWidthUnit = 100;
    private Widget mLeftResizer;
    private Widget mMiddleResizer;
    private CustomizableDevolveLayout mBindingAutoLayout;
    private CustomizableDevolveLayout mEngineAutoLayout;
    private CustomizableDevolveLayout mExternalAutoLayout;
    private CasaDataObject mDataObject;
    private CasaWrapperModel mModel;
    private CasaDesignModelListener mModelListener;
    private CasaNodeFactory mNodeFactory;
    private boolean mIsInternalNodeChange;
    private boolean mIsModelPositionsFinalized = false;
    private boolean mIsAdjusting = false;

    public CasaModelGraphScene(CasaDataObject casaDataObject, CasaWrapperModel casaWrapperModel, CasaNodeFactory casaNodeFactory) {
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_CHILDREN_AND_ITS_PARENTS);
        this.mDataObject = casaDataObject;
        this.mModel = casaWrapperModel;
        this.mNodeFactory = casaNodeFactory;
        CasaFactory.getCasaCustomizerRegistor().addPropertyListener(this);
        super.setMaximumBounds(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.addChild((Widget)this.mMainLayer);
        this.addChild((Widget)this.mConnectionLayer);
        this.addChild((Widget)this.mGlassLayer);
        this.addChild((Widget)this.mDragLayer);
        this.mLeftResizer = new Widget((Scene)this);
        this.mMiddleResizer = new Widget((Scene)this);
        CasaModelGraphScene.initializeResizer((Widget)this.mMainLayer, this.mLeftResizer);
        CasaModelGraphScene.initializeResizer((Widget)this.mMainLayer, this.mMiddleResizer);
        WidgetMover widgetMover = new WidgetMover(this.mModel, false, false);
        WidgetMover widgetMover2 = new WidgetMover(this.mModel, true, false);
        WidgetMover widgetMover3 = new WidgetMover(this.mModel, true, true);
        this.mMoveActionBindingRegion = ActionFactory.createMoveAction((MoveStrategy)widgetMover, (MoveProvider)widgetMover);
        this.mMoveActionEngineRegion = ActionFactory.createMoveAction((MoveStrategy)widgetMover2, (MoveProvider)widgetMover2);
        this.mMoveActionExternalRegion = ActionFactory.createMoveAction((MoveStrategy)widgetMover3, (MoveProvider)widgetMover3);
        TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        this.initializeSceneActions();
        ToolTipManager.sharedInstance().setInitialDelay(0);
        casaWrapperModel.getValidationController().addValidationListener(this);
    }

    public LayerWidget getGlassLayer() {
        return this.mGlassLayer;
    }

    public boolean isModelPositionsFinalized() {
        return this.mIsModelPositionsFinalized;
    }

    public void setModelPositionsFinalized(boolean bl) {
        this.mIsModelPositionsFinalized = bl;
    }

    public void persistLocation(CasaNodeWidget casaNodeWidget, Point point) {
        if (point != null && casaNodeWidget.getBounds() != null && !this.isAdjusting()) {
            if (!this.mIsModelPositionsFinalized) {
                this.finalizeModelPositions();
            } else {
                CasaModelGraphUtilities.updateModelPosition(this, (CasaComponent)this.findObject(casaNodeWidget), point);
            }
        }
    }

    public void persistWidth(CasaRegionWidget casaRegionWidget) {
        if (!this.isAdjusting()) {
            if (!this.mIsModelPositionsFinalized) {
                this.finalizeModelPositions();
            }
            CasaModelGraphUtilities.updateWidth(this, casaRegionWidget);
        }
    }

    public void finalizeModelPositions() {
        boolean bl = false;
        for (CasaComponent casaComponent : this.getNodes()) {
            CasaNodeWidget casaNodeWidget = (CasaNodeWidget)this.findWidget(casaComponent);
            if (casaNodeWidget == null) continue;
            Point point = casaNodeWidget.getPreferredLocation();
            if (point != null) {
                CasaModelGraphUtilities.updateModelPosition(this, casaComponent, point);
                continue;
            }
            bl = true;
        }
        if (bl) {
            LOGGER.log(Level.WARNING, NbBundle.getMessage(this.getClass(), (String)"Warning_Null_Position"));
        } else {
            this.mIsModelPositionsFinalized = true;
        }
    }

    public void setIsAdjusting(boolean bl) {
        this.mIsAdjusting = bl;
    }

    public boolean isAdjusting() {
        return this.mIsAdjusting;
    }

    private static void initializeResizer(Widget widget, Widget widget2) {
        widget.addChild(widget2);
        widget2.setOpaque(false);
        widget2.setBackground((Paint)RegionUtilities.RESIZER_COLOR);
        widget2.setPreferredBounds(new Rectangle(new Dimension(4, 500)));
    }

    private void initializeSceneActions() {
        this.getActions().addAction((WidgetAction)new MouseWheelScrollAction());
        this.getActions().addAction(ActionFactory.createPanAction());
        RegionResizeHandler regionResizeHandler = new RegionResizeHandler(this, this.mLeftResizer, this.mMiddleResizer);
        this.getActions().addAction((WidgetAction)new RegionResizeAction(this, this.mLeftResizer, this.mMiddleResizer, regionResizeHandler));
        this.getActions().addAction((WidgetAction)new CasaRectangularSelectAction(new RectangularSelectDecorator(){

            public Widget createSelectionWidget() {
                Widget widget = new Widget((Scene)CasaModelGraphScene.this);
                widget.setBorder(BorderFactory.createDashedBorder((Color)Color.DARK_GRAY, (int)4, (int)3, (boolean)true));
                widget.setOpaque(false);
                return widget;
            }
        }, this.mGlassLayer, ActionFactory.createObjectSceneRectangularSelectProvider((ObjectScene)this)));
        this.getActions().addAction(this.mPopupMenuAction);
        this.getActions().addAction((WidgetAction)new CasaRemoveAction(this, this.mModel));
        this.getActions().addAction(CasaFactory.createAcceptAction(new CasaPaletteAcceptProvider(this, this.mModel)));
        this.getActions().addAction(CasaFactory.createCycleCasaSceneSelectAction());
        this.addSceneListener(new BannerSceneListener(this));
    }

    public void registerModelListener(CasaDesignModelListener casaDesignModelListener) {
        this.mModelListener = casaDesignModelListener;
    }

    public CasaNodeFactory getNodeFactory() {
        return this.mNodeFactory;
    }

    public LayerWidget getDragLayer() {
        return this.mDragLayer;
    }

    public LayerWidget getConnectionLayer() {
        return this.mConnectionLayer;
    }

    public Widget getLeftResizer() {
        return this.mLeftResizer;
    }

    public Widget getMiddleResizer() {
        return this.mMiddleResizer;
    }

    public CasaWrapperModel getModel() {
        return this.mModel;
    }

    public void updateEdgeRouting(ConnectionWidget connectionWidget) {
        boolean bl = false;
        if (this.getEdges().size() <= 15 && this.getNodes().size() <= 15) {
            if (this.mCurrentRouter != this.mOrthogonalRouter) {
                this.mCurrentRouter = this.mOrthogonalRouter;
                bl = true;
            }
        } else if (this.mCurrentRouter != this.mDirectRouter) {
            this.mCurrentRouter = this.mDirectRouter;
            bl = true;
        }
        if (bl) {
            for (CasaComponent casaComponent : this.getEdges()) {
                ConnectionWidget connectionWidget2 = (ConnectionWidget)this.findWidget(casaComponent);
                connectionWidget2.setRouter(this.mCurrentRouter);
            }
        } else if (connectionWidget != null) {
            connectionWidget.setRouter(this.mCurrentRouter);
        }
    }

    public void setOrthogonalRouter(Router router) {
        this.mOrthogonalRouter = router;
    }

    public void autoLayout(boolean bl) {
        this.doLayout(false, bl, this.getBindingRegion(), this.getEngineRegion(), this.getExternalRegion());
    }

    public void progressiveLayout(boolean bl) {
        this.doLayout(true, bl, this.getBindingRegion(), this.getEngineRegion(), this.getExternalRegion());
    }

    public void progressiveRegionLayout(CasaRegionWidget casaRegionWidget, boolean bl) {
        this.doLayout(true, bl, casaRegionWidget);
    }

    private void doLayout(boolean bl, boolean bl2, CasaRegionWidget ... casaRegionWidgetArray) {
        if (casaRegionWidgetArray.length == 0) {
            return;
        }
        for (CasaRegionWidget casaRegionWidget : casaRegionWidgetArray) {
            CustomizableDevolveLayout customizableDevolveLayout = null;
            if (casaRegionWidget == this.mBindingRegion) {
                customizableDevolveLayout = this.mBindingAutoLayout;
            } else if (casaRegionWidget == this.mEngineRegion) {
                customizableDevolveLayout = this.mEngineAutoLayout;
            } else if (casaRegionWidget == this.mExternalRegion) {
                customizableDevolveLayout = this.mExternalAutoLayout;
            }
            if (customizableDevolveLayout == null) continue;
            customizableDevolveLayout.setIsAdjustingForOverlapOnly(bl);
            customizableDevolveLayout.setIsAnimating(bl2);
            customizableDevolveLayout.invokeLayout();
        }
        this.validate();
    }

    @Override
    protected Widget attachRegionWidget(CasaComponent casaComponent) {
        CasaRegionWidget casaRegionWidget = null;
        String string = ((CasaRegion)casaComponent).getName();
        if (CasaRegion.Name.WSDL_ENDPOINTS.getName().equals(string)) {
            this.mBindingRegion = casaRegionWidget = CasaRegionWidget.createBindingRegion((Scene)this);
            this.mBindingAutoLayout = new CustomizableDevolveLayout((Widget)this.mBindingRegion, new LayoutBindings());
        } else if (CasaRegion.Name.JBI_MODULES.getName().equals(string)) {
            this.mEngineRegion = casaRegionWidget = CasaRegionWidget.createEngineRegion((Scene)this);
            this.mEngineAutoLayout = new CustomizableDevolveLayout((Widget)this.mEngineRegion, new LayoutEngines());
        } else if (CasaRegion.Name.EXTERNAL_MODULES.getName().equals(string)) {
            this.mExternalRegion = casaRegionWidget = CasaRegionWidget.createExternalRegion((Scene)this);
            this.mExternalAutoLayout = new CustomizableDevolveLayout((Widget)this.mExternalRegion, new LayoutEngines());
        }
        if (casaRegionWidget != null) {
            this.mMainLayer.addChild((Widget)casaRegionWidget);
            casaRegionWidget.bringToBack();
        }
        return casaRegionWidget;
    }

    @Override
    protected Widget attachNodeWidget(CasaComponent casaComponent) {
        CasaNodeWidget casaNodeWidget = null;
        WidgetAction widgetAction = null;
        if (casaComponent instanceof CasaPort) {
            CasaPort casaPort = (CasaPort)casaComponent;
            String string = this.mModel.getBindingType(casaPort);
            casaNodeWidget = new CasaNodeWidgetBinding((Scene)this, string);
            CasaModelGraphUtilities.updateNodeProperties(this.mModel, casaPort, casaNodeWidget);
            casaNodeWidget.setEditable(this.mModel.isEditable(casaPort));
            if (string.equalsIgnoreCase("SOAP")) {
                casaNodeWidget.setWSPolicyAttached(this.mModel.isEditable(casaPort));
            }
            casaNodeWidget.initializeGlassLayer(this.mGlassLayer);
            this.mBindingRegion.addChild(casaNodeWidget);
            widgetAction = this.mMoveActionBindingRegion;
            casaNodeWidget.getContainerWidget().getActions().addAction(this.createObjectHoverAction());
            casaNodeWidget.getActions().addAction((WidgetAction)new CasaBadgeEditAction(this));
        } else if (casaComponent instanceof CasaServiceEngineServiceUnit) {
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = (CasaServiceEngineServiceUnit)casaComponent;
            CasaRegionWidget casaRegionWidget = null;
            if (!casaServiceEngineServiceUnit.isInternal()) {
                casaNodeWidget = new CasaNodeWidgetEngineExternal((Scene)this);
                casaRegionWidget = this.mExternalRegion;
                widgetAction = this.mMoveActionExternalRegion;
            } else {
                casaNodeWidget = new CasaNodeWidgetEngineInternal((Scene)this);
                casaRegionWidget = this.mEngineRegion;
                widgetAction = this.mMoveActionEngineRegion;
            }
            CasaModelGraphUtilities.updateNodeProperties(this.mModel, casaServiceEngineServiceUnit, casaNodeWidget);
            casaRegionWidget.addChild(casaNodeWidget);
            casaNodeWidget.setEditable(this.mModel.isEditable(casaServiceEngineServiceUnit));
            ((CasaNodeWidgetEngine)casaNodeWidget).setConfigurationStatus(casaServiceEngineServiceUnit.isDefined());
            casaNodeWidget.initializeGlassLayer(this.mGlassLayer);
            casaNodeWidget.getContainerWidget().getActions().addAction(this.createObjectHoverAction());
        }
        casaNodeWidget.getActions().addAction(this.createSelectAction());
        casaNodeWidget.getActions().addAction(this.mPopupMenuAction);
        casaNodeWidget.getActions().addAction(widgetAction);
        return casaNodeWidget;
    }

    @Override
    protected Widget attachPinWidget(CasaComponent casaComponent, CasaComponent casaComponent2) {
        assert (casaComponent2 instanceof CasaConsumes || casaComponent2 instanceof CasaProvides);
        CasaPinWidget casaPinWidget = null;
        boolean bl = casaComponent2 instanceof CasaConsumes;
        boolean bl2 = casaComponent instanceof CasaPort;
        if (bl2 && bl) {
            casaPinWidget = new CasaPinWidgetBindingConsumes((Scene)this);
        } else if (bl2 && !bl) {
            casaPinWidget = new CasaPinWidgetBindingProvides((Scene)this);
        } else if (!bl2 && bl) {
            casaPinWidget = new CasaPinWidgetEngineConsumes((Scene)this);
        } else if (!bl2 && !bl) {
            casaPinWidget = new CasaPinWidgetEngineProvides((Scene)this);
        }
        ((CasaNodeWidget)this.findWidget(casaComponent)).attachPinWidget(casaPinWidget);
        if (!bl2) {
            casaPinWidget.getActions().addAction(this.mDoubleClickOpenAction);
        }
        casaPinWidget.getActions().addAction(this.createObjectHoverAction());
        casaPinWidget.getActions().addAction(this.createSelectAction());
        casaPinWidget.getActions().addAction(this.mPopupMenuAction);
        casaPinWidget.getActions().addAction((WidgetAction)new CasaConnectAction(this, (Widget)this.mConnectionLayer));
        return casaPinWidget;
    }

    @Override
    protected Widget attachProcessWidget(CasaComponent casaComponent, CasaComponent casaComponent2) {
        Image image = ServiceUnitProcessNode.getFileIconImage((CasaEndpoint)casaComponent2);
        CasaProcessTitleWidget casaProcessTitleWidget = new CasaProcessTitleWidget((Scene)this, ((CasaEndpoint)casaComponent2).getProcessName(), image);
        ((CasaNodeWidgetEngine)this.findWidget(casaComponent)).attachProcessWidget(casaProcessTitleWidget);
        casaProcessTitleWidget.getActions().addAction(this.mDoubleClickOpenAction);
        casaProcessTitleWidget.getActions().addAction(this.createSelectAction());
        casaProcessTitleWidget.getActions().addAction(this.mPopupMenuAction);
        return casaProcessTitleWidget;
    }

    @Override
    protected Widget attachEdgeWidget(CasaComponent casaComponent) {
        CasaConnectionWidget casaConnectionWidget = new CasaConnectionWidget((Scene)this);
        this.mConnectionLayer.addChild((Widget)casaConnectionWidget);
        casaConnectionWidget.getActions().addAction(this.createObjectHoverAction());
        casaConnectionWidget.getActions().addAction(this.createSelectAction());
        casaConnectionWidget.getActions().addAction(this.mPopupMenuAction);
        return casaConnectionWidget;
    }

    @Override
    protected void attachEdgeSourceAnchor(CasaComponent casaComponent, CasaComponent casaComponent2, CasaComponent casaComponent3) {
        ((ConnectionWidget)this.findWidget(casaComponent)).setSourceAnchor(this.getPinAnchor(casaComponent3));
    }

    @Override
    protected void attachEdgeTargetAnchor(CasaComponent casaComponent, CasaComponent casaComponent2, CasaComponent casaComponent3) {
        ((ConnectionWidget)this.findWidget(casaComponent)).setTargetAnchor(this.getPinAnchor(casaComponent3));
    }

    private Anchor getPinAnchor(CasaComponent casaComponent) {
        if (casaComponent == null) {
            return null;
        }
        CasaNodeWidget casaNodeWidget = (CasaNodeWidget)this.findWidget(this.getPinNode(casaComponent));
        return casaNodeWidget.getPinAnchor(this.findWidget(casaComponent));
    }

    @Override
    protected void detachRegionWidget(CasaComponent casaComponent, Widget widget) {
        super.detachRegionWidget(casaComponent, widget);
        this.fireSelectionChanged();
    }

    @Override
    protected void detachNodeWidget(CasaComponent casaComponent, Widget widget) {
        super.detachNodeWidget(casaComponent, widget);
        this.fireSelectionChanged();
    }

    @Override
    protected void detachEdgeWidget(CasaComponent casaComponent, Widget widget) {
        super.detachEdgeWidget(casaComponent, widget);
        this.fireSelectionChanged();
    }

    @Override
    protected void detachPinWidget(CasaComponent casaComponent, Widget widget) {
        super.detachPinWidget(casaComponent, widget);
        this.fireSelectionChanged();
    }

    protected TopComponent findTopComponent() {
        if (this.getView() != null) {
            return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, this.getView());
        }
        return null;
    }

    public void updateSelectionAndRequestFocus(CasaComponent ... casaComponentArray) {
        HashSet<CasaComponent> hashSet = new HashSet<CasaComponent>();
        for (CasaComponent casaComponent : casaComponentArray) {
            hashSet.add(casaComponent);
        }
        this.userSelectionSuggested(hashSet, false);
        this.transferFocusToGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferFocusToGraph() {
        try {
            this.mIsInternalNodeChange = true;
            Mode mode = WindowManager.getDefault().findMode("editor");
            for (TopComponent topComponent : mode.getTopComponents()) {
                DataObject dataObject = (DataObject)topComponent.getLookup().lookup(DataObject.class);
                if (dataObject != this.mDataObject) continue;
                topComponent.requestActive();
                break;
            }
            if (!this.getView().hasFocus()) {
                this.getView().requestFocusInWindow();
            }
        }
        finally {
            this.mIsInternalNodeChange = false;
        }
    }

    @Override
    protected void fireSelectionChanged() {
        if (this.getView() == null || this.mModelListener == null) {
            return;
        }
        final TopComponent topComponent = this.findTopComponent();
        if (topComponent == null) {
            return;
        }
        final Set set = this.getSelectedObjects();
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Node[] nodeArray;
                CasaNode casaNode = null;
                if (set.size() < 1) {
                    casaNode = CasaModelGraphScene.this.mNodeFactory.createModelNode(CasaModelGraphScene.this.mModel);
                } else {
                    nodeArray = (Node[])set.iterator().next();
                    casaNode = CasaModelGraphScene.this.mNodeFactory.createNodeFor((CasaComponent)nodeArray);
                    if (casaNode == null) {
                        casaNode = CasaModelGraphScene.this.mNodeFactory.createModelNode(CasaModelGraphScene.this.mModel);
                    }
                }
                if (casaNode != null) {
                    nodeArray = new Node[]{casaNode};
                    try {
                        CasaModelGraphScene.this.mIsInternalNodeChange = true;
                        topComponent.setActivatedNodes(nodeArray);
                    }
                    finally {
                        CasaModelGraphScene.this.mIsInternalNodeChange = false;
                    }
                }
            }
        });
    }

    @Override
    protected void refreshWidgetBadge(CasaComponent casaComponent, Widget widget) {
        if (widget instanceof CasaNodeWidgetBinding) {
            CasaNodeWidgetBinding casaNodeWidgetBinding = (CasaNodeWidgetBinding)widget;
            casaNodeWidgetBinding.setEditable(this.mModel.isEditable((CasaPort)casaComponent));
            casaNodeWidgetBinding.setWSPolicyAttached(this.mModel.isEditable((CasaPort)casaComponent));
        }
        this.updateSelectionAndRequestFocus(casaComponent);
        CasaModelGraphUtilities.ensureVisibity(widget);
    }

    public void cleanup() {
        TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        CasaFactory.getCasaCustomizerRegistor().removePropertyListerner(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.mIsInternalNodeChange || this.getView() == null) {
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (!string.equals("activated")) {
            if (string.equals("activatedNodes")) {
                if (this.getView().isShowing()) {
                    this.updateFromExternalNodeChange();
                }
            } else if (string.equals("Customizer_Property_Changed") && this.getView() != null) {
                CasaGraphMultiViewElement casaGraphMultiViewElement = (CasaGraphMultiViewElement)((Object)SwingUtilities.getAncestorOfClass(CasaGraphMultiViewElement.class, this.getView()));
                if (!this.getView().isShowing()) {
                    casaGraphMultiViewElement.scheduleLookAndFeelRender();
                } else {
                    CasaFactory.getCasaCustomizer().renderCasaDesignView(this);
                }
            }
        }
    }

    private void updateFromExternalNodeChange() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        ArrayList<CasaComponent> arrayList = new ArrayList<CasaComponent>();
        for (Object object : nodeArray) {
            Object object2;
            if (!(object instanceof CasaNode) || !((object2 = ((CasaNode)((Object)object)).getData()) instanceof CasaComponent)) continue;
            arrayList.add((CasaComponent)object2);
        }
        HashSet hashSet = new HashSet();
        for (CasaComponent casaComponent : arrayList) {
            if (!(casaComponent instanceof CasaEndpoint) && !(casaComponent instanceof CasaPort) && !(casaComponent instanceof CasaServiceEngineServiceUnit) && !(casaComponent instanceof CasaConsumes) && !(casaComponent instanceof CasaProvides) && !(casaComponent instanceof CasaConnection)) continue;
            hashSet.add(casaComponent);
        }
        HashSet hashSet2 = new HashSet();
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object object;
            object = (CasaComponent)iterator.next();
            if (this.getObjectState(object) == null) continue;
            hashSet2.add(object);
        }
        if (hashSet2.size() > 0) {
            this.setSelectedObjects(hashSet2);
            this.getView().repaint();
        }
    }

    public JComponent getViewComponent() {
        if (this.getView() == null) {
            this.createView();
            this.getView().addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if (!CasaModelGraphScene.this.getView().hasFocus()) {
                        CasaModelGraphScene.this.getView().requestFocusInWindow();
                    }
                }
            });
            this.getView().putClientProperty("print.printable", Boolean.TRUE);
        }
        return this.getView();
    }

    public CasaRegionWidget getBindingRegion() {
        return this.mBindingRegion;
    }

    public CasaRegionWidget getEngineRegion() {
        return this.mEngineRegion;
    }

    public CasaRegionWidget getExternalRegion() {
        return this.mExternalRegion;
    }

    public boolean isModified() {
        return this.mDataObject.isModified();
    }

    public boolean canEdit() {
        return !this.mDataObject.isBuilding();
    }

    public String getSourcesPath() {
        return FileUtil.toFile((FileObject)this.mDataObject.getFolder().getPrimaryFile().getParent()).getAbsolutePath();
    }

    public Comparable getIdentityCode(Object object) {
        if (object == null || object instanceof CasaRegion) {
            return null;
        }
        StringBuffer stringBuffer = null;
        if (object instanceof CasaPort) {
            stringBuffer = this.getIdentityCode((CasaPort)object);
        } else if (object instanceof CasaConnection) {
            stringBuffer = this.getIdentityCode((CasaConnection)object);
        } else if (object instanceof CasaServiceEngineServiceUnit) {
            stringBuffer = this.getIdentityCode((CasaServiceEngineServiceUnit)object);
        } else if (object instanceof CasaConsumes) {
            stringBuffer = this.getIdentityCode((CasaConsumes)object);
        } else if (object instanceof CasaProvides) {
            stringBuffer = this.getIdentityCode((CasaProvides)object);
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    private StringBuffer getIdentityCode(CasaPort casaPort) {
        StringBuffer stringBuffer = new StringBuffer("A");
        stringBuffer.append(String.format("%010d", casaPort.getX()));
        stringBuffer.append(String.format("%010d", casaPort.getY()));
        stringBuffer.append(String.format("%010d", casaPort.findPosition()));
        return stringBuffer;
    }

    private StringBuffer getIdentityCode(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        String string = casaServiceEngineServiceUnit.isInternal() ? "C" : "E";
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(String.format("%010d", casaServiceEngineServiceUnit.getY()));
        stringBuffer.append(String.format("%010d", casaServiceEngineServiceUnit.getX()));
        stringBuffer.append(String.format("%010d", casaServiceEngineServiceUnit.findPosition()));
        return stringBuffer;
    }

    private StringBuffer getIdentityCode(CasaConsumes casaConsumes) {
        StringBuffer stringBuffer = new StringBuffer("");
        CasaComponent casaComponent = (CasaComponent)casaConsumes.getParent();
        if (casaComponent instanceof CasaPort) {
            stringBuffer = this.getIdentityCode((CasaPort)casaComponent);
        } else if (casaComponent instanceof CasaServiceEngineServiceUnit) {
            if (this.isMinimizedSU((CasaServiceEngineServiceUnit)casaComponent)) {
                return null;
            }
            stringBuffer = this.getIdentityCode((CasaServiceEngineServiceUnit)casaComponent);
        }
        stringBuffer.append("C");
        stringBuffer.append(String.format("%010d", casaConsumes.findPosition()));
        return stringBuffer;
    }

    private StringBuffer getIdentityCode(CasaProvides casaProvides) {
        StringBuffer stringBuffer = new StringBuffer("");
        CasaComponent casaComponent = (CasaComponent)casaProvides.getParent();
        if (casaComponent instanceof CasaPort) {
            stringBuffer = this.getIdentityCode((CasaPort)casaComponent);
        } else if (casaComponent instanceof CasaServiceEngineServiceUnit) {
            if (this.isMinimizedSU((CasaServiceEngineServiceUnit)casaComponent)) {
                return null;
            }
            stringBuffer = this.getIdentityCode((CasaServiceEngineServiceUnit)casaComponent);
        }
        stringBuffer.append("P");
        stringBuffer.append(String.format("%010d", casaProvides.findPosition()));
        return stringBuffer;
    }

    private boolean isMinimizedSU(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        return ((CasaNodeWidgetEngine)this.findWidget(casaServiceEngineServiceUnit)).isMinimized();
    }

    private StringBuffer getIdentityCode(CasaConnection casaConnection) {
        StringBuffer stringBuffer = new StringBuffer("G");
        stringBuffer.append(String.format("%010d", casaConnection.findPosition()));
        return stringBuffer;
    }

    @Override
    public void validationUpdated(List<Validator.ResultItem> list) {
        Object object;
        CasaModelGraphScene.clearValidationErrors(this);
        this.mModel.clearCache();
        HashMap<ErrableWidget, ArrayList<String>> hashMap = new HashMap<ErrableWidget, ArrayList<String>>();
        HashSet<ErrableWidget> hashSet = new HashSet<ErrableWidget>();
        for (Validator.ResultItem object2 : list) {
            object = object2.getComponents();
            Set<Object> set = new HashSet<Component>();
            set.add(object);
            if (object instanceof WSDLComponent) {
                set = CasaModelGraphScene.getCasaComponents(this.mModel, (WSDLComponent)object);
            }
            boolean bl = object2.getType() == Validator.ResultType.ERROR;
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                Component component;
                Widget widget = this.findWidget(component);
                for (component = (Component)iterator.next(); widget == null && component != null; component = component.getParent()) {
                    widget = this.findWidget(component);
                }
                if (widget == null || !(widget instanceof ErrableWidget)) continue;
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(widget);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    hashMap.put((ErrableWidget)widget, arrayList);
                }
                arrayList.add(object2.getDescription());
                if (!bl) continue;
                hashSet.add((ErrableWidget)widget);
            }
        }
        for (ErrableWidget errableWidget : hashMap.keySet()) {
            object = CasaModelGraphScene.getErrorString((List)hashMap.get((Object)errableWidget));
            errableWidget.setError((String)object, hashSet.contains((Object)errableWidget));
        }
        this.validate();
    }

    private static String getErrorString(List<String> list) {
        String string = null;
        string = list.size() == 1 ? list.get(0) : CasaModelGraphScene.getHtmlList(list);
        return string;
    }

    private static String getHtmlList(List<String> list) {
        String string = "<HTML><BODY><UL>";
        for (String string2 : list) {
            string = string + "<LI>";
            string = string + string2;
            string = string + "</LI>";
        }
        string = string + "</UL></BODY></HTML>";
        return string;
    }

    private static Set<Component> getCasaComponents(CasaWrapperModel casaWrapperModel, WSDLComponent wSDLComponent) {
        assert (wSDLComponent != null);
        HashSet<Component> hashSet = new HashSet<Component>();
        WSDLModel wSDLModel = wSDLComponent.getModel();
        Definitions definitions = wSDLModel.getDefinitions();
        while (!(wSDLComponent instanceof Definitions)) {
            if (wSDLComponent instanceof Port) {
                CasaPort casaPort = CasaModelGraphScene.getCasaPort(casaWrapperModel, (Port)wSDLComponent);
                if (casaPort == null) break;
                hashSet.add((Component)casaPort);
                break;
            }
            if (wSDLComponent instanceof Binding) {
                for (Service service : definitions.getServices()) {
                    for (Port port : service.getPorts()) {
                        CasaPort casaPort;
                        Binding binding;
                        if (port.getBinding() == null || (binding = (Binding)port.getBinding().get()) != wSDLComponent || (casaPort = CasaModelGraphScene.getCasaPort(casaWrapperModel, port)) == null) continue;
                        hashSet.add((Component)casaPort);
                    }
                }
                break;
            }
            if (wSDLComponent instanceof PortType) {
                for (Service service : definitions.getServices()) {
                    for (Port port : service.getPorts()) {
                        CasaPort casaPort;
                        PortType portType;
                        Binding binding;
                        if (port.getBinding() == null || (binding = (Binding)port.getBinding().get()).getType() == null || (portType = (PortType)binding.getType().get()) != wSDLComponent || (casaPort = CasaModelGraphScene.getCasaPort(casaWrapperModel, port)) == null) continue;
                        hashSet.add((Component)casaPort);
                    }
                }
                break;
            }
            wSDLComponent = (WSDLComponent)wSDLComponent.getParent();
        }
        return hashSet;
    }

    private static CasaPort getCasaPort(CasaWrapperModel casaWrapperModel, Port port) {
        CasaPort casaPort = null;
        WSDLModel wSDLModel = port.getModel();
        FileObject fileObject = (FileObject)wSDLModel.getModelSource().getLookup().lookup(FileObject.class);
        String string = fileObject.getNameExt();
        String string2 = port.getName();
        String string3 = ((Service)port.getParent()).getName();
        for (CasaPort casaPort2 : casaWrapperModel.getCasaPorts()) {
            String string4 = casaPort2.getLink().getHref();
            if (!string4.contains("/" + string + "#xpointer(/definitions/service[@name='" + string3 + "']/port[@name='" + string2 + "'])")) continue;
            casaPort = casaPort2;
            break;
        }
        return casaPort;
    }

    private static void clearValidationErrors(CasaModelGraphScene casaModelGraphScene) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(casaModelGraphScene.getNodes());
        arrayList.addAll(casaModelGraphScene.getPins());
        for (CasaComponent casaComponent : arrayList) {
            Widget widget = casaModelGraphScene.findWidget(casaComponent);
            if (widget == null || !(widget instanceof ErrableWidget)) continue;
            ((ErrableWidget)widget).setError(null, false);
        }
    }
}

