/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.design;

import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.openide.util.NbBundle;

public class ZoomControl
extends AbstractAction
implements ChangeListener,
FocusListener {
    private static final int DEF_ZOOM = 100;
    private static final int MIN_ZOOM = 33;
    private static final int MAX_ZOOM = 200;
    private static final int HGAP = 1;
    private static final Icon FIT_DIAGRAM_ICON = ZoomControl.loadIcon("fit_diagram.png");
    private static final Icon FIT_WIDTH_ICON = ZoomControl.loadIcon("fit_width.png");
    private static final Icon NORMAL_SIZE_ICON = ZoomControl.loadIcon("normal_size.png");
    private CasaModelGraphScene mScene;
    private JButton fitDiagram;
    private JButton fitWidth;
    private JButton oneToOne;
    private JTextField zoomValue;
    private JSlider zoomSlider;

    public ZoomControl(CasaModelGraphScene casaModelGraphScene) {
        this.mScene = casaModelGraphScene;
        this.fitDiagram = new JButton(FIT_DIAGRAM_ICON);
        this.fitDiagram.setToolTipText(this.getMessage("LBL_ZoomPanel_FitDiagram"));
        this.fitDiagram.addActionListener(this);
        this.fitDiagram.setFocusable(false);
        this.fitWidth = new JButton(FIT_WIDTH_ICON);
        this.fitWidth.setToolTipText(this.getMessage("LBL_ZoomPanel_FitWidth"));
        this.fitWidth.addActionListener(this);
        this.fitWidth.setFocusable(false);
        this.oneToOne = new JButton(NORMAL_SIZE_ICON);
        this.oneToOne.setToolTipText(this.getMessage("LBL_ZoomPanel_OneToOne"));
        this.oneToOne.addActionListener(this);
        this.oneToOne.setFocusable(false);
        this.zoomValue = new JTextField("" + this.getZoom() + "%", 4);
        this.zoomValue.setToolTipText(this.getMessage("LBL_ZoomPanel_ZoomValue"));
        this.zoomValue.addFocusListener(this);
        this.zoomValue.addActionListener(this);
        this.zoomSlider = new JSlider(33, 200, this.getZoom());
        this.zoomSlider.addChangeListener(this);
        this.zoomSlider.setOpaque(false);
        this.zoomSlider.setBackground(null);
        this.zoomSlider.setFocusable(false);
    }

    public int getComponetsCount() {
        return 5;
    }

    public JComponent getComponent(int n) {
        switch (n) {
            case 0: {
                return this.fitDiagram;
            }
            case 1: {
                return this.fitWidth;
            }
            case 2: {
                return this.oneToOne;
            }
            case 3: {
                return this.zoomValue;
            }
            case 4: {
                return this.zoomSlider;
            }
        }
        return null;
    }

    public void setEnabled(boolean bl) {
        this.fitDiagram.setVisible(bl);
        this.fitWidth.setVisible(bl);
        this.oneToOne.setVisible(bl);
        this.zoomValue.setVisible(bl);
        this.zoomSlider.setVisible(bl);
    }

    private void updateView() {
        if (this.zoomValue.hasFocus()) {
            this.zoomValue.setText("" + this.getZoom());
        } else {
            this.zoomValue.setText("" + this.getZoom() + "%");
        }
        this.zoomSlider.setValue(this.getZoom());
        this.mScene.validate();
    }

    private int getZoom() {
        return (int)Math.round(this.mScene.getZoomFactor() * 100.0);
    }

    private void setZoom(int n) {
        this.zoomSlider.removeChangeListener(this);
        n = Math.max(33, Math.min(n, 200));
        this.mScene.setZoomFactor((float)n / 100.0f);
        this.updateView();
        this.zoomSlider.addChangeListener(this);
    }

    private void fitDiagram() {
    }

    public void fitWidth() {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.fitDiagram) {
            this.fitDiagram();
        } else if (actionEvent.getSource() == this.fitWidth) {
            this.fitWidth();
        } else if (actionEvent.getSource() == this.oneToOne) {
            this.setZoom(100);
        } else if (actionEvent.getSource() == this.zoomValue) {
            try {
                int n = Integer.parseInt(this.zoomValue.getText());
                this.setZoom(n);
            }
            catch (NumberFormatException numberFormatException) {
                this.updateView();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.setZoom(this.zoomSlider.getValue());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.zoomValue.setText("" + this.getZoom());
        this.zoomValue.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.updateView();
    }

    private String getMessage(String string) {
        return NbBundle.getBundle(ZoomControl.class).getString(string);
    }

    private static Icon loadIcon(String string) {
        return new ImageIcon(ZoomControl.class.getResource("resources/" + string));
    }
}

