/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.RescaleOp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.anchor.AnchorFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.ErrableWidget;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CasaPinWidget
extends ErrableWidget {
    protected ImageWidget mImageWidget;
    private static final float HIGHLIGHT_LIGHT_FACTOR = 0.6f;
    private boolean mIsHighlighted;
    private Image mUnHighlightedImage;
    private GrayFilter mPinGrayFilter = new GrayFilter(true, 20);
    private Image mPinImage;
    private Image mClassicPinImage;

    public CasaPinWidget(Scene scene, Image image, Image image2) {
        super(scene);
        this.mPinImage = image;
        this.mClassicPinImage = image2;
        this.mImageWidget = new ImageWidget(scene);
        this.mImageWidget.setImage(this.getPinImage());
        this.setOpaque(false);
        this.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)0));
        this.notifyStateChanged(ObjectState.createNormal(), ObjectState.createNormal());
    }

    public void updatePinImage() {
        this.mImageWidget.setImage(this.getPinImage());
    }

    protected Image getPinImage() {
        return CasaFactory.getCasaCustomizer().getBOOLEAN_CLASSIC_ENDPOINT_PIN_STYLE() != false ? this.mClassicPinImage : this.mPinImage;
    }

    @Override
    protected boolean hasPreferredLocation() {
        return false;
    }

    @Override
    protected int getErrorBadgeDeltaX() {
        return this.getBounds().width + 2;
    }

    @Override
    protected int getErrorBadgeDeltaY() {
        return 2;
    }

    protected abstract void setPinName(String var1);

    protected void setSelected(boolean bl) {
        Image image = this.getPinImage();
        if (bl) {
            this.mImageWidget.setImage(this.createSelectedPinImage(image));
        } else {
            this.mImageWidget.setImage(image);
        }
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        super.notifyStateChanged(objectState, objectState2);
        if (!objectState.isSelected() && objectState2.isSelected() || !objectState.isFocused() && objectState2.isFocused()) {
            this.setSelected(true);
        } else if (objectState.isSelected() && !objectState2.isSelected() || objectState.isFocused() && !objectState2.isFocused()) {
            this.setSelected(false);
        }
        if (!objectState.isHovered() && objectState2.isHovered()) {
            this.hoverConnections();
        } else if (objectState.isHovered() && !objectState2.isHovered()) {
            CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)this.getScene();
            casaModelGraphScene.setHighlightedObjects(Collections.emptySet());
        }
    }

    public Set<CasaComponent> getConnections() {
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)this.getScene();
        CasaEndpointRef casaEndpointRef = (CasaEndpointRef)casaModelGraphScene.findObject(this);
        Collection collection = casaModelGraphScene.getEdges();
        HashSet<CasaComponent> hashSet = new HashSet<CasaComponent>();
        for (CasaComponent casaComponent : collection) {
            CasaComponent casaComponent2 = (CasaComponent)casaModelGraphScene.getEdgeSource(casaComponent);
            CasaComponent casaComponent3 = (CasaComponent)casaModelGraphScene.getEdgeTarget(casaComponent);
            if (casaComponent2 != casaEndpointRef && casaComponent3 != casaEndpointRef) continue;
            hashSet.add(casaComponent);
        }
        return hashSet;
    }

    private void hoverConnections() {
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)this.getScene();
        Set<CasaComponent> set = this.getConnections();
        casaModelGraphScene.setHighlightedObjects(set);
    }

    public void setProperties(String string) {
        this.setPinName(string);
    }

    public Anchor getAnchor() {
        return AnchorFactory.createDirectionalAnchor((Widget)this, (AnchorFactory.DirectionalAnchorKind)AnchorFactory.DirectionalAnchorKind.HORIZONTAL, (int)0);
    }

    protected Image createSelectedPinImage(Image image) {
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), this.mPinGrayFilter);
        Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        return image2;
    }

    public void setHighlighted(boolean bl) {
        if (this.mIsHighlighted != bl) {
            this.mIsHighlighted = bl;
            if (bl) {
                this.mUnHighlightedImage = this.mImageWidget.getImage();
                if (this.mUnHighlightedImage != null) {
                    this.mImageWidget.setImage(this.createHighlightedImage(this.mUnHighlightedImage));
                }
            } else if (this.mUnHighlightedImage != null) {
                this.mImageWidget.setImage(this.mUnHighlightedImage);
            }
        }
    }

    private Image createHighlightedImage(Image image) {
        RescaleOp rescaleOp = new RescaleOp(0.6f, 0.0f, null);
        BufferedImage bufferedImage = CasaPinWidget.toBufferedImage(image);
        return rescaleOp.filter(bufferedImage, bufferedImage);
    }

    private static final BufferedImage toBufferedImage(Image image) {
        new ImageIcon(image);
        BufferedImage bufferedImage = CasaPinWidget.createBufferedImage(image.getWidth(null), image.getHeight(null));
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        image.flush();
        return bufferedImage;
    }

    private static final BufferedImage createBufferedImage(int n, int n2) {
        if (Utilities.getOperatingSystem() == 4096) {
            return new BufferedImage(n, n2, 3);
        }
        ColorModel colorModel = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(3);
        BufferedImage bufferedImage = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n, n2), colorModel.isAlphaPremultiplied(), null);
        return bufferedImage;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AnchorScheme {
        HORIZONTAL,
        LEFT,
        RIGHT,
        VERTICAL,
        TOP,
        BOTTOM;

    }
}

