/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.Point;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.DependenciesRegistry;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;

public abstract class ErrableWidget
extends Widget {
    private DependenciesRegistry mDependenciesRegistry = new DependenciesRegistry(this);
    private Widget mErrorBadgeWidget;

    public ErrableWidget(Scene scene) {
        super(scene);
    }

    public void setError(String string, boolean bl) {
        if (this.mErrorBadgeWidget == null) {
            if (string == null) {
                return;
            }
            this.mErrorBadgeWidget = new ImageWidget(this.getScene(), bl ? RegionUtilities.IMAGE_ERROR_BADGE_ICON : RegionUtilities.IMAGE_WARNING_BADGE_ICON);
        }
        this.mErrorBadgeWidget.setToolTipText(string);
        LayerWidget layerWidget = ((CasaModelGraphScene)this.getScene()).getGlassLayer();
        if (string == null) {
            this.mErrorBadgeWidget.removeFromParent();
            layerWidget.repaint();
        } else if (!layerWidget.getChildren().contains(this.mErrorBadgeWidget)) {
            layerWidget.addChild(this.mErrorBadgeWidget);
            this.revalidate();
        }
    }

    protected void notifyAdded() {
        super.notifyAdded();
        Widget.Dependency dependency = new Widget.Dependency(){

            public void revalidateDependency() {
                if (ErrableWidget.this.hasPreferredLocation() && ErrableWidget.this.getPreferredLocation() == null || ErrableWidget.this.getBounds() == null || ErrableWidget.this.getParentWidget() == null) {
                    return;
                }
                if (ErrableWidget.this.mErrorBadgeWidget != null && ErrableWidget.this.mErrorBadgeWidget.getToolTipText() != null) {
                    Point point = ErrableWidget.this.getParentWidget().convertLocalToScene(ErrableWidget.this.hasPreferredLocation() ? ErrableWidget.this.getPreferredLocation() : new Point(0, 0));
                    int n = point.x + ErrableWidget.this.getErrorBadgeDeltaX();
                    int n2 = point.y + ErrableWidget.this.getErrorBadgeDeltaY();
                    ErrableWidget.this.mErrorBadgeWidget.setPreferredLocation(new Point(n, n2));
                }
            }
        };
        this.getDependenciesRegistry().registerDependency(dependency);
    }

    protected void notifyRemoved() {
        super.notifyRemoved();
        this.getDependenciesRegistry().removeAllDependencies();
        if (this.mErrorBadgeWidget != null) {
            this.mErrorBadgeWidget.removeFromParent();
        }
    }

    public void initializeGlassLayer(LayerWidget layerWidget) {
    }

    protected DependenciesRegistry getDependenciesRegistry() {
        return this.mDependenciesRegistry;
    }

    protected abstract boolean hasPreferredLocation();

    protected abstract int getErrorBadgeDeltaX();

    protected abstract int getErrorBadgeDeltaY();
}

