/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.modules.compapp.casaeditor.graph.GradientRectangleColorScheme;

public class GradientRectangleDrawer {
    private static final int ARC_WIDTH = 4;
    private static final int ARC_HEIGHT = 4;
    private static final int BORDER_PERIMETER_WIDTH = 2;

    public static void paintGradientBackground(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2, GradientRectangleColorScheme gradientRectangleColorScheme, boolean bl3, CustomPainter customPainter) {
        Shape shape = graphics2D.getClip();
        if (bl2) {
            graphics2D.clip(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 4.0f, 4.0f));
        } else {
            graphics2D.clip(new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        }
        int n = rectangle.y;
        int n2 = 0;
        int n3 = bl ? rectangle.height : rectangle.width;
        n2 = (int)((float)n3 * 0.3f);
        n = GradientRectangleDrawer.drawGradient(graphics2D, rectangle, gradientRectangleColorScheme.getColor1(), gradientRectangleColorScheme.getColor2(), n, n2, bl);
        n2 = (int)((float)n3 * 0.464f);
        n = GradientRectangleDrawer.drawGradient(graphics2D, rectangle, gradientRectangleColorScheme.getColor2(), gradientRectangleColorScheme.getColor3(), n, n2, bl);
        n2 = (int)((float)n3 * 0.163f);
        n = GradientRectangleDrawer.drawGradient(graphics2D, rectangle, gradientRectangleColorScheme.getColor3(), gradientRectangleColorScheme.getColor4(), n, n2, bl);
        n2 = n3 - n;
        n = GradientRectangleDrawer.drawGradient(graphics2D, rectangle, gradientRectangleColorScheme.getColor4(), gradientRectangleColorScheme.getColor5(), n, n2, bl);
        if (bl3) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(gradientRectangleColorScheme.getBorderColor());
            if (bl2) {
                graphics2D.draw(new RoundRectangle2D.Float((float)rectangle.x + 0.5f, (float)rectangle.y + 0.5f, rectangle.width - 1, rectangle.height - 1, 4.0f, 4.0f));
            } else {
                graphics2D.draw(new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
            }
            graphics2D.setStroke(stroke);
        }
        if (customPainter != null) {
            customPainter.paint(graphics2D);
        }
        graphics2D.setClip(shape);
    }

    private static int drawGradient(Graphics2D graphics2D, Rectangle rectangle, Color color, Color color2, int n, int n2, boolean bl) {
        if (bl) {
            graphics2D.setPaint(new GradientPaint(rectangle.x, n, color, rectangle.x, n + n2, color2));
            graphics2D.fill(new Rectangle(rectangle.x, n, rectangle.x + rectangle.width, n + n2));
        } else {
            graphics2D.setPaint(new GradientPaint(n, rectangle.y, color, n + n2, rectangle.y, color2));
            graphics2D.fill(new Rectangle(n, rectangle.y, n + n2, rectangle.y + rectangle.height));
        }
        return n + n2;
    }

    static abstract class CustomPainter {
        CustomPainter() {
        }

        public abstract void paint(Graphics var1);
    }
}

