/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.api.CasaPaletteItemID;
import org.netbeans.modules.compapp.casaeditor.api.CasaPalettePlugin;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphUtilities;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidgetEngineExternal;
import org.netbeans.modules.compapp.casaeditor.graph.CasaRegionWidget;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.model.casa.JBIServiceUnitTransferObject;
import org.netbeans.modules.compapp.casaeditor.palette.CasaCommonAcceptProvider;
import org.netbeans.modules.compapp.casaeditor.palette.CasaPalette;
import org.netbeans.modules.compapp.casaeditor.palette.DefaultPluginDropHandler;
import org.netbeans.modules.compapp.projects.jbi.api.InternalProjectTypePlugin;
import org.netbeans.modules.compapp.projects.jbi.api.JbiInstalledProjectPluginInfo;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.datatransfer.MultiTransferObject;

public class CasaPaletteAcceptProvider
extends CasaCommonAcceptProvider {
    private CasaWrapperModel mModel;
    private static final DataFlavor genericDataFlavor = new DataFlavor(Object.class, "whatever");

    public CasaPaletteAcceptProvider(CasaModelGraphScene casaModelGraphScene, CasaWrapperModel casaWrapperModel) {
        super(casaModelGraphScene);
        this.mModel = casaWrapperModel;
    }

    public ConnectorState isAcceptable(Widget widget, Point point, Transferable transferable) {
        ConnectorState connectorState = ConnectorState.REJECT;
        try {
            if (transferable.isDataFlavorSupported(CasaPalette.CasaPaletteDataFlavor)) {
                CasaPaletteItemID casaPaletteItemID = (CasaPaletteItemID)transferable.getTransferData(CasaPalette.CasaPaletteDataFlavor);
                if (casaPaletteItemID != null) {
                    connectorState = this.isAcceptableFromPalette(point, casaPaletteItemID);
                }
            } else {
                connectorState = this.isAcceptableFromOther(point, transferable, false);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            unsupportedFlavorException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return connectorState;
    }

    private ConnectorState isAcceptableFromPalette(Point point, CasaPaletteItemID casaPaletteItemID) {
        CasaRegionWidget casaRegionWidget = this.getApplicableRegion(casaPaletteItemID);
        ConnectorState connectorState = ConnectorState.REJECT;
        if (casaRegionWidget != null && casaRegionWidget.getBounds().contains(casaRegionWidget.convertSceneToLocal(point))) {
            connectorState = ConnectorState.ACCEPT;
        }
        return connectorState;
    }

    private InternalProjectTypePlugin getProjectPluginHandler(Object object) {
        JbiInstalledProjectPluginInfo jbiInstalledProjectPluginInfo = JbiInstalledProjectPluginInfo.getProjectPluginInfo();
        if (jbiInstalledProjectPluginInfo != null) {
            List list = jbiInstalledProjectPluginInfo.getUncategorizedProjectPluginList();
            for (InternalProjectTypePlugin internalProjectTypePlugin : list) {
                if (!internalProjectTypePlugin.isAcceptableProjectSource(object)) continue;
                return internalProjectTypePlugin;
            }
        }
        return null;
    }

    private ConnectorState isAcceptableFromOther(Point point, Transferable transferable, boolean bl) throws Exception {
        CasaRegionWidget casaRegionWidget = null;
        ConnectorState connectorState = ConnectorState.REJECT;
        for (Object e : this.getTransferableObjects(transferable)) {
            Object object;
            List list;
            connectorState = ConnectorState.REJECT;
            if (e instanceof Node) {
                casaRegionWidget = this.getScene().getEngineRegion();
                list = (Project)((Node)e).getLookup().lookup(Project.class);
                if (list != null) {
                    if (this.mModel.getJbiProjectType((Project)list) != null && !this.mModel.existingServiceEngineServiceUnit((String)(object = list.getProjectDirectory().getName()))) {
                        connectorState = ConnectorState.ACCEPT;
                    }
                } else {
                    String string;
                    object = this.getProjectPluginHandler(e);
                    if (object != null && !this.mModel.existingServiceEngineServiceUnit(string = ((Node)e).getDisplayName())) {
                        connectorState = ConnectorState.ACCEPT;
                    }
                }
            } else if (e instanceof List) {
                list = (List)e;
                if (list.size() == 5 && list.get(0) instanceof String && list.get(0).equals("JBIMGR_SU_TRANSFER")) {
                    casaRegionWidget = this.getScene().getExternalRegion();
                    object = (String)list.get(1);
                    if (!this.mModel.existingServiceEngineServiceUnit((String)object)) {
                        connectorState = ConnectorState.ACCEPT;
                    }
                }
            } else {
                connectorState = ConnectorState.REJECT;
            }
            if (connectorState != ConnectorState.REJECT) continue;
            break;
        }
        if (connectorState == ConnectorState.ACCEPT && casaRegionWidget != null) {
            if (bl) {
                this.highlightRegion(casaRegionWidget);
            } else if (!casaRegionWidget.getBounds().contains(casaRegionWidget.convertSceneToLocal(point))) {
                connectorState = ConnectorState.REJECT;
            }
        }
        return connectorState;
    }

    private List getTransferableObjects(Transferable transferable) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        if (dataFlavorArray.length > 0) {
            try {
                if (dataFlavorArray[0].getRepresentationClass().equals(MultiTransferObject.class)) {
                    DataFlavor[] dataFlavorArray2;
                    MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(dataFlavorArray[0]);
                    if (multiTransferObject.getCount() > 0 && (dataFlavorArray2 = multiTransferObject.getTransferDataFlavors(0)).length > 0) {
                        for (int i = 0; i < multiTransferObject.getCount(); ++i) {
                            if (transferable.isDataFlavorSupported(genericDataFlavor)) {
                                arrayList.add(multiTransferObject.getTransferData(i, genericDataFlavor));
                                continue;
                            }
                            arrayList.add(multiTransferObject.getTransferData(i, dataFlavorArray2[0]));
                        }
                    }
                } else if (transferable.isDataFlavorSupported(genericDataFlavor)) {
                    arrayList.add(transferable.getTransferData(genericDataFlavor));
                } else {
                    arrayList.add(transferable.getTransferData(dataFlavorArray[0]));
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    public void accept(Widget widget, Point point, Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(CasaPalette.CasaPaletteDataFlavor)) {
                CasaPaletteItemID casaPaletteItemID = (CasaPaletteItemID)transferable.getTransferData(CasaPalette.CasaPaletteDataFlavor);
                if (casaPaletteItemID != null) {
                    this.acceptFromPalette(point, casaPaletteItemID);
                }
            } else {
                this.acceptFromOther(point, transferable);
            }
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
    }

    private void acceptFromPalette(Point point, CasaPaletteItemID casaPaletteItemID) {
        DefaultPluginDropHandler defaultPluginDropHandler = new DefaultPluginDropHandler(this.getScene(), point);
        try {
            casaPaletteItemID.getPlugin().handleDrop(defaultPluginDropHandler, casaPaletteItemID);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private void acceptFromOther(Point point, Transferable transferable) throws Exception {
        for (Object e : this.getTransferableObjects(transferable)) {
            String string;
            String string2;
            Object object;
            List list;
            if (e instanceof Node) {
                list = (Project)((Node)e).getLookup().lookup(Project.class);
                if (list != null) {
                    object = this.mModel.getJbiProjectType((Project)list);
                    point = this.getScene().getEngineRegion().convertSceneToLocal(point);
                    this.mModel.addJBIModule((Project)list, (String)object, point.x, point.y);
                    continue;
                }
                object = this.getProjectPluginHandler(e);
                if (object == null) continue;
                string2 = ((Node)e).getDisplayName();
                string = object.getJbiTargetName();
                point = this.getScene().getEngineRegion().convertSceneToLocal(point);
                this.mModel.addJBIModuleFromPlugin((InternalProjectTypePlugin)object, string2, string, point.x, point.y);
                continue;
            }
            if (!(e instanceof List) || (list = (List)e).size() != 5 || !(list.get(0) instanceof String) || !list.get(0).equals("JBIMGR_SU_TRANSFER")) continue;
            object = new JBIServiceUnitTransferObject((String)list.get(1), (String)list.get(2), (String)list.get(3), (String)list.get(4));
            point = this.getScene().getExternalRegion().convertSceneToLocal(point);
            string2 = ((JBIServiceUnitTransferObject)object).getServiceUnitName();
            string = ((JBIServiceUnitTransferObject)object).getServiceUnitDescription();
            String string3 = ((JBIServiceUnitTransferObject)object).getComponentName();
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = this.mModel.addServiceEngineServiceUnit(string2, string3, string, false, false, true, point.x, point.y);
            SwingUtilities.invokeLater(new Runnable((JBIServiceUnitTransferObject)object, casaServiceEngineServiceUnit){
                final /* synthetic */ JBIServiceUnitTransferObject val$suTransfer;
                final /* synthetic */ CasaServiceEngineServiceUnit val$seSU;
                {
                    this.val$suTransfer = jBIServiceUnitTransferObject;
                    this.val$seSU = casaServiceEngineServiceUnit;
                }

                public void run() {
                    CasaPaletteAcceptProvider.this.mModel.addExternalEndpoints(this.val$suTransfer, this.val$seSU);
                }
            });
        }
    }

    private Project getProjectFromDataObject(DataObject dataObject) throws Exception {
        if (dataObject == null) {
            return null;
        }
        ProjectManager projectManager = ProjectManager.getDefault();
        Project project = null;
        for (FileObject fileObject = dataObject.getPrimaryFile(); fileObject != null; fileObject = fileObject.getParent()) {
            if (!fileObject.isFolder() || fileObject == null || (project = projectManager.findProject(fileObject)) == null) continue;
            return project;
        }
        return project;
    }

    public void acceptStarted(Transferable transferable) {
        super.acceptStarted(transferable);
        if (transferable.isDataFlavorSupported(CasaPalette.CasaPaletteDataFlavor)) {
            CasaPaletteItemID casaPaletteItemID = this.getCasaPaletteItem(transferable);
            CasaRegionWidget casaRegionWidget = this.getApplicableRegion(casaPaletteItemID);
            if (casaRegionWidget == null) {
                if (casaPaletteItemID != null && casaPaletteItemID.getCategory().equals(CasaPalette.CATEGORY_ID_END_POINTS)) {
                    this.highlightExtSUs(true);
                }
            } else {
                this.highlightRegion(casaRegionWidget);
            }
        } else {
            try {
                this.isAcceptableFromOther(null, transferable, true);
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    public void acceptFinished() {
        super.acceptFinished();
        this.highlightExtSUs(false);
        this.getScene().getBindingRegion().setHighlighted(false);
        this.getScene().getEngineRegion().setHighlighted(false);
        this.getScene().getExternalRegion().setHighlighted(false);
    }

    private void highlightRegion(CasaRegionWidget casaRegionWidget) {
        casaRegionWidget.setHighlighted(true);
        CasaModelGraphUtilities.ensureVisibity((Widget)casaRegionWidget);
    }

    private void highlightExtSUs(boolean bl) {
        for (Widget widget : this.getScene().getExternalRegion().getChildren()) {
            if (!(widget instanceof CasaNodeWidgetEngineExternal)) continue;
            ((CasaNodeWidgetEngineExternal)widget).setHighlighted(bl);
        }
        if (bl) {
            CasaModelGraphUtilities.ensureVisibity((Widget)this.getScene().getExternalRegion());
        }
    }

    private CasaRegionWidget getApplicableRegion(CasaPaletteItemID casaPaletteItemID) {
        CasaPalettePlugin.REGION rEGION = casaPaletteItemID.getPlugin().getDropRegion(casaPaletteItemID);
        if (rEGION == null) {
            return null;
        }
        CasaRegionWidget casaRegionWidget = null;
        switch (rEGION) {
            case WSDL_ENDPOINTS: {
                casaRegionWidget = this.getScene().getBindingRegion();
                break;
            }
            case JBI_MODULES: {
                casaRegionWidget = this.getScene().getEngineRegion();
                break;
            }
            case EXTERNAL: {
                casaRegionWidget = this.getScene().getExternalRegion();
            }
        }
        return casaRegionWidget;
    }

    private CasaPaletteItemID getCasaPaletteItem(Transferable transferable) {
        CasaPaletteItemID casaPaletteItemID = null;
        if (transferable.isDataFlavorSupported(CasaPalette.CasaPaletteDataFlavor)) {
            try {
                casaPaletteItemID = (CasaPaletteItemID)transferable.getTransferData(CasaPalette.CasaPaletteDataFlavor);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return casaPaletteItemID;
    }
}

