/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.actions.CanvasNodeProxyContext;
import org.openide.awt.Actions;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;

public class CasaPopupMenuProvider
implements PopupMenuProvider {
    private Widget mWidget;
    private CasaModelGraphScene mScene;
    private CasaWrapperModel mModel;

    public JPopupMenu getPopupMenu(Widget widget, Point point) {
        this.mWidget = widget;
        this.mScene = (CasaModelGraphScene)widget.getScene();
        this.mModel = this.mScene.getModel();
        CasaNode casaNode = null;
        if (widget instanceof CasaModelGraphScene) {
            casaNode = this.mScene.getNodeFactory().createModelNode(this.mModel);
        } else {
            Object object = this.mScene.findObject(this.mWidget);
            if (object instanceof CasaComponent) {
                casaNode = this.mScene.getNodeFactory().createNodeFor((CasaComponent)object);
            }
        }
        boolean bl = false;
        JPopupMenu jPopupMenu = new JPopupMenu();
        if (casaNode instanceof CasaNode) {
            CasaNode casaNode2 = casaNode;
            Action[] actionArray = casaNode.getActions(true);
            Action action = null;
            for (Action action2 : actionArray) {
                Serializable serializable;
                Point point2 = widget.convertLocalToScene(point);
                if (!casaNode2.isValidSceneActionForLocation(action2, widget, point2)) continue;
                if (action2 instanceof AbstractAction) {
                    if (action2 instanceof Presenter.Popup) {
                        serializable = ((Presenter.Popup)action2).getPopupPresenter();
                        if (serializable instanceof JMenu) {
                            jPopupMenu.add((JMenu)serializable);
                        } else {
                            jPopupMenu.add((JMenuItem)serializable);
                        }
                    } else {
                        serializable = CanvasNodeActionProxy.createAction(action2, point2, point);
                        jPopupMenu.add((Action)((Object)serializable));
                    }
                    bl = true;
                    action = action2;
                    continue;
                }
                if (action2 instanceof NodeAction) {
                    serializable = new JMenuItem();
                    jPopupMenu.add((JMenuItem)serializable);
                    Actions.connect((JMenuItem)serializable, (Action)action2, (boolean)true);
                    bl = true;
                    action = action2;
                    continue;
                }
                if (action2 != null || action == null) continue;
                jPopupMenu.addSeparator();
                action = null;
            }
        }
        return bl ? jPopupMenu : null;
    }

    private static class CanvasNodeActionProxy
    extends AbstractAction
    implements CanvasNodeProxyContext {
        private Action mActionable;
        private Point mLocalLocation;
        private Point mSceneLocation;

        private CanvasNodeActionProxy(Action action, Point point, Point point2) {
            super((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon"));
            this.mActionable = action;
            this.mSceneLocation = point;
            this.mLocalLocation = point2;
        }

        public static CanvasNodeActionProxy createAction(Action action, Point point, Point point2) {
            return new CanvasNodeActionProxy(action, point, point2);
        }

        public Point getLocalLocation() {
            return this.mLocalLocation;
        }

        public Point getSceneLocation() {
            return this.mSceneLocation;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            actionEvent.setSource(this);
            this.mActionable.actionPerformed(actionEvent);
        }
    }
}

