/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaPinWidget;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;

public class ConnectionHintManager {
    private static final ConnectionHintManager sharedInstance = new ConnectionHintManager();
    private Timer enterTimer = new Timer(750, new insideTimerAction());
    private Timer exitTimer;
    private Timer insideTimer;
    private String toolTipText;
    private boolean showImmediately;
    private transient Popup tipWindow;
    private JToolTip tip;
    private Rectangle popupRect = null;
    private boolean enabled = true;
    private boolean tipShowing = false;
    private CasaPinWidget mSourceWidget;
    private CasaPinWidget mTargetWidget;

    ConnectionHintManager() {
        this.enterTimer.setRepeats(false);
        this.exitTimer = new Timer(500, new outsideTimerAction());
        this.exitTimer.setRepeats(false);
        this.insideTimer = new Timer(4000, new stillInsideTimerAction());
        this.insideTimer.setRepeats(false);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.hideTipWindow();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setInitialDelay(int n) {
        this.enterTimer.setInitialDelay(n);
    }

    public int getInitialDelay() {
        return this.enterTimer.getInitialDelay();
    }

    public void setDismissDelay(int n) {
        this.insideTimer.setInitialDelay(n);
    }

    public int getDismissDelay() {
        return this.insideTimer.getInitialDelay();
    }

    public void setReshowDelay(int n) {
        this.exitTimer.setInitialDelay(n);
    }

    public int getReshowDelay() {
        return this.exitTimer.getInitialDelay();
    }

    void showTipWindow() {
        if (this.mTargetWidget == null || !this.mTargetWidget.isVisible()) {
            return;
        }
        if (this.enabled) {
            JComponent jComponent = this.mTargetWidget.getScene().getView();
            Point point = jComponent.getLocationOnScreen();
            Point point2 = this.mTargetWidget.getParentWidget().convertLocalToScene(this.mTargetWidget.getLocation());
            point2.x += point.x;
            point2.y += point.y;
            Point point3 = new Point();
            Rectangle rectangle = jComponent.getGraphicsConfiguration().getBounds();
            this.hideTipWindow();
            this.tip = new JToolTip();
            this.tip.setComponent(this.mTargetWidget.getScene().getView());
            this.tip.setTipText(this.toolTipText);
            Dimension dimension = this.tip.getPreferredSize();
            point3.x = point2.x;
            point3.y = point2.y;
            if (this.popupRect == null) {
                this.popupRect = new Rectangle();
            }
            this.popupRect.setBounds(point3.x, point3.y, dimension.width, dimension.height);
            if (point3.x < rectangle.x) {
                point3.x = rectangle.x;
            } else if (point3.x - rectangle.x + dimension.width > rectangle.width) {
                point3.x = rectangle.x + Math.max(0, rectangle.width - dimension.width);
            }
            if (point3.y < rectangle.y) {
                point3.y = rectangle.y;
            } else if (point3.y - rectangle.y + dimension.height > rectangle.height) {
                point3.y = rectangle.y + Math.max(0, rectangle.height - dimension.height);
            }
            PopupFactory popupFactory = PopupFactory.getSharedInstance();
            this.tipWindow = popupFactory.getPopup(this.mTargetWidget.getScene().getView(), this.tip, point3.x, point3.y);
            this.tipWindow.show();
            this.insideTimer.start();
            this.tipShowing = true;
        }
    }

    void hideTipWindow() {
        if (this.tipWindow != null) {
            this.tipWindow.hide();
            this.tipWindow = null;
            this.tipShowing = false;
            this.tip.getUI().uninstallUI(this.tip);
            this.tip = null;
            this.insideTimer.stop();
        }
    }

    public static ConnectionHintManager sharedInstance() {
        return sharedInstance;
    }

    public void widgetEntered(CasaPinWidget casaPinWidget, CasaPinWidget casaPinWidget2) {
        this.initiateToolTip(casaPinWidget, casaPinWidget2);
    }

    private void initiateToolTip(CasaPinWidget casaPinWidget, CasaPinWidget casaPinWidget2) {
        this.exitTimer.stop();
        if (this.mTargetWidget != null) {
            this.enterTimer.stop();
        }
        boolean bl = this.mTargetWidget == casaPinWidget2;
        this.mSourceWidget = casaPinWidget;
        this.mTargetWidget = casaPinWidget2;
        if (this.tipWindow != null) {
            if (this.showImmediately) {
                String string = this.getHint();
                if (!bl || !this.toolTipText.equals(string)) {
                    this.toolTipText = string;
                    this.showTipWindow();
                }
            } else {
                this.enterTimer.start();
            }
        }
    }

    public void widgetExited() {
        this.cleanup();
        this.exitTimer.restart();
    }

    public void cleanup() {
        this.enterTimer.stop();
        this.mSourceWidget = null;
        this.mTargetWidget = null;
        this.toolTipText = null;
        this.hideTipWindow();
        this.exitTimer.stop();
        this.showImmediately = false;
    }

    public void widgetMovedOver(CasaPinWidget casaPinWidget, CasaPinWidget casaPinWidget2) {
        if (this.tipShowing) {
            this.checkForTipChange(casaPinWidget2);
        } else if (this.showImmediately) {
            this.toolTipText = this.getHint();
            if (this.toolTipText != null) {
                this.mSourceWidget = casaPinWidget;
                this.mTargetWidget = casaPinWidget2;
                this.exitTimer.stop();
                this.showTipWindow();
            }
        } else {
            this.mSourceWidget = casaPinWidget;
            this.mTargetWidget = casaPinWidget2;
            this.toolTipText = null;
            this.enterTimer.restart();
        }
    }

    private void checkForTipChange(Widget widget) {
        String string = this.getHint();
        if (string != null) {
            if (string.equals(this.toolTipText)) {
                if (this.tipWindow != null) {
                    this.insideTimer.restart();
                } else {
                    this.enterTimer.restart();
                }
            } else {
                this.toolTipText = string;
                if (this.showImmediately) {
                    this.hideTipWindow();
                    this.showTipWindow();
                    this.exitTimer.stop();
                } else {
                    this.enterTimer.restart();
                }
            }
        } else {
            this.toolTipText = null;
            this.mSourceWidget = null;
            this.mTargetWidget = null;
            this.hideTipWindow();
            this.enterTimer.stop();
            this.exitTimer.restart();
        }
    }

    private String getHint() {
        if (this.mSourceWidget != null && this.mTargetWidget != null) {
            CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)this.mSourceWidget.getScene();
            CasaEndpointRef casaEndpointRef = (CasaEndpointRef)casaModelGraphScene.findObject(this.mSourceWidget);
            CasaEndpointRef casaEndpointRef2 = (CasaEndpointRef)casaModelGraphScene.findObject(this.mTargetWidget);
            return casaModelGraphScene.getModel().getUnConnectableReason(casaEndpointRef, casaEndpointRef2);
        }
        return null;
    }

    protected class stillInsideTimerAction
    implements ActionListener {
        protected stillInsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionHintManager.this.hideTipWindow();
            ConnectionHintManager.this.enterTimer.stop();
            ConnectionHintManager.this.showImmediately = false;
            ConnectionHintManager.this.mSourceWidget = null;
            ConnectionHintManager.this.mTargetWidget = null;
        }
    }

    protected class outsideTimerAction
    implements ActionListener {
        protected outsideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ConnectionHintManager.this.showImmediately = false;
        }
    }

    protected class insideTimerAction
    implements ActionListener {
        protected insideTimerAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ConnectionHintManager.this.mTargetWidget != null && ConnectionHintManager.this.mTargetWidget.isVisible()) {
                if (ConnectionHintManager.this.toolTipText == null) {
                    ConnectionHintManager.this.toolTipText = ConnectionHintManager.this.getHint();
                }
                if (ConnectionHintManager.this.toolTipText != null) {
                    ConnectionHintManager.this.showImmediately = true;
                    ConnectionHintManager.this.showTipWindow();
                } else {
                    ConnectionHintManager.this.mSourceWidget = null;
                    ConnectionHintManager.this.mTargetWidget = null;
                    ConnectionHintManager.this.toolTipText = null;
                    ConnectionHintManager.this.hideTipWindow();
                }
            }
        }
    }
}

