/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.actions;

import java.awt.Dialog;
import javax.swing.SwingUtilities;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;
import org.netbeans.modules.compapp.casaeditor.graph.CasaNodeWidget;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public final class EditablePropertiesAction
extends WidgetAction.Adapter {
    private Node mEditNode;

    public WidgetAction.State mousePressed(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        this.mEditNode = null;
        if (widgetMouseEvent.getButton() != 1) {
            return WidgetAction.State.REJECTED;
        }
        if (!(widget instanceof ImageWidget)) {
            return WidgetAction.State.REJECTED;
        }
        ((ImageWidget)widget).setPaintAsDisabled(true);
        while (widget instanceof CasaNodeWidget) {
            widget = widget.getParentWidget();
        }
        CasaModelGraphScene casaModelGraphScene = (CasaModelGraphScene)widget.getScene();
        CasaComponent casaComponent = (CasaComponent)casaModelGraphScene.findObject(widget);
        if (casaComponent == null) {
            return WidgetAction.State.REJECTED;
        }
        this.mEditNode = casaModelGraphScene.getNodeFactory().createNodeFor(casaComponent);
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        return WidgetAction.State.CONSUMED;
    }

    public WidgetAction.State mouseReleased(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        if (widget instanceof ImageWidget) {
            ((ImageWidget)widget).setPaintAsDisabled(false);
        }
        PropertySheet propertySheet = new PropertySheet();
        Node node = this.mEditNode;
        this.mEditNode = null;
        propertySheet.setNodes(new Node[]{node});
        Object[] objectArray = new Object[]{"Close"};
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertySheet, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"STR_PROPERTIES", (Object)node.getDisplayName()), true, objectArray, null, 0, null, null);
        dialogDescriptor.setClosingOptions(objectArray);
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                dialog.setVisible(true);
            }
        });
        return WidgetAction.State.CONSUMED;
    }

    public WidgetAction.State dragExit(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    public WidgetAction.State mouseExited(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    public WidgetAction.State mouseDragged(Widget widget, WidgetAction.WidgetMouseEvent widgetMouseEvent) {
        if (this.mEditNode == null) {
            return WidgetAction.State.REJECTED;
        }
        return WidgetAction.State.createLocked((Widget)widget, (WidgetAction)this);
    }

    protected boolean isLocked() {
        return this.mEditNode != null;
    }
}

