/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.graph.awt;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.netbeans.modules.compapp.casaeditor.graph.awt.Painter;
import org.netbeans.modules.compapp.casaeditor.graph.awt.RectangularPaintProvider;

public abstract class RectangularChainPainter
implements Painter {
    public static final int ARC_WIDTH = 4;
    public static final int ARC_HEIGHT = 4;
    private RectangularPaintProvider mProvider;
    private Painter mNextPainter;

    public RectangularChainPainter(RectangularPaintProvider rectangularPaintProvider, Painter painter) {
        this.mProvider = rectangularPaintProvider;
        this.mNextPainter = painter;
    }

    protected RectangularPaintProvider getProvider() {
        return this.mProvider;
    }

    public final void paint(Graphics2D graphics2D) {
        Rectangle rectangle = this.mProvider.getClipRect();
        Shape shape = graphics2D.getClip();
        if (this.mProvider.isRounded()) {
            graphics2D.clip(new RoundRectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 4.0f, 4.0f));
        } else {
            graphics2D.clip(new Rectangle2D.Float(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
        }
        this.chainPaint(graphics2D);
        if (this.mNextPainter != null) {
            this.mNextPainter.paint(graphics2D);
        }
        graphics2D.setClip(shape);
    }

    public abstract void chainPaint(Graphics2D var1);
}

