/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.model.casa.validator.visitor;

import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponentVisitor;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnection;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaConnections;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpoint;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaLink;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.model.casa.ConnectionState;
import org.netbeans.modules.compapp.casaeditor.model.casa.validator.CasaSemanticValidator;
import org.netbeans.modules.compapp.casaeditor.model.casa.validator.visitor.ValidateConfiguration;
import org.netbeans.modules.compapp.casaeditor.model.casa.validator.visitor.ValidateSupport;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CasaSemanticValidationVisitor
extends CasaComponentVisitor.Deep {
    private ValidateSupport mValidateSupport;
    public List<Validator.ResultItem> mResultItems;
    private Validation mValidation;
    private List<Model> mValidatedModels;
    private Validator mValidator;
    private static ValidateConfiguration mValConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CasaSemanticValidationVisitor(CasaSemanticValidator casaSemanticValidator, Validation validation, List<Model> list) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            mValConfig = new ValidateConfiguration();
            this.mResultItems = new Vector<Validator.ResultItem>();
        }
        this.mValidator = casaSemanticValidator;
        this.mValidation = validation;
        this.mValidatedModels = list;
        this.getValidateSupport().setValidator(this.mValidator);
        this.getValidateSupport().setResultItems(this.mResultItems);
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.mResultItems;
    }

    @Override
    public void visit(CasaConnections casaConnections) {
        HashSet<String> hashSet = new HashSet<String>();
        for (CasaConnection casaConnection : casaConnections.getConnections()) {
            if (casaConnection.getState().equals(ConnectionState.DELETED.getState())) continue;
            String string = casaConnection.getConsumer().getRefString();
            if (hashSet.contains(string)) {
                CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaConnections.getModel();
                CasaEndpointRef casaEndpointRef = casaWrapperModel.getCasaEndpointRef(casaConnection, true);
                CasaEndpoint casaEndpoint = (CasaEndpoint)casaConnection.getConsumer().get();
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)casaEndpointRef, NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"ONE_CONSUMER_MULTIPLE_PROVIDERS", (Object)casaEndpoint.toString()), NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"FIX_ONE_CONSUMER_MULTIPLE_PROVIDERS"));
                continue;
            }
            hashSet.add(string);
        }
    }

    @Override
    public void visit(CasaConnection casaConnection) {
        if (casaConnection.getState().equals(ConnectionState.DELETED.getState())) {
            return;
        }
        CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaConnection.getModel();
        NamedComponentReference<CasaEndpoint> namedComponentReference = casaConnection.getConsumer();
        NamedComponentReference<CasaEndpoint> namedComponentReference2 = casaConnection.getProvider();
        if (namedComponentReference != null && namedComponentReference2 != null) {
            QName qName;
            QName qName2;
            CasaEndpoint casaEndpoint = (CasaEndpoint)namedComponentReference.get();
            CasaEndpoint casaEndpoint2 = (CasaEndpoint)namedComponentReference2.get();
            CasaEndpointRef casaEndpointRef = casaWrapperModel.getCasaEndpointRef(casaConnection, true);
            CasaEndpointRef casaEndpointRef2 = casaWrapperModel.getCasaEndpointRef(casaConnection, false);
            if (namedComponentReference.getRefString().equals(namedComponentReference2.getRefString())) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)casaEndpointRef, NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"SELF_CONNECTION"), NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"FIX_SELF_CONNECTION"));
            }
            if (!(qName2 = casaEndpoint.getInterfaceQName()).equals(qName = casaEndpoint2.getInterfaceQName())) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)casaEndpointRef, NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"ENDPOINTS_WITH_DIFFERENT_INTERFACES", (Object)qName2, (Object)qName), NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"FIX_ENDPOINTS_WITH_DIFFERENT_INTERFACES"));
            }
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = casaWrapperModel.getCasaEngineServiceUnit(casaEndpointRef);
            CasaServiceEngineServiceUnit casaServiceEngineServiceUnit2 = casaWrapperModel.getCasaEngineServiceUnit(casaEndpointRef2);
            if (casaServiceEngineServiceUnit != null && casaServiceEngineServiceUnit2 != null && !casaServiceEngineServiceUnit.isInternal() && !casaServiceEngineServiceUnit2.isInternal()) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)casaEndpointRef, NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"CONNECTING_TWO_EXTERNAL_ENDPOINTS", (Object)qName2, (Object)qName), NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"FIX_CONNECTING_TWO_EXTERNAL_ENDPOINTS"));
            }
        }
    }

    @Override
    public void visit(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaServiceEngineServiceUnit.getModel();
        for (CasaEndpointRef casaEndpointRef : casaServiceEngineServiceUnit.getEndpoints()) {
            CasaEndpoint casaEndpoint = (CasaEndpoint)casaEndpointRef.getEndpoint().get();
            QName qName = casaEndpoint.getInterfaceQName();
            PortType portType = casaWrapperModel.getPortType(qName);
            if (portType != null) continue;
            this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)casaServiceEngineServiceUnit, NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"SERVICE_ENGINE_SERVICE_UNIT_WSDL_NOT_AVAILABLE", (Object)casaEndpoint.toString()), NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"FIX_SERVICE_ENGINE_SERVICE_UNIT_WSDL_NOT_AVAILABLE"));
        }
    }

    @Override
    public void visit(CasaLink casaLink) {
        CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaLink.getModel();
        String string = casaLink.getHref();
        try {
            Port port = casaWrapperModel.getWSDLComponentFromXLinkHref(string, Port.class);
            if (port == null) {
                this.getValidateSupport().fireToDo(Validator.ResultType.ERROR, (Component)casaLink, NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"WSDL_COMPONENT_NOT_AVAILABLE", (Object)string), NbBundle.getMessage(CasaSemanticValidationVisitor.class, (String)"FIX_WSDL_COMPONENT_NOT_AVAILABLE"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ValidateSupport getValidateSupport() {
        if (null == this.mValidateSupport) {
            this.mValidateSupport = new ValidateSupport(mValConfig);
        }
        return this.mValidateSupport;
    }

    public Validation getValidation() {
        return this.mValidation;
    }

    public void setValidation(Validation validation) {
        this.mValidation = validation;
    }
}

