/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.model.jbi.impl;

import org.netbeans.modules.compapp.casaeditor.model.jbi.Connection;
import org.netbeans.modules.compapp.casaeditor.model.jbi.Connections;
import org.netbeans.modules.compapp.casaeditor.model.jbi.Consumer;
import org.netbeans.modules.compapp.casaeditor.model.jbi.Consumes;
import org.netbeans.modules.compapp.casaeditor.model.jbi.ExtensibilityElement;
import org.netbeans.modules.compapp.casaeditor.model.jbi.Identification;
import org.netbeans.modules.compapp.casaeditor.model.jbi.JBI;
import org.netbeans.modules.compapp.casaeditor.model.jbi.JBIComponent;
import org.netbeans.modules.compapp.casaeditor.model.jbi.JBIComponentFactory;
import org.netbeans.modules.compapp.casaeditor.model.jbi.JBIModel;
import org.netbeans.modules.compapp.casaeditor.model.jbi.Provider;
import org.netbeans.modules.compapp.casaeditor.model.jbi.Provides;
import org.netbeans.modules.compapp.casaeditor.model.jbi.ServiceAssembly;
import org.netbeans.modules.compapp.casaeditor.model.jbi.ServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.jbi.Services;
import org.netbeans.modules.compapp.casaeditor.model.jbi.Target;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ConnectionImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ConnectionsImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ConsumerImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ConsumesImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.IdentificationImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.JBIImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.JBIQNames;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ProviderImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ProvidesImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ServiceAssemblyImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ServiceUnitImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.ServicesImpl;
import org.netbeans.modules.compapp.casaeditor.model.jbi.impl.TargetImpl;
import org.netbeans.modules.compapp.casaeditor.model.visitor.JBIVisitor;
import org.netbeans.modules.xml.xam.dom.AbstractDocumentComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JBIComponentFactoryImpl
implements JBIComponentFactory {
    private JBIModel model;

    public JBIComponentFactoryImpl(JBIModel jBIModel) {
        this.model = jBIModel;
    }

    public JBIComponent create(Element element, JBIComponent jBIComponent) {
        return new JBICreateVisitor().create(element, jBIComponent);
    }

    public JBI createJBI() {
        return new JBIImpl(this.model);
    }

    public Services createServices() {
        return new ServicesImpl(this.model);
    }

    public Consumes createConsumes() {
        return new ConsumesImpl(this.model);
    }

    public Provides createProvides() {
        return new ProvidesImpl(this.model);
    }

    public ServiceAssembly createServiceAssembly() {
        return new ServiceAssemblyImpl(this.model);
    }

    public ServiceUnit createServiceUnit() {
        return new ServiceUnitImpl(this.model);
    }

    public Connections createConnections() {
        return new ConnectionsImpl(this.model);
    }

    public Connection createConnection() {
        return new ConnectionImpl(this.model);
    }

    public Consumer createConsumer() {
        return new ConsumerImpl(this.model);
    }

    public Provider createProvider() {
        return new ProviderImpl(this.model);
    }

    public Identification createIdentification() {
        return new IdentificationImpl(this.model);
    }

    public Target createTarget() {
        return new TargetImpl(this.model);
    }

    public static class JBICreateVisitor
    extends JBIVisitor.Default {
        Element element;
        JBIComponent created;

        JBIComponent create(Element element, JBIComponent jBIComponent) {
            this.element = element;
            jBIComponent.accept(this);
            return this.created;
        }

        private boolean isElementQName(JBIQNames jBIQNames) {
            return JBICreateVisitor.areSameQName(jBIQNames, this.element);
        }

        public static boolean areSameQName(JBIQNames jBIQNames, Element element) {
            return jBIQNames.getQName().equals(AbstractDocumentComponent.getQName((Node)element));
        }

        public void visit(JBI jBI) {
            if (this.isElementQName(JBIQNames.SERVICES)) {
                this.created = new ServicesImpl(jBI.getModel(), this.element);
            } else if (this.isElementQName(JBIQNames.SERVICE_ASSEMBLY)) {
                this.created = new ServiceAssemblyImpl(jBI.getModel(), this.element);
            }
        }

        public void visit(Services services) {
            if (this.isElementQName(JBIQNames.CONSUMES)) {
                this.created = new ConsumesImpl(services.getModel(), this.element);
            } else if (this.isElementQName(JBIQNames.PROVIDES)) {
                this.created = new ProvidesImpl(services.getModel(), this.element);
            }
        }

        public void visit(ServiceAssembly serviceAssembly) {
            if (this.isElementQName(JBIQNames.SERVICE_UNIT)) {
                this.created = new ServiceUnitImpl(serviceAssembly.getModel(), this.element);
            } else if (this.isElementQName(JBIQNames.CONNECTIONS)) {
                this.created = new ConnectionsImpl(serviceAssembly.getModel(), this.element);
            } else if (this.isElementQName(JBIQNames.IDENTIFICATION)) {
                this.created = new IdentificationImpl(serviceAssembly.getModel(), this.element);
            }
        }

        public void visit(ServiceUnit serviceUnit) {
            JBIModel jBIModel = serviceUnit.getModel();
            if (this.isElementQName(JBIQNames.IDENTIFICATION)) {
                this.created = new IdentificationImpl(jBIModel, this.element);
            } else if (this.isElementQName(JBIQNames.TARGET)) {
                this.created = new TargetImpl(jBIModel, this.element);
            }
        }

        public void visit(Connections connections) {
            if (this.isElementQName(JBIQNames.CONNECTION)) {
                this.created = new ConnectionImpl(connections.getModel(), this.element);
            }
        }

        public void visit(Connection connection) {
            if (this.isElementQName(JBIQNames.CONSUMER)) {
                this.created = new ConsumerImpl(connection.getModel(), this.element);
            } else if (this.isElementQName(JBIQNames.PROVIDER)) {
                this.created = new ProviderImpl(connection.getModel(), this.element);
            }
        }

        public void visit(ExtensibilityElement extensibilityElement) {
        }
    }
}

