/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.multiview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.compapp.casaeditor.CasaDataEditorSupport;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.design.CasaDesignView;
import org.netbeans.modules.compapp.casaeditor.graph.CasaFactory;
import org.netbeans.modules.compapp.casaeditor.graph.RegionUtilities;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaComponent;
import org.netbeans.modules.compapp.casaeditor.multiview.CasaMultiViewFactory;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNodeFactory;
import org.netbeans.modules.compapp.casaeditor.palette.CasaPalette;
import org.netbeans.modules.xml.xam.ui.multiview.ActivatedNodesMediator;
import org.netbeans.modules.xml.xam.ui.multiview.CookieProxyLookup;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class CasaGraphMultiViewElement
extends TopComponent
implements MultiViewElement {
    static final long serialVersionUID = -665273878020879395L;
    public static final String PREFERRED_ID = "CasaGraphMultiViewElementTC";
    private CasaDataObject mDataObject;
    private CasaDesignView mDesignView;
    private transient MultiViewElementCallback multiViewObserver;
    private transient JLabel errorLabel = new JLabel();
    private transient JToolBar mToolbar;
    private GetAndResetFlag mLookAndFeelRenderFlag = new GetAndResetFlag();

    public CasaGraphMultiViewElement() {
    }

    public CasaGraphMultiViewElement(CasaDataObject casaDataObject) {
        this.mDataObject = casaDataObject;
        this.initializeLookup();
        this.initializeUI();
    }

    public void addNotify() {
        super.addNotify();
        this.mDesignView.render();
    }

    private CasaDataObject getCasaDataObject() {
        return this.mDataObject;
    }

    private void initializeLookup() {
        ActionMap actionMap = this.getActionMap();
        Node node = this.mDataObject.getNodeDelegate();
        ActivatedNodesMediator activatedNodesMediator = new ActivatedNodesMediator(node);
        CookieProxyLookup cookieProxyLookup = new CookieProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{actionMap, this.mDataObject}), Lookups.singleton((Object)CasaPalette.getPalette(Lookups.fixed((Object[])new Object[]{this.mDataObject, node}))), activatedNodesMediator.getLookup(), Lookups.singleton((Object)((Object)this)), node.getLookup()}, node);
        this.associateLookup((Lookup)cookieProxyLookup);
        this.addPropertyChangeListener("activatedNodes", (PropertyChangeListener)activatedNodesMediator);
        this.addPropertyChangeListener("activatedNodes", (PropertyChangeListener)cookieProxyLookup);
    }

    private void initializeUI() {
        this.setLayout(new BorderLayout());
        this.mDesignView = new CasaDesignView(this.mDataObject);
        this.add(this.mDesignView.getComponent(), "Center");
    }

    public int getPersistenceType() {
        return 2;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewObserver = multiViewElementCallback;
    }

    public CloseOperationState canCloseElement() {
        if (!CasaDataEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_TEXT_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public void componentClosed() {
        super.componentClosed();
        if (this.mDesignView != null) {
            this.mDesignView.closeView();
            this.mDesignView = null;
        }
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void componentHidden() {
        super.componentHidden();
    }

    public void componentActivated() {
        super.componentActivated();
        CasaMultiViewFactory.updateGroupVisibility("casa-graphview");
        if (this.mLookAndFeelRenderFlag.isSet()) {
            CasaFactory.getCasaCustomizer().renderCasaDesignView(this.mDesignView.getScene());
        }
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        CasaMultiViewFactory.updateGroupVisibility("casa-graphview");
    }

    public void componentShowing() {
        super.componentShowing();
        if (this.mLookAndFeelRenderFlag.isSet()) {
            CasaFactory.getCasaCustomizer().renderCasaDesignView(this.mDesignView.getScene());
        }
        new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (CasaGraphMultiViewElement.this.mDesignView != null && CasaGraphMultiViewElement.this.mDesignView.getScene() != null) {
                            RegionUtilities.stretchScene(CasaGraphMultiViewElement.this.mDesignView.getScene());
                        }
                    }
                });
            }
        }).start();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public JComponent getToolbarRepresentation() {
        if (this.mToolbar == null) {
            this.mToolbar = this.mDesignView.getToolBar();
            this.mToolbar.setFloatable(false);
            int n = 0;
            for (Component component : this.mToolbar.getComponents()) {
                if (!(component instanceof JButton) && !(component instanceof JToggleButton)) continue;
                n = Math.max(component.getPreferredSize().height, n);
            }
            for (Component component : this.mToolbar.getComponents()) {
                Dimension dimension;
                if (component instanceof JButton || component instanceof JToggleButton) {
                    dimension = component.getMaximumSize();
                    dimension.height = n;
                    component.setMaximumSize(dimension);
                    component.setMinimumSize(component.getPreferredSize());
                    continue;
                }
                if (component instanceof JTextComponent) {
                    component.setMaximumSize(component.getPreferredSize());
                    component.setMinimumSize(component.getPreferredSize());
                    continue;
                }
                if (component instanceof JSlider) {
                    dimension = component.getMaximumSize();
                    dimension.width = 160;
                    component.setMaximumSize(dimension);
                    dimension = component.getPreferredSize();
                    dimension.width = 160;
                    component.setPreferredSize(dimension);
                    continue;
                }
                component.setMinimumSize(component.getPreferredSize());
            }
        }
        return this.mToolbar;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public TopComponent getComponent() {
        return this;
    }

    public void scheduleLookAndFeelRender() {
        this.mLookAndFeelRenderFlag.set();
    }

    public void select(CasaComponent casaComponent) {
        CasaNodeFactory casaNodeFactory = this.mDesignView.getScene().getNodeFactory();
        CasaNode casaNode = casaNodeFactory.createNodeFor(casaComponent);
        if (casaNode != null) {
            this.setActivatedNodes(new Node[]{casaNode});
        }
        this.requestVisible();
    }

    private static class GetAndResetFlag {
        private boolean mFlag = false;

        public void set() {
            this.mFlag = true;
        }

        public boolean isSet() {
            boolean bl = this.mFlag;
            this.mFlag = false;
            return bl;
        }
    }
}

