/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.multiview;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.compapp.casaeditor.CasaDataEditorSupport;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.multiview.CasaMultiViewFactory;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class CasaSourceMultiViewElement
extends CloneableEditor
implements MultiViewElement {
    static final long serialVersionUID = -2074288729483750516L;
    private transient JComponent toolbar;
    private transient MultiViewElementCallback multiViewObserver;
    private CasaDataObject mDataObject;

    public CasaSourceMultiViewElement() {
    }

    public CasaSourceMultiViewElement(CasaDataObject casaDataObject) {
        super((CloneableEditorSupport)casaDataObject.getEditorSupport());
        this.mDataObject = casaDataObject;
        this.setActivatedNodes(new Node[]{this.mDataObject.getNodeDelegate()});
        this.mDataObject.getEditorSupport().initializeCloneableEditor(this);
        this.initialize();
    }

    public JComponent getToolbarRepresentation() {
        Document document;
        if (this.getEditorPane() != null && (document = this.getEditorPane().getDocument()) instanceof NbDocument.CustomToolbar) {
            if (this.toolbar == null) {
                this.toolbar = ((NbDocument.CustomToolbar)document).createToolbar(this.getEditorPane());
            }
            return this.toolbar;
        }
        return null;
    }

    public JComponent getVisualRepresentation() {
        return this;
    }

    public void setMultiViewCallback(MultiViewElementCallback multiViewElementCallback) {
        this.multiViewObserver = multiViewElementCallback;
    }

    public void requestVisible() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestVisible();
        } else {
            super.requestVisible();
        }
    }

    public void requestActive() {
        if (this.multiViewObserver != null) {
            this.multiViewObserver.requestActive();
        } else {
            super.requestActive();
        }
    }

    protected String preferredID() {
        return "CasaSourceMultiViewElementTC";
    }

    public UndoRedo getUndoRedo() {
        return null;
    }

    protected boolean closeLast() {
        CasaDataEditorSupport casaDataEditorSupport = this.mDataObject.getEditorSupport();
        JEditorPane[] jEditorPaneArray = casaDataEditorSupport.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length == 0) {
            return casaDataEditorSupport.silentClose();
        }
        return false;
    }

    public CloseOperationState canCloseElement() {
        if (!CasaDataEditorSupport.isLastView(this.multiViewObserver.getTopComponent())) {
            return CloseOperationState.STATE_OK;
        }
        return MultiViewFactory.createUnsafeCloseState((String)"ID_TEXT_CLOSING", (Action)MultiViewFactory.NOOP_CLOSE_ACTION, (Action)MultiViewFactory.NOOP_CLOSE_ACTION);
    }

    public void componentDeactivated() {
        super.componentDeactivated();
        CasaDataEditorSupport casaDataEditorSupport = this.mDataObject.getEditorSupport();
        if (this.mDataObject.isModified()) {
            casaDataEditorSupport.syncModel();
        }
        CasaMultiViewFactory.updateGroupVisibility("casa-sourceview");
    }

    public void componentActivated() {
        super.componentActivated();
        CasaMultiViewFactory.updateGroupVisibility("casa-sourceview");
    }

    public void componentClosed() {
        super.componentClosed();
    }

    public void componentShowing() {
        super.componentShowing();
    }

    public void componentHidden() {
        super.componentHidden();
        CasaDataEditorSupport casaDataEditorSupport = this.mDataObject.getEditorSupport();
        if (this.mDataObject.isModified()) {
            casaDataEditorSupport.syncModel();
        }
    }

    public void componentOpened() {
        super.componentOpened();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject((Object)this.mDataObject);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        Object object = objectInput.readObject();
        if (object instanceof CasaDataObject) {
            this.mDataObject = (CasaDataObject)((Object)object);
            this.initialize();
        }
    }

    private void initialize() {
        ProxyLookup proxyLookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this.getActionMap(), this.mDataObject}), this.mDataObject.getNodeDelegate().getLookup()});
        this.associateLookup((Lookup)proxyLookup);
    }

    protected boolean isActiveTC() {
        return CasaSourceMultiViewElement.getRegistry().getActivated() == this.multiViewObserver.getTopComponent();
    }
}

