/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.modules.compapp.casaeditor.CasaDataObject;
import org.netbeans.modules.compapp.casaeditor.design.CasaModelGraphScene;

public class CasaSatelliteContentPanel
extends JPanel {
    private SatelliteTracker mTracker = new SatelliteTracker();

    public CasaSatelliteContentPanel() {
        this.setLayout(new BorderLayout());
    }

    public void navigate(CasaDataObject casaDataObject) {
        if (casaDataObject == null && this.mTracker.hasSatelliteComponent()) {
            this.removeAll();
        }
        if (casaDataObject == null) {
            return;
        }
        CasaModelGraphScene casaModelGraphScene = casaDataObject.getEditorSupport().getScene();
        if (casaModelGraphScene != null) {
            boolean bl = false;
            if (!this.mTracker.isSameScene((Scene)casaModelGraphScene)) {
                bl = true;
                this.removeAll();
            }
            if (!this.mTracker.hasSatelliteComponent() || bl) {
                JComponent jComponent = this.mTracker.newSatelliteComponent((Scene)casaModelGraphScene);
                this.add((Component)jComponent, "Center");
                this.revalidate();
            }
        }
    }

    private static class SatelliteTracker {
        private Scene mScene;
        private JComponent mSatelliteComponent;

        private SatelliteTracker() {
        }

        public boolean isSameScene(Scene scene) {
            return this.mScene != null && this.mScene == scene;
        }

        public boolean hasSatelliteComponent() {
            return this.mSatelliteComponent != null;
        }

        public JComponent newSatelliteComponent(Scene scene) {
            this.mScene = scene;
            this.mSatelliteComponent = this.mScene.createSatelliteView();
            return this.mSatelliteComponent;
        }
    }
}

