/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.casaeditor.nodes.actions;

import java.util.ArrayList;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaEndpointRef;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaServiceEngineServiceUnit;
import org.netbeans.modules.compapp.casaeditor.model.casa.CasaWrapperModel;
import org.netbeans.modules.compapp.casaeditor.nodes.CasaNode;
import org.netbeans.modules.compapp.casaeditor.nodes.EndpointNode;
import org.netbeans.modules.compapp.casaeditor.nodes.ServiceUnitProcessNode;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;

public class GoToSourceAction
extends NodeAction {
    protected void performAction(Node[] nodeArray) {
        CasaEndpointRef casaEndpointRef;
        CasaNode casaNode;
        if (nodeArray.length < 1) {
            return;
        }
        CasaServiceEngineServiceUnit casaServiceEngineServiceUnit = null;
        String string = null;
        if (nodeArray[0] instanceof ServiceUnitProcessNode) {
            casaNode = (ServiceUnitProcessNode)nodeArray[0];
            casaServiceEngineServiceUnit = ((ServiceUnitProcessNode)casaNode).getServiceEngineServiceUnit();
            string = ((ServiceUnitProcessNode)casaNode).getFilePath();
        } else if (nodeArray[0] instanceof EndpointNode) {
            casaNode = (EndpointNode)nodeArray[0];
            casaEndpointRef = (CasaEndpointRef)casaNode.getData();
            casaServiceEngineServiceUnit = (CasaServiceEngineServiceUnit)casaEndpointRef.getParent();
            string = casaEndpointRef.getFilePath();
        }
        if (casaServiceEngineServiceUnit != null && string != null) {
            casaNode = this.getOwnerProject(casaServiceEngineServiceUnit);
            casaEndpointRef = casaNode.getProjectDirectory();
            if (string != null && string.length() > 0) {
                string = "src/" + string;
                FileObject fileObject = casaEndpointRef.getFileObject(string);
                try {
                    final DataObject dataObject = DataObject.find((FileObject)fileObject);
                    EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
                    if (editCookie != null) {
                        editCookie.edit();
                    } else {
                        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                        if (editorCookie != null) {
                            editorCookie.open();
                        } else {
                            OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
                            if (openCookie != null) {
                                openCookie.open();
                            }
                        }
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            GoToSourceAction.this.requestViewOpen(dataObject);
                        }
                    });
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    dataObjectNotFoundException.printStackTrace();
                }
            }
        }
    }

    private void requestViewOpen(DataObject dataObject) {
        TopComponent topComponent;
        ArrayList<TopComponent> arrayList = new ArrayList<TopComponent>();
        TopComponent topComponent2 = TopComponent.getRegistry().getActivated();
        if (dataObject == (DataObject)topComponent2.getLookup().lookup(DataObject.class)) {
            arrayList.add(topComponent2);
        }
        Set set = TopComponent.getRegistry().getOpened();
        for (Object object : set) {
            topComponent = (TopComponent)object;
            if (dataObject != (DataObject)topComponent.getLookup().lookup(DataObject.class)) continue;
            arrayList.add(topComponent);
        }
        for (TopComponent topComponent3 : arrayList) {
            MultiViewPerspective[] multiViewPerspectiveArray;
            topComponent = MultiViews.findMultiViewHandler((TopComponent)topComponent3);
            if (topComponent == null) continue;
            for (MultiViewPerspective multiViewPerspective : multiViewPerspectiveArray = topComponent.getPerspectives()) {
                if (multiViewPerspective.preferredID().toLowerCase().contains("source")) continue;
                topComponent.requestActive(multiViewPerspective);
                return;
            }
        }
    }

    protected boolean enable(Node[] nodeArray) {
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(GoToSourceAction.class, (String)"LBL_GoToSourceAction_Name");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private Project getOwnerProject(CasaServiceEngineServiceUnit casaServiceEngineServiceUnit) {
        CasaWrapperModel casaWrapperModel = (CasaWrapperModel)casaServiceEngineServiceUnit.getModel();
        String string = casaServiceEngineServiceUnit.getUnitName();
        Project project = casaWrapperModel.getJBIProject();
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        for (Project project2 : subprojectProvider.getSubprojects()) {
            ProjectInformation projectInformation = (ProjectInformation)project2.getLookup().lookup(ProjectInformation.class);
            if (!projectInformation.getName().equals(string)) continue;
            return project2;
        }
        return null;
    }
}

